package com.hippoagent.encription.jsevaluator.interfaces;


import com.hippoagent.encription.JsCallback;

public interface JsEvaluatorInterface {
	/**
	 * Evaluates JavaScript code and passes result on UI thread.
	 *
	 * @param  jsCode           JavaScript code to evaluate.
	 * @param  resultCallback   callback to receive the result form JavaScript function. It is called on UI thread.
	 */
	public void evaluateAndRespondOnUiThread(String jsCode, JsCallback resultCallback);

	/**
	 * Evaluates JavaScript code and passes result on background thread.
	 *
	 * @param  jsCode           JavaScript code to evaluate.
	 * @param  resultCallback   callback to receive the result form JavaScript function. It is called on background thread.
	 */
	public void evaluateAndRespondOnBackgroundThread(String jsCode, JsCallback resultCallback);

	/**
	 * Evaluates JavaScript code and returns the result. UI thread will be blocked during JavaScript evaluation and the app will appear frozen to the user.
	 *
	 * @param  waitTimeoutMilliseconds  wait time in milliseconds. The function will return null if it fails to evaluate JavaScript within the given time period.
	 * @param  jsCode                   JavaScript code to evaluate.
	 * @return                          result of JavaScript evaluation. The function will return null if it fails to evaluate JavaScript within the given time period.
	 */
	public String blockUIThreadAndEvaluate(long waitTimeoutMilliseconds, String jsCode);

	/**
	 * Calls a JavaScript function and pass arguments to it. Result of evaluation is passed on UI thread.
	 *
	 * @param  jsCode           JavaScript code to evaluate.
	 * @param  resultCallback   callback to receive the result form JavaScript function. It is called on UI thread.
	 * @param  functionName     name of the JavaScript function to be called.
	 * @param  args             any number of string, integer or double arguments that will be passed to the JavaScript function.
	 */
	public void callFunctionAndRespondOnUiThread(String jsCode, JsCallback resultCallback, String functionName, Object... args);

	/**
	 * Calls a JavaScript function and pass arguments to it. Result of evaluation is passed on background thread.
	 *
	 * @param  jsCode           JavaScript code to evaluate.
	 * @param  resultCallback   callback to receive the result form JavaScript function. It is called on background thread.
	 * @param  functionName     name of the JavaScript function to be called.
	 * @param  args             any number of string, integer or double arguments that will be passed to the JavaScript function.
	 */
	public void callFunctionAndRespondOnBackgroundThread(String jsCode, JsCallback resultCallback, String functionName, Object... args);

	/**
	 * Calls a JavaScript function and returns the result. UI thread will be blocked during JavaScript evaluation and the app will appear frozen to the user.
	 *
	 * @param  waitTimeoutMilliseconds  wait time in milliseconds. The function will return null if it fails to evaluate JavaScript within the given time period.
	 * @param  jsCode                   JavaScript code to evaluate.
	 * @param  functionName             name of the JavaScript function to be called.
	 * @param  args                     any number of string, integer or double arguments that will be passed to the JavaScript function.
	 */
	public String blockUIThreadAndCallFunction(long waitTimeoutMilliseconds, String jsCode, String functionName, Object... args);
}

/*public interface JsEvaluatorInterface {
	public void callFunction(String jsCode, JsCallback resultCallback, String name, Object... args);

	public void evaluate(String jsCode);

	public void evaluate(String jsCode, JsCallback resultCallback);

	// Destroys the web view in order to free the memory.
	// The web view can not be accessed after is has been destroyed.
	public void destroy();

	// Returns the WebView object
	public WebView getWebView();
}*/
