package com.hippoagent.fcm

import android.annotation.TargetApi
import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Color
import android.graphics.drawable.Drawable
import android.media.AudioAttributes
import android.os.Build
import android.provider.Settings
import android.text.Html
import android.text.TextUtils
import android.view.View
import androidx.core.app.NotificationCompat
import androidx.core.app.Person
import androidx.core.app.RemoteInput
import com.bumptech.glide.Glide
import com.bumptech.glide.request.target.CustomTarget
import com.bumptech.glide.request.transition.Transition
import com.hippoagent.R
import com.hippoagent.appData.AppManager
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.utils.DateUtils
import com.hippoagent.utils.PushIntentService
import org.json.JSONObject
import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.ArrayList

/**
 * Created by gurmail on 03/05/19.
 * @author gurmail
 */
class PushHandler : FuguAppConstant {

    val NOTIFICATION_CHANNEL_ID = "12001"
    val CHANNEL_ONE_NAME = "Default notification"
    var KEY_REPLY = "key_reply"
    private val BK_SOUND_TIME = 15
    private var notificationSoundEnabled: Boolean = false

    fun notificationHelper(context: Context, data: JSONObject, notificationSoundEnabled: Boolean) {
        var messageJson = data
        this.notificationSoundEnabled = notificationSoundEnabled;
        showNewConversation(context, data)
    }

    fun notificationAnnouncementHelper(context: Context, data: JSONObject, notificationSoundEnabled: Boolean) {
        this.notificationSoundEnabled = notificationSoundEnabled;
        var imageUrl = ""

        try {
            imageUrl = data.optJSONObject("custom_attributes").optJSONObject("image").optString("image_url", "")
        } catch (e: java.lang.Exception) {
        }

        if (!TextUtils.isEmpty(imageUrl)) {
            bigImageNotifAsync(context, data, imageUrl)
        } else {
            showAnnouncement(context, data, null)
        }
    }

    fun notificationCustomerHelper(context: Context, data: JSONObject, notificationSoundEnabled: Boolean) {
        var messageJson = data
        this.notificationSoundEnabled = notificationSoundEnabled;
        showCustomerConversation(context, data)
    }

    fun notificationMissedCall(context: Context, data: JSONObject) {
        showMissedCall(context, data)
    }

    fun notificationVerify(context: Context, data: JSONObject) {
        showVerification(context, data)
    }


    object Reply {
        internal var KEY_REPLY = "key_reply"
        fun getReplyMessage(intent: Intent): CharSequence? {
            val remoteInput = RemoteInput.getResultsFromIntent(intent)
            return remoteInput?.getCharSequence(KEY_REPLY)
        }
    }

    fun recreatePush(context: Context, channelId: Int, sendingMessage: String) {
        val notificationList = NotificationDatabase.getNotifications(channelId)
        val pushData: PushNotification = notificationList[0]

        val data = JSONObject()
        data.put("channel_id", pushData.channelId)
        data.put("push_message", sendingMessage)
        data.put("title", pushData.title)
        data.put("date_time", pushData.dateTime)
        data.put("user_id", pushData.userID)
        data.put("disable_reply", pushData.disableReply)
        data.put("label", pushData.label)
        data.put("is_recreated", true)


        val channelId = pushData.channelId
        var title: String = "Message sending failed!"
        val message: String = sendingMessage
        val timeStamp = pushData.dateTime
        val icon = R.mipmap.ic_launcher


        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("json", data.toString())
        notificationIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK

        val pi = PendingIntent.getService(context, data.getLong(FuguAppConstant.CHANNEL_ID).toInt(), notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
        var mBuilder: NotificationCompat.Builder
        mBuilder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        val retryIntent = Intent(context, RetryIntentService::class.java)
        retryIntent.putExtra("json", data.toString())
        retryIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK

        val rpi = PendingIntent.getService(context, channelId, retryIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        val cancelIntent = Intent(context, CancelIntentService::class.java)
        cancelIntent.putExtra("channel_id", channelId)
        val cpi = PendingIntent.getService(context, channelId, cancelIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)


        val replyAction = NotificationCompat.Action.Builder(
                android.R.drawable.sym_action_chat, "RETRY", rpi)
                .build()

        val cancelAction = NotificationCompat.Action.Builder(
                android.R.drawable.sym_action_chat, "CANCEL", cpi)
                .build()


        val inboxStyle = NotificationCompat.InboxStyle()
        inboxStyle.addLine(message)


        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setStyle(inboxStyle)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.setPriority(getPriority())
        mBuilder.setAutoCancel(true)
        mBuilder.addAction(replyAction)
        mBuilder.addAction(cancelAction)
        mBuilder.setDeleteIntent(cpi)


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            notificationChannel.enableVibration(true)
            notificationChannel.vibrationPattern = longArrayOf(100, 200, 300, 400, 500, 400, 300, 200, 400)
            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)

            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }

        }
        notificationManager.notify(channelId, notification)
    }

    private fun showCustomerConversation(context: Context, data: JSONObject) {
        val channelId = data.optInt("channel_id", -1)
        val message: String = data.optString("new_message")
        val title: String = data.optString("title")
        val timeStamp = data.optString("date_time")
        val userId = data.optInt("user_id", -1)
        val disableReply = data.optInt("disable_reply", 0)
        val label = data.optString("label", "User")
        val sendName = data.optString("last_sent_by_full_name", "")
        val icon = R.mipmap.ic_launcher

        var notificationList = ArrayList<PushNotification>()
        notificationList = NotificationDatabase.getNotifications(channelId)
        notificationList.add(PushNotification(channelId, message, timeStamp, title, userId, disableReply, label))
        NotificationDatabase.setNotification(channelId, notificationList)

        val cancelIntent = Intent(context, CancelIntentService::class.java)
        cancelIntent.putExtra("channel_id", channelId)
        val dismissPi = PendingIntent.getService(context, channelId, cancelIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("channelId", channelId)
        notificationIntent.putExtra("label", label)
        notificationIntent.putExtra("disable_reply", disableReply)
        notificationIntent.putExtra("user_id", userId)

        notificationIntent.putExtra("json", data.toString())

        val pi = PendingIntent.getService(context, data.getLong(FuguAppConstant.CHANNEL_ID).toInt(), notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
//        //Initialise RemoteInput
//        val remoteInput = RemoteInput.Builder(KEY_REPLY)
//                .setLabel("Enter your reply here")
//                .build()
//
//        //Notification Action with RemoteInput instance added.
//        val replyAction = NotificationCompat.Action.Builder(
//                android.R.drawable.sym_action_chat, "REPLY", pi)
//                .addRemoteInput(remoteInput)
//                .setAllowGeneratedReplies(true)
//                .build()

        var mBuilder: NotificationCompat.Builder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        val notificationListToBeDisplayed = ArrayList<PushNotification>()

        var maxLines = 6

        for (i in notificationList.indices) {
            notificationListToBeDisplayed.add(notificationList[i])
        }
        var i = 0
        val sender = Person.Builder().setName(sendName).setIcon(null).build()
        val messageStyle = NotificationCompat.MessagingStyle(sender)
        while (i < notificationListToBeDisplayed.size) {
            val senderPerson = Person.Builder()
                    .setName(sendName)
                    .setIcon(null)
                    .build()

            val senderMessage = NotificationCompat.MessagingStyle.Message(Html.fromHtml(notificationListToBeDisplayed[i].message),
                    Date().time, senderPerson)

            messageStyle.addMessage(senderMessage)
            ++i
        }

        messageStyle.conversationTitle = title
        messageStyle.build()

        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setStyle(messageStyle)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        if (notificationSoundEnabled)
            mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.setPriority(getPriority())
        mBuilder.setAutoCancel(true)
        mBuilder.setDeleteIntent(dismissPi)


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            if (notificationSoundEnabled) {
                notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, getRingtoneAudioAttributes())
            }
            notificationChannel.enableVibration(true)
            notificationChannel.vibrationPattern = longArrayOf(100, 200, 300, 400, 500, 400, 300, 200, 400)

            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }
        }

        notificationManager.notify(channelId, notification)
    }

    private fun showNewConversation(context: Context, data: JSONObject) {

        val channelId = data.optInt("channel_id", -1)
        val message: String = data.optString("new_message")
        val title: String = data.optString("title")
        val timeStamp = data.optString("date_time")
        val userId = data.optInt("user_id", -1)
        val disableReply = data.optInt("disable_reply", 0)
        val label = data.optString("label", "User")
        val sendName = data.optString("last_sent_by_full_name", "")
        val icon = R.mipmap.ic_launcher

        var notificationList = ArrayList<PushNotification>()
        notificationList = NotificationDatabase.getNotifications(channelId)
        notificationList.add(PushNotification(channelId, message, timeStamp, title, userId, disableReply, label))
        NotificationDatabase.setNotification(channelId, notificationList)

        val cancelIntent = Intent(context, CancelIntentService::class.java)
        cancelIntent.putExtra("channel_id", channelId)
        val dismissPi = PendingIntent.getService(context, channelId, cancelIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("channelId", channelId)
        notificationIntent.putExtra("label", label)
        notificationIntent.putExtra("disable_reply", disableReply)
        notificationIntent.putExtra("user_id", userId)

        notificationIntent.putExtra("json", data.toString())

        val pi = PendingIntent.getService(context, data.getLong(FuguAppConstant.CHANNEL_ID).toInt(), notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
        //Initialise RemoteInput
        val remoteInput = RemoteInput.Builder(KEY_REPLY)
                .setLabel("Enter your reply here")
                .build()

        //Notification Action with RemoteInput instance added.
        val replyAction = NotificationCompat.Action.Builder(
                android.R.drawable.sym_action_chat, "REPLY", pi)
                .addRemoteInput(remoteInput)
                .setAllowGeneratedReplies(true)
                .build()

        var mBuilder: NotificationCompat.Builder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        val notificationListToBeDisplayed = ArrayList<PushNotification>()

        var maxLines = 6

        for (i in notificationList.indices) {
            notificationListToBeDisplayed.add(notificationList[i])
        }
        var i = 0
        val sender = Person.Builder().setName(sendName).setIcon(null).build()
        val messageStyle = NotificationCompat.MessagingStyle(sender)
        while (i < notificationListToBeDisplayed.size) {
            val senderPerson = Person.Builder()
                    .setName(sendName)
                    .setIcon(null)
                    .build()

            val senderMessage = NotificationCompat.MessagingStyle.Message(Html.fromHtml(notificationListToBeDisplayed[i].message),
                    Date().time, senderPerson)

            messageStyle.addMessage(senderMessage)
            ++i
        }

        messageStyle.conversationTitle = title
        messageStyle.build()

        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setStyle(messageStyle)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        if (notificationSoundEnabled)
            mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.setPriority(getPriority())
        mBuilder.setAutoCancel(true)
        mBuilder.addAction(replyAction)
        mBuilder.setDeleteIntent(dismissPi)


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            if (notificationSoundEnabled) {
                notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, getRingtoneAudioAttributes())
            }
            notificationChannel.enableVibration(true)
            notificationChannel.vibrationPattern = longArrayOf(100, 200, 300, 400, 500, 400, 300, 200, 400)

            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }
        }

        notificationManager.notify(channelId, notification)
    }

    private fun showVerification(context: Context, data: JSONObject) {
        val message: String = data.optString("message")
        var title: String = data.optString("title")
        val timeStamp = data.optString("date_time")
        val icon = R.mipmap.ic_launcher

        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("json", data.toString())
        notificationIntent.putExtra("is_promotional", true)
        notificationIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK

        val pi = PendingIntent.getService(context, 112, notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
        var mBuilder: NotificationCompat.Builder
        mBuilder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.resources, icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.priority = getPriority()
        mBuilder.setAutoCancel(true)


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            notificationChannel.enableVibration(true)
            //notificationChannel.vibrationPattern = longArrayOf(100, 200, 300, 400, 500, 400, 300, 200, 400)
            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)

            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }

        }
        val id = System.currentTimeMillis().toInt()
        notificationManager.notify(id, notification)
    }

    private fun showMissedCall(context: Context, data: JSONObject) {
        val message: String = data.optString("message")
        var title: String = data.optString("title")
        val timeStamp = data.optString("date_time")
        val icon = R.mipmap.ic_launcher

        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("json", data.toString())
        notificationIntent.putExtra("is_promotional", true)
        notificationIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
//
        val pi = PendingIntent.getService(context, 112, notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
        var mBuilder: NotificationCompat.Builder
        mBuilder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.resources, icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.priority = getPriority()
        mBuilder.setAutoCancel(true)


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            notificationChannel.enableVibration(true)
            if (notificationSoundEnabled)
                notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, getRingtoneAudioAttributes())
            //notificationChannel.vibrationPattern = longArrayOf(100, 200, 300, 400, 500, 400, 300, 200, 400)
            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)

            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }

        }
        val id = System.currentTimeMillis().toInt()
        notificationManager.notify(id, notification)
    }

    /**
     * Set notification priority as per API level of device
     */
    private fun getPriority(): Int {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            NotificationManager.IMPORTANCE_MAX
        } else {
            NotificationCompat.PRIORITY_HIGH
        }
    }

    private fun playSound(context: Context) {
        if (CommonData.isBkUser()) {
            val intent = Intent(context, AudioPlay::class.java)
            intent.putExtra("type", AppManager.AudioType.START)
            intent.putExtra("time", BK_SOUND_TIME)
            context.startService(intent)
        }
    }

    private fun getTimeMilliSec(timeStamp: String): Long {
        val format = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        try {
            if (!TextUtils.isEmpty(timeStamp)) {
                val date = format.parse(timeStamp)
                return date.time
            }
        } catch (e: ParseException) {
            e.printStackTrace()
        }

        return 0
    }

    @TargetApi(21)
    private fun getRingtoneAudioAttributes(): AudioAttributes? {
        return AudioAttributes.Builder().setContentType(AudioAttributes.CONTENT_TYPE_UNKNOWN)
                .setUsage(AudioAttributes.USAGE_NOTIFICATION_COMMUNICATION_INSTANT)
                .build()
    }

    private fun bigImageNotifAsync(context: Context, data: JSONObject, image: String) {
        try {
            Glide.with(context)
                    .asBitmap()
                    .load(image)
                    .into(object : CustomTarget<Bitmap?>() {
                        override fun onLoadCleared(placeholder: Drawable?) {
                            showAnnouncement(context, data, null)
                        }

                        override fun onResourceReady(resource: Bitmap, transition: Transition<in Bitmap?>?) {
                            showAnnouncement(context, data, resource)
                        }
                    })
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
            showAnnouncement(context, data, null)
        }
    }

    private fun showAnnouncement(context: Context, data: JSONObject, bitmap: Bitmap?) {
        val message: String = data.optString("message")
        var title: String = data.optString("title")
        val timeStamp = data.optString("date_time")
        val icon = R.mipmap.ic_launcher

        val notificationIntent = Intent(context, PushIntentService::class.java)
        notificationIntent.putExtra("json", data.toString())
        notificationIntent.putExtra("is_announcement_push", true)
        notificationIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK

        val pi = PendingIntent.getService(context, (Date().time / 1000L % Int.MAX_VALUE).toInt()
                , notificationIntent, PendingIntent.FLAG_IMMUTABLE)
        var mBuilder: NotificationCompat.Builder

        var channelId = 0
        try {
            if (data.has("channel_id")) {
                channelId = data.optInt("channel_id", -1)
            }
        } catch (e: java.lang.Exception) {
        }
        mBuilder = NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)


        mBuilder.setContentTitle(title)
        mBuilder.setContentIntent(pi)
        mBuilder.setWhen(getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)))
        mBuilder.setSmallIcon(R.mipmap.hippo_notif)
        mBuilder.setDefaults(Notification.DEFAULT_SOUND)
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(context.resources, icon))
        mBuilder.setContentText(Html.fromHtml(message))
        mBuilder.priority = getPriority()
        mBuilder.setAutoCancel(true)

        if (bitmap == null) {
            mBuilder.setStyle(NotificationCompat.BigTextStyle().bigText(Html.fromHtml(message)))
        } else {
            mBuilder.setLargeIcon(bitmap)
            mBuilder.setStyle(NotificationCompat.BigPictureStyle()
                    .bigPicture(bitmap)
                    .bigLargeIcon(null).setBigContentTitle(title).setSummaryText(message))
        }


        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val notificationChannel = NotificationChannel(NOTIFICATION_CHANNEL_ID, CHANNEL_ONE_NAME, importance)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            notificationChannel.enableVibration(true)
            assert(notificationManager != null)
            notificationManager.createNotificationChannel(notificationChannel)
        }
        val notification = mBuilder.build()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val smallIconViewId = context.getResources().getIdentifier("right_icon", "id", android.R::class.java.getPackage()!!.name)

            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null)
                        notification.contentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.headsUpContentView != null)
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)

                    if (notification.bigContentView != null)
                        notification.bigContentView.setViewVisibility(smallIconViewId, View.INVISIBLE)
                }
            } catch (e: Exception) {

            }

        }
        val id = System.currentTimeMillis().toInt()
        if (channelId > 0)
            notificationManager.notify(channelId, notification)
        else
            notificationManager.notify(id, notification)
    }


}