package com.hippoagent.fragments

/**
 * Created by gurmail on 2019-12-31.
 * @author gurmail
 */
import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import androidx.annotation.Nullable
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.R
import com.hippoagent.activities.FuguChatActivity
import com.hippoagent.activities.HippoChatActivity
import com.hippoagent.hippocall.HippoCallConfig
import com.hippoagent.langs.Restring
import com.hippoagent.model.shareurl.ShareUrlModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParamsObj
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.tickets.CreateTicketActivity
import com.hippoagent.utils.Constants.ACCESS_TOKEN
import com.hippoagent.utils.Utils
import org.json.JSONObject


class AttachmentSheetFragment : BottomSheetDialogFragment(), View.OnClickListener {

    var isPrivateMessage: Boolean = false
    val chatActivity: FuguChatActivity? = null
    var llCamera: LinearLayout? = null
    var llGallery: LinearLayout? = null
    var llVideo: LinearLayout? = null
    var llAudio: LinearLayout? = null
    var llFiles: LinearLayout? = null
    var llPayment: LinearLayout? = null


    var cameraTxt: TextView? = null
    var photoTxt: TextView? = null
    var videoTxt: TextView? = null
    var audioTxt: TextView? = null
    var fileTxt: TextView? = null
    var paymentTxt: TextView? = null
    var llAudioCallLink: LinearLayout? = null
    var llVideoCallLink: LinearLayout? = null


    //var cameraTxt: TextView

    override fun onClick(v: View?) {
        dismiss()
        if (activity is FuguChatActivity)
            (activity as FuguChatActivity).openScreenFromSheet(v?.id!!, "")
        else if (activity is HippoChatActivity)
            (activity as HippoChatActivity).openScreenFromSheet(v?.id!!, "")
        else if (activity is CreateTicketActivity)
            (activity as CreateTicketActivity).openScreenFromSheet(v?.id!!)

    }

    override fun onCreate(@Nullable savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    fun newInstance(): AttachmentSheetFragment {
        return newInstance(false, false)
    }

    fun newInstance(isPayment: Boolean, isPrivateMessage: Boolean): AttachmentSheetFragment {
        val frag = AttachmentSheetFragment()
        val args = Bundle()
        args.putBoolean("hidePayment", isPayment)
        args.putBoolean("isPrivateMessage", isPrivateMessage)
        frag.arguments = args
        return frag
    }

    override fun getTheme(): Int = R.style.HippoBottomSheetDialogTheme

    @Nullable
    override fun onCreateView(
        inflater: LayoutInflater,
        @Nullable container: ViewGroup?,
        @Nullable savedInstanceState: Bundle?
    ): View? {
        BottomSheetDialog(requireContext(), theme)
        val view = inflater.inflate(R.layout.attachmnet_bottom_sheet, container, false)

        llCamera = view.findViewById(R.id.llCamera)
        llGallery = view.findViewById(R.id.llGallery)
        llAudio = view.findViewById(R.id.llAudio)
        llFiles = view.findViewById(R.id.llFiles)
        llVideo = view.findViewById(R.id.llVideo)
        llPayment = view.findViewById(R.id.llPayment)

        cameraTxt = view.findViewById(R.id.cameraTxt)
        photoTxt = view.findViewById(R.id.photoTxt)
        videoTxt = view.findViewById(R.id.videoTxt)
        audioTxt = view.findViewById(R.id.audioTxt)
        fileTxt = view.findViewById(R.id.fileTxt)
        paymentTxt = view.findViewById(R.id.paymentTxt)
        llVideoCallLink = view.findViewById(R.id.llVideoCallLink);
        llAudioCallLink = view.findViewById(R.id.llAudioCallLink);


        llAudioCallLink?.setOnClickListener(View.OnClickListener { getCallLink(false) })
        llVideoCallLink?.setOnClickListener(View.OnClickListener { getCallLink(true) })


        var flag = false
        if (arguments != null && arguments!!.containsKey("hidePayment"))
            flag = arguments!!.getBoolean("hidePayment", false)
        if (arguments != null && arguments!!.containsKey("isPrivateMessage"))
            isPrivateMessage = arguments!!.getBoolean("isPrivateMessage", false)

        if (HippoApplication.getInstance().userData.businessProperty.isCallInviteEnabled == 1 && !isPrivateMessage) {
            llAudioCallLink?.visibility = View.VISIBLE;
            llVideoCallLink?.visibility = View.VISIBLE;
        } else {
            llAudioCallLink?.visibility = View.GONE;
            llVideoCallLink?.visibility = View.GONE;

        }
        if (HippoConfig.getInstance().attributes != null && HippoConfig.getInstance().attributes.additionalInfo != null
            && HippoConfig.getInstance().attributes.additionalInfo.showPaymentButton()
        ) {
            llPayment?.visibility = View.VISIBLE
        }

        if (llPayment?.visibility == View.VISIBLE && flag)
            llPayment?.visibility = View.GONE

        cameraTxt?.text = Restring.getString(activity, R.string.camera)
        photoTxt?.text = Restring.getString(activity, R.string.hippo_photos)
        videoTxt?.text = Restring.getString(activity, R.string.video)
        audioTxt?.text = Restring.getString(activity, R.string.fugu_audio)
        fileTxt?.text = Restring.getString(activity, R.string.hippo_files)
        paymentTxt?.text = Restring.getString(activity, R.string.hippo_payment)


        llCamera?.setOnClickListener(this)
        llGallery?.setOnClickListener(this)
        llAudio?.setOnClickListener(this)
        llFiles?.setOnClickListener(this)
        llVideo?.setOnClickListener(this)
        llPayment?.setOnClickListener(this)

        return view

    }

    private fun getCallLink(isVideoCall: Boolean) {
        var url = ""
        val random: String = Utils.generateRandomString()
        if (!TextUtils.isEmpty(HippoCallConfig.getInstance().jitsiURL)) {
            url = HippoCallConfig.getInstance().jitsiURL
        }
        if (url.isEmpty()) return

        url = url + "/" + random + "#config.startWithVideoMuted=" + (isVideoCall.toString() + "")

        val custom_attributes = JSONObject();
        var call_type = "audio"

        if (isVideoCall)
            call_type = "video"

        custom_attributes.put("call_type", call_type)

        if (HippoApplication.getInstance().userData.businessProperty.callingType.equals(
                "3",
                ignoreCase = true
            )
        ) {
            url = random;
        }


        val params = CommonParamsObj.Builder()
            .add(ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
            .add("en_creator_id", HippoApplication.getInstance().userData.enUserId)
            .add("creator_id", HippoApplication.getInstance().userData.userId)
            .add("meet_url", url)
            .build()
        if (HippoApplication.getInstance().userData.businessProperty.callingType.equals(
                "3",
                ignoreCase = true
            )
        ) {
            params.map["custom_attributes"] = custom_attributes
        }

        RestClient.getApiInterface().createInviteLink(params.getMap())
            .enqueue(object : ResponseResolver<ShareUrlModel?>(activity, true, false) {


                override fun failure(error: APIError?) {
                    dismiss()
                }

                override fun success(shareUrlModel: ShareUrlModel?) {
                    try {
                        if (activity is FuguChatActivity)
                            (activity as FuguChatActivity).openScreenFromSheet(
                                5,
                                shareUrlModel?.getData()?.getMeetUrl()
                            )
                        else if (activity is HippoChatActivity)
                            (activity as HippoChatActivity).openScreenFromSheet(
                                5,
                                shareUrlModel?.getData()?.getMeetUrl()
                            )
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                    dismiss()
                }


            })
    }

}