package com.hippoagent.fragments

import android.content.Context
import android.net.ConnectivityManager
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.adapters.ChannelJourneyAdapter
import com.hippoagent.langs.Restring
import com.hippoagent.model.user_details.CJourney
import com.hippoagent.model.user_details.ChannelJourneyData
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.DateUtils
import com.hippoagent.utils.Log
import com.hippoagent.utils.filelogger.Logger


/**
 * Created by gurmail on 2019-09-09.
 * @author gurmail
 */
class ChannelJourneyFragment : androidx.fragment.app.Fragment() {


    private var channelID: String? = ""
    var srLayout: androidx.swiperefreshlayout.widget.SwipeRefreshLayout? = null
    var rvAll: androidx.recyclerview.widget.RecyclerView? = null
    var llNoConversation: LinearLayout? = null
    var title: TextView? = null
    var reasions: TextView? = null

    var adapter: ChannelJourneyAdapter? = null
    var array: ArrayList<CJourney> = ArrayList()
    var tempArray: ArrayList<CJourney> = ArrayList()
    var tempSentAtUtc = ""
    private val inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"
    private val outputFormat = "yyyy-MM-dd h:mm a"
    private var journeyType = object : TypeToken<List<CJourney>>() {

    }.type

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (arguments != null) {
            array = Gson().fromJson(arguments!!.getString("data"), journeyType)
            channelID = arguments!!.getString("channelID")
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.conversation_fragment, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        srLayout = view.findViewById(R.id.srLayout)
        rvAll = view.findViewById(R.id.rvAll)
        llNoConversation = view.findViewById(R.id.llNoConversation)
        title = view.findViewById(R.id.title)
        reasions = view.findViewById(R.id.reasions)

        srLayout?.isEnabled = false

        adapter = ChannelJourneyAdapter(tempArray)
        rvAll?.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        rvAll?.addItemDecoration(androidx.recyclerview.widget.DividerItemDecoration(context, androidx.recyclerview.widget.DividerItemDecoration.HORIZONTAL))
        rvAll?.adapter = adapter

//        parseData(array)
        getJourney()

    }

    override fun onAttach(context: Context) {
        super.onAttach(context)

    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onResume() {
        super.onResume()

    }


    private fun parseData(array: ArrayList<CJourney>) {
        tempArray.clear()
        for (i in 0 until array.size) {
            val localDateTime = DateUtils.getInstance().convertToLocal(array[i].date, inputFormat, outputFormat)

            val localDate = localDateTime.split(" ")
            if (!tempSentAtUtc.equals(localDate[0], ignoreCase = true)) {
                val date = DateUtils.getDate(array[i].date)
                tempArray.add(CJourney(true, date))
                tempSentAtUtc = localDate[0]
            }

            val journeyObj = array[i]
            val time = localDate[1] + localDate[2]
            journeyObj.date = time
            tempArray.add(journeyObj)
        }

        if (tempArray.size > 0) {
            adapter?.notifyDataSetChanged()
            llNoConversation?.visibility = View.GONE
        } else {
            llNoConversation?.visibility = View.VISIBLE
            title?.text = Restring.getString(activity, R.string.hippo_no_channel_journey)
            reasions?.text = ""

        }
    }

    fun isNetworkAvailable(): Boolean {
        val cm = activity?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager?
        val networkInfo = cm!!.activeNetworkInfo
        return networkInfo != null && networkInfo.isConnected
    }


    private fun getJourney() {
        val builder = CommonParams.Builder()
        builder.add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
        builder.add(Constants.CHANNEL_ID, channelID)
        builder.add(Constants.BUSINESS_ID, HippoApplication.getInstance().userData.businessId.toString())


        val commonParams = builder.build()
        Logger.apiRequest("/api//users/getUserJourney", Gson().toJson(commonParams.map))
        RestClient.getApiInterface().getUserJourney(commonParams.map)
                .enqueue(object : ResponseResolver<ChannelJourneyData>(activity, true, true) {
                    override fun success(response: ChannelJourneyData) {
                        Logger.apiResponse("/api//users/getUserJourney", "")

                        parseData(response.cJourney)
                    }

                    override fun failure(error: APIError) {
                        tempArray.clear()

                        if (tempArray.size > 0) {
                            adapter?.notifyDataSetChanged()
                            llNoConversation?.visibility = View.GONE
                        } else {
                            llNoConversation?.visibility = View.VISIBLE
                            title?.text = Restring.getString(activity, R.string.hippo_no_channel_journey)
                            reasions?.text = ""

                        }

                        Logger.apiFailed("/api/users/getUserJourney", error.message)
                        Log.e("error", "error")
                    }
                })

    }

}