package com.hippoagent.fragments;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.hippoagent.BuildConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.PaymentViewActivity;
import com.hippoagent.adapters.ConversationChatAdapter;
import com.hippoagent.appData.AppManager;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.AgentType;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.ConversationMode;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.datastructure.NotificationType;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ConnectionMessage;
import com.hippoagent.eventbus.FilterEvent;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.ReceivedMessage;
import com.hippoagent.eventbus.UpdateEvent;
import com.hippoagent.fcm.AudioPlay;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.Filter;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.GetConversationResponse;
import com.hippoagent.model.LoginResponse.ChannelFilter;
import com.hippoagent.model.LoginResponse.Tag;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParamsObj;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.loadingBox.LoadingBox;
import com.hippoagent.utils.recylerviewAnimation.FadeInLeftAnimator;
import com.squareup.otto.Subscribe;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;

import io.paperdb.Paper;

import static com.hippoagent.utils.Constants.defaultPageSize;

public class HomeFragment extends Fragment implements SwipeRefreshLayout.OnRefreshListener {
    private static final String ARG_PARAM1 = "selectedMode";
    private static final String ARG_PARAM2 = "param2";
    private static final String ARG_PARAM3 = "position";

    private int selectedMode = MessageMode.OPEN_CHAT.getOrdinal();
    private String mParam2;

    private View root;
    private RelativeLayout relative;
    //    private ConversationFragment conversationFragment;
    private boolean isPagingApiInProgress;
    private ArrayList<Conversation> conversationChatList = new ArrayList<>();
    private boolean getConversationApiHit;
    private int pos = -1;
    public MenuItem filerIcon;
    public MenuItem updateIcon;
    private boolean isPressed1 = false;
    private Context mContext;
    Activity activity;
    private RelativeLayout rlUpdatingConvo;
    private LinearLayout retryLayout;
    private TextView btnRetry, tvUpdatingConvo;

    private RelativeLayout rlPaymentView;
    private TextView tvPaymentMessage;
    private Button btnAddCard, btnCancel;

    //private GetAgentData getAgentData;
    public static final String RECIEVER_MSG = "com.fugu.agent.msg";
    public static final String RECIEVER_MSG_AGENT_REFRESH = "com.fugu.agent.refresh.msg";

    public boolean hasPagination = true;

    private int merchantChat = 10;

    private SwipeRefreshLayout srLayout;
    private RecyclerView rvAll;
    private ConversationChatAdapter conversationChatAdapter;
    private ArrayList<Object> conversationsList = new ArrayList<>();
    LinearLayoutManager layoutManager;
    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private LinearLayout llNoConversation;
    private TextView errortitle, errorreasions;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;
    private int chatType = MessageType.MY_CHAT.getOrdinal();


    public HomeFragment() {
        // Required empty public constructor
    }

    public static HomeFragment newInstance(int selectedMode, String param2) {
        HomeFragment fragment = new HomeFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, selectedMode);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    boolean firstTimeFetch = true;
    boolean isFrontView = false;

    @Override
    public void setUserVisibleHint(boolean visible) {
        super.setUserVisibleHint(visible);
        isFrontView = visible;
        if (visible && isResumed()) {
            if (position > 0 && firstTimeFetch) {
                firstTimeFetch = false;
                onresumeHandler(true, -1, true);
            }
        }
    }

    int position = 0;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        if (getArguments() != null) {
            selectedMode = getArguments().getInt(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
            position = getArguments().getInt(ARG_PARAM3);
            chatType = getArguments().getInt(ARG_PARAM3);
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        mContext = context;
        if (context instanceof Activity) {
            activity = (Activity) context;
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    public SwipeRefreshLayout getSrLayout() {
        return srLayout;
    }

    private ConversationChatAdapter.ProgressBarItem progressBarItem;

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (progressBarItem == null) {
                progressBarItem = new ConversationChatAdapter.ProgressBarItem();
            }
            if (!conversationsList.contains(progressBarItem)) {
                conversationsList.add(progressBarItem);
                rvAll.post(new Runnable() {
                    public void run() {
                        conversationChatAdapter.notifyItemInserted(conversationsList.size() - 1);
                    }
                });
            }
        } else {
            if (progressBarItem != null && conversationsList.contains(progressBarItem)) {
                conversationsList.remove(progressBarItem);
                conversationChatAdapter.notifyItemRemoved(conversationsList.size() - 1);
            }
        }
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        root = inflater.inflate(R.layout.home_fragment, container, false);

        relative = root.findViewById(R.id.root);
        rlUpdatingConvo = (RelativeLayout) root.findViewById(R.id.rlUpdatingConvo);
        tvUpdatingConvo = root.findViewById(R.id.tvUpdatingConvo);
        tvUpdatingConvo.setText(Restring.getString(getActivity(), R.string.updating_conversation));

        btnRetry = root.findViewById(R.id.btnRetry);
        retryLayout = root.findViewById(R.id.retry_layout);

        rlPaymentView = root.findViewById(R.id.rlPaymentView);
        tvPaymentMessage = root.findViewById(R.id.tvPaymentMessage);
        btnAddCard = root.findViewById(R.id.btn_add);
        btnCancel = root.findViewById(R.id.btn_cancel);

        srLayout = root.findViewById(R.id.srLayout);
        srLayout.setOnRefreshListener(this);
        srLayout.setColorSchemeResources(R.color.white);
        srLayout.setProgressBackgroundColorSchemeResource(R.color.colorPrimary);
        srLayout.setSize(SwipeRefreshLayout.DEFAULT);
        llNoConversation = (LinearLayout) root.findViewById(R.id.llNoConversation);

        errortitle = root.findViewById(R.id.title);
        errorreasions = root.findViewById(R.id.reasions);
        errortitle.setText(Restring.getString(getActivity(), R.string.no_conversation_found));
        errorreasions.setText(Restring.getString(getActivity(), R.string.we_could_not_found_any_conversation));
        errorreasions.setVisibility(View.GONE);

        rvAll = (RecyclerView) root.findViewById(R.id.rvAll);
        layoutManager = new LinearLayoutManager(activity);
        rvAll.setLayoutManager(layoutManager);
        rvAll.setItemAnimator(new FadeInLeftAnimator());
        rvAll.getItemAnimator().setAddDuration(500);
        rvAll.getItemAnimator().setRemoveDuration(500);
        rvAll.setHasFixedSize(false);

        if (chatType == MessageType.ALL_CHAT.getOrdinal()) {
            typeIntArray = new int[]{ConversationMode.ALL.getOrdinal()};
        } else if (chatType == MessageType.P2P_CHAT.getOrdinal()) {
            typeIntArray = new int[]{ConversationMode.P2P.getOrdinal()};
        }

        setupViewPager();

        btnAddCard.setOnClickListener(v -> {
            Intent intent = new Intent(getActivity(), PaymentViewActivity.class);
            startActivity(intent);
        });

        btnCancel.setOnClickListener(v -> {
            try {
                rlPaymentView.setVisibility(View.GONE);
                HippoApplication.getInstance().getUserData().setExpiryInfo(null);
            } catch (Exception e) {

            }
        });

        setFilterAdapter();
        return root;
    }


    private void updateExpiryInfo() {
        rlPaymentView.setVisibility(View.GONE);
        if (HippoApplication.getInstance().getUserData().getExpiryInfo() != null) {
            rlPaymentView.setVisibility(View.VISIBLE);
            tvPaymentMessage.setText(HippoApplication.getInstance().getUserData().getExpiryInfo().getMessage());
            if (HippoApplication.getInstance().getUserData().getExpiryInfo().getKeepShowing()) {
                btnCancel.setVisibility(View.GONE);
            } else {
                btnCancel.setVisibility(View.VISIBLE);
            }
            if (HippoApplication.getInstance().getUserData().getExpiryInfo().getAllowCardDetail()) {
                btnAddCard.setVisibility(View.VISIBLE);
            } else {
                btnAddCard.setVisibility(View.GONE);
            }
            if (HippoApplication.getInstance().getUserData().getExpiryInfo().getKeepShowing()
                    && !HippoApplication.getInstance().getUserData().getExpiryInfo().getAllowCardDetail()) {
                tvPaymentMessage.setGravity(Gravity.CENTER);
            }

        } else {
            rlPaymentView.setVisibility(View.GONE);
        }
    }

    @Subscribe
    public void onConnectionMessage(ConnectionMessage connectionMessage) {
        setConnectionMessage(connectionMessage.type);
    }

    private void preLoader(final int endPoint) {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                boolean hasConversation = false;
                if (!isNetworkAvailable()) {
                    setConnectionMessage(3);
                } else {
                    if (!isFromFilter && (firstTime || position == 0 || position == merchantChat) && (isFrontView || position == merchantChat)) {
                        if (conversationChatList != null && conversationChatList.size() > 0) {
                            try {
//                                rlUpdatingConvo.setVisibility(View.VISIBLE);
                            } catch (Exception e) {
                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
//                                        rlUpdatingConvo.setVisibility(View.VISIBLE);
                                    }
                                });
                            }
                        }
                        onresumeHandler(true, endPoint, !firstTime);
                    }
                }
                firstTime = true;
            }
        }, 50);
    }

    @Override
    public void onResume() {
        super.onResume();
        updateExpiryInfo();
        int endPoint = -1;
        if (conversationChatList != null && conversationChatList.size() > 0) {
            endPoint = conversationChatList.size();
            checkBKSound(-1);
        }
        preLoader(endPoint);

    }

    boolean firstTime = false;

    private void onresumeHandler(final boolean hasConversation, final int endPoint, final boolean showLoader) {
        try {
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (HippoApplication.getInstance() != null && HippoApplication.getInstance().getUserData() != null && HippoApplication.getInstance().getUserData().getUserId() != null) {
                            if (hasConversation) {
                                if (position == merchantChat) {
                                    getAgentSupportChannels(1, false, showLoader, false, 0, null);
                                } else {
                                    apiGetConversation(String.valueOf(HippoApplication.getInstance().getUserData().getUserId()),
                                            getStatusIntArray(), getTypeIntArray()
                                            , getLabelsIntArray(), 1, false, showLoader, false, endPoint);
                                }
                            }

                        }
                    } catch (Exception e) {

                    }
                }
            }, 1000);
        } catch (Exception e) {

        }
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        //LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(mMessageReceiver);
    }

    public boolean isGetConversationApiHit() {
        return getConversationApiHit;
    }

    public boolean isPagingApiInProgress() {
        return isPagingApiInProgress;
    }

    public void setPagingApiInProgress(boolean pagingApiInProgress) {
        isPagingApiInProgress = pagingApiInProgress;
    }

    private void setupViewPager() {
        conversationChatAdapter = new ConversationChatAdapter(conversationsList, activity, new ConversationChatAdapter.Callback() {
            @Override
            public void onClick(int position, Conversation conversation) {
                if (!Utils.preventMultipleClicks()) {
                    return;
                }
                Intent chatIntent = new Intent(activity, FuguChatActivity.class);

                if (chatType == MessageType.P2P_CHAT.getOrdinal()) {
                    chatIntent.putExtra("is_p2p_chat", true);
                } else {
                    chatIntent.putExtra("is_p2p_chat", false);
                }
                if (position == merchantChat)
                    chatIntent.putExtra("is_new_o2o", true);

                chatIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                startActivityForResult(chatIntent, 100);

                removeTotalPushUnread(conversation.getChannelId());
                //HippoApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.CHAT_CLICKED, "conversation_clicked");
            }
        }, rvAll);
        rvAll.setAdapter(conversationChatAdapter);

        rvAll.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                Log.v("scroll state ", "changed");
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                //To implement Pagination
                if (dy > 0) {
                    //getRlFilterToolTip().setVisibility(View.GONE);
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (isNetworkAvailable() && hasPagination && !isPagingApiInProgress()) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            try {
                                if (loadmore)
                                    fetchNextPage();
                            } catch (Exception e) {
                                fetchNextPage();
                            }
                        }
                    }
                } else {
                    if (snackbar != null && layoutManager.findFirstVisibleItemPosition() == 1) {
                        snackbar.dismiss();
                    }
                }
            }
        });
    }

    private void fetchNextPage() {
        setPagingApiInProgress(true);
        toggleProgressBarVisibility(true);
        int pageStart = conversationsList.size();
        if (conversationsList.contains(progressBarItem)) {
            pageStart = conversationsList.size();
        }
        isApiInProgress = false;
        if (position == merchantChat) {
            getAgentSupportChannels(pageStart, true, false, isFromFilter, selectedPos, selectedStatus);
        } else {
            if (selectedPeople == null && !isFromFilter) {
                apiGetConversation(String.valueOf(HippoApplication.getInstance().getUserData().getUserId()),
                        getStatusIntArray(), getTypeIntArray(), getLabelsIntArray(), pageStart, true, false, true);
            } else {
                String customLabel = null;
                if (getFilterModel().getSearchCustomLabel() > 0)
                    customLabel = Integer.toString(getFilterModel().getSearchCustomLabel());

                apiGetConversation(selectedPeopleUserId, String.valueOf(HippoApplication.getInstance().getUserData().getUserId()), getStatusIntArray()
                        , getTypeIntArray(), getLabelsIntArray(), pageStart, true, false, true, getChannelFilter(), customLabel, getFilterModel());
            }
        }

    }


    @Override
    public void onRefresh() {
        getSrLayout().setRefreshing(true);
        if (!isNetworkAvailable()) {
            getSrLayout().setRefreshing(false);
            return;
        }

        loadmore = true;
        if (position == merchantChat) {
            getAgentSupportChannels(1, false, false, isFromFilter, selectedPos, selectedStatus);
        } else {
            if (selectedPeople == null && !isFromFilter) {
                apiGetConversation(String.valueOf(HippoApplication.getInstance().getUserData().getUserId()),
                        getStatusIntArray(),
                        getTypeIntArray(), getLabelsIntArray(), 1, false, false, true);
                //HippoApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.PULL_DOWN_TO_REFRESH, "pull_to_refresh");
            } else {
                String customLabel = null;
                if (getFilterModel().getSearchCustomLabel() > 0)
                    customLabel = Integer.toString(getFilterModel().getSearchCustomLabel());
                apiGetConversation(selectedPeopleUserId,
                        String.valueOf(HippoApplication.getInstance().getUserData().getUserId()), getStatusIntArray()
                        , getTypeIntArray(), getLabelsIntArray(),
                        1, false, false, true, getChannelFilter(), customLabel, getFilterModel());
                //HippoApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.PULL_DOWN_TO_REFRESH, "pull_to_refresh");
            }
        }

    }

    public void add(String text, int position) {
        Conversation conversation = new Conversation();
        conversation.setChannelId(321);
        conversation.setChannelName("Abc");
        conversation.setUserId(197);
        conversation.setLastUpdatedAt("");
        conversation.setMessage("message");
        conversation.setLabel("label");
        conversation.setStatus(1);
        conversation.setBotChannelName("su");
        conversation.setUnreadCount(1);
        conversation.setAgentId(197);
        conversationsList.add(position, conversation);
        conversationChatAdapter.notifyItemInserted(position);
        if (layoutManager.findFirstVisibleItemPosition() == 0) {
            rvAll.scrollToPosition(0);
        }
    }

    private void clearNotification(int channelId) {
        try {
            NotificationUtils.clearNotifications(activity, channelId);
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
            CommonData.removeNotificationChannel(channelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(final int position) {
        Conversation conversation = (Conversation) getConversationChatList().get(position);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                conversationChatAdapter.notifyItemChanged(position);
            }
        });
        clearNotification(conversation.getChannelId());
        removeConversation(conversation.getChannelId());
    }

    int removePos = -1;

    public void removeConversation(final int channelId) {
        removePos = -1;
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                try {
                    if (activity == null)
                        activity = getActivity();
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            // TODO: 2019-12-30
                            //if (getHomeFragment().getConversationChatList().size() > 0) {
                            if (conversationChatList.size() > 0) {
                                for (int i = 0; i < conversationChatList.size(); i++) {
                                    if (channelId == ((Conversation) conversationChatList.get(i)).getChannelId()) {
                                        removePos = i;
                                        break;
                                    }
                                }
                            }
                            if (removePos != -1) {
                                try {
                                    // TODO: 2019-12-30
                                    //getHomeFragment().getConversationChatList().remove(position);
                                    conversationChatList.remove(removePos);
                                    conversationChatAdapter.notifyItemRemoved(removePos);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            setLlNoConversation();
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, OVERLAY_TIME);

    }

    public void setLlNoConversation() {
        if (llNoConversation != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (conversationsList.size() == 0) {
                        llNoConversation.setVisibility(View.VISIBLE);
                    } else {
                        llNoConversation.setVisibility(View.GONE);
                    }
                }
            });
        }
    }

    private void removeOverlay(final Conversation conversation) {
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            conversationChatAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, OVERLAY_TIME);
    }

    public ArrayList<Conversation> getConversationChatList() {
        return conversationChatList;
    }


    public void setInRideTill(JSONObject jsonObject) {
        String inRideTxt = jsonObject.optString("inride_text");
        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);

        for (Conversation conversation : conversationChatList) {
            if (conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) {
                if (inRideTime > 1) {
                    conversation.setUserOnline(true);
                    conversation.setInRideText(inRideTxt);
                    conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                    conversation.setInRideTime(inRideTime);
                } else {
                    conversation.setUserOnline(false);
                    conversation.setInRideText(inRideTxt);
                    conversation.setInRideTime(inRideTime);
                }

                setConversationChatData(conversationChatList, false);
                break;
            }
        }
    }

    @Subscribe
    public void onReceivedMessage(ReceivedMessage message) {
        switch (message.type) {
            case 1:
                setControlChannelData(message.object);
                break;
            case 2:
                updateList(message.object);
                break;
            case 3:
                setInRideTill(message.object);
                break;
            case 4:
                setBotInProgress(message.object);
                break;
            case 5:
                setControlChannelData(message.object);
                break;
            case 6:
                updateChannelList(message.object);
                break;
            case 10:
                updateChannelData(message.object);
                break;
            default:

                break;
        }
    }

    public void setBotInProgress(JSONObject jsonObject) {

        for (Conversation conversation : conversationChatList) {
            if (conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) {
                conversation.setBotEnabled(jsonObject.optInt("is_bot_in_progress", 0));
                conversation.setDisableReply(jsonObject.optInt("disable_reply", 0));
                setConversationChatData(conversationChatList, false);
                break;
            }
        }
    }

    private void updateChannelList(JSONObject messageJson) {
        int channelId = messageJson.optInt("channel_id", -1);
        if (channelId > 0 && messageJson.optInt("is_last_message") == 1) {
            //int index = conversationChatList.indexOf(new Conversation(channelId));
            for (int i = 0; i < conversationChatList.size(); i++) {
                if (conversationChatList.get(i).getChannelId().intValue() == channelId) {
                    if (messageJson.optInt("status") == 2) {
                        conversationChatList.get(i).setMessage(messageJson.optString("edited_message"));
                    } else if (messageJson.optInt("status") == 1) {
                        String deleteStr = Restring.getString(getActivity(), R.string.hippo_message_deleted);
                        conversationChatList.get(i).setMessage(deleteStr);
                    }
                    notifiyListItem(i);

                    break;
                }
            }
        }
    }

    private void notifiyListItem(int position) {
        getActivity().runOnUiThread(() -> conversationChatAdapter.notifyItemChanged(position));
    }

    String lastMuid = "";

    public void setControlChannelData(JSONObject jsonObject) {
        try {
            try {
                if (!TextUtils.isEmpty(lastMuid) && lastMuid.equalsIgnoreCase(jsonObject.optString("muid"))) {
                    JSONObject jsonObject1 = jsonObject;
                    if (!jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                        return;
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            for (Conversation conversation : conversationChatList) {
                                if (conversation.getChannelId().equals(jsonObject1.optInt("channel_id"))) {
                                    if (jsonObject1.optInt("message_type") != 10) {
                                        conversation.setMessage(jsonObject1.optString("message", ""));
                                    } else {
                                        conversation.setMessage("");
                                    }
                                    conversation.setAgentId(jsonObject1.optInt("agent_id", 0));
                                    conversation.setAgentName(jsonObject.optString("agent_name"));

                                    String userImage = jsonObject1.optString("user_image", "");
                                    if (!TextUtils.isEmpty(userImage)) {
                                        conversation.setUserImage(userImage);
                                    }
                                    conversation.setLast_sent_by_id(jsonObject1.optInt("last_sent_by_id"));
                                    conversation.setLast_sent_by_full_name(jsonObject1.optString("last_sent_by_full_name"));
                                    if (jsonObject1.has("last_sent_by_user_type"))
                                        conversation.setLast_sent_by_user_type(jsonObject1.optInt("last_sent_by_user_type", 2));
                                    if (jsonObject1.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                                        conversation.setBotEnabled(jsonObject1.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));


                                    conversation.setMultiLangMessage(jsonObject1.optString("multi_lang_message", ""));
                                    conversation.setLastUpdatedAt(jsonObject1.optString("date_time", ""));
                                    if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == 1) {
                                        if (jsonObject1.optInt("last_sent_by_id", 0) != HippoApplication.getInstance().getUserData().getUserId().intValue()
                                                && jsonObject1.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                                            conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                                        }
                                    }
                                    //conversation.setMuid
                                    if (jsonObject1.optInt("last_sent_by_id", -1) == HippoApplication.getInstance().getUserData().getUserId().intValue()) {
                                        conversation.setUnreadCount(0);

                                    }

                                    try {
                                        String inRideTxt = jsonObject1.optString("inride_text");
                                        int inRideTime = jsonObject1.optInt("estimated_inride_secs", 0);

                                        if (inRideTime > 1) {
                                            conversation.setUserOnline(true);
                                            conversation.setInRideText(inRideTxt);
                                            conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                                            conversation.setInRideTime(inRideTime);
                                        }
                                    } catch (Exception e) {

                                    }
                                    break;
                                }
                            }
                            if (!isAllChats()
                                    && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
                                    && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                                pos = -1;
                                for (int i = 0; i < conversationChatList.size(); i++) {
                                    if (jsonObject.optInt("channel_id") == conversationChatList.get(i).getChannelId()) {
                                        pos = i;
                                        break;
                                    }
                                }
                                if (pos > -1) {
                                    //conversationChatList.remove(pos);
                                    remove(pos);
                                }
                            } else {

                                Collections.sort(conversationChatList, new Comparator<Conversation>() {
                                    public int compare(Conversation o1, Conversation o2) {
                                        if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null)
                                            return 0;
                                        return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                                    }
                                });

                                setConversationChatData(conversationChatList, false);
                            }

                        }
                    }, 500);
                    return;
                } else {
                    lastMuid = jsonObject.optString("muid");
                }
            } catch (Exception e) {

            }

            if (isP2pChats() && jsonObject.optInt("chat_type") != 1) {
                return;
            }

            if (jsonObject.optInt("chat_type") == 2)
                return;

            if (chatType == MessageType.MY_CHAT.getOrdinal() && jsonObject.optInt("is_my_chat", 1) == 0) {
                return;
            }

            boolean newConversation = true;
            for (Conversation conversation : conversationChatList) {
                if (conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) {
                    newConversation = false;
                    if (jsonObject.optInt("message_type") != 10) {
                        conversation.setMessage(jsonObject.optString("message", ""));
                    } else {
                        conversation.setMessage("");
                    }
                    conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                    conversation.setAgentName(jsonObject.optString("agent_name"));
                    conversation.setMessageSubType(jsonObject.optInt("message_sub_type", 0));

                    conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                    conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                    if (jsonObject.has("last_sent_by_user_type"))
                        conversation.setLast_sent_by_user_type(jsonObject.optInt("last_sent_by_user_type", 2));
                    if (jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                        conversation.setBotEnabled(jsonObject.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));

                    //conversation.setUserImage(jsonObject.optString("user_image", ""));
                    String userImage = jsonObject.optString("user_image", "");
                    if (!TextUtils.isEmpty(userImage)) {
                        conversation.setUserImage(userImage);
                    }
                    conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                    if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == 1) {
                        if (jsonObject.optInt("last_sent_by_id", 0) != HippoApplication.getInstance().getUserData().getUserId().intValue()
                                && jsonObject.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                            conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                        }
                    }
                    //conversation.setMuid
                    if (jsonObject.optInt("last_sent_by_id", -1) == HippoApplication.getInstance().getUserData().getUserId().intValue()) {
                        conversation.setUnreadCount(0);
                    }

                    conversation.setMultiLangMessage(jsonObject.optString("multi_lang_message", ""));
                    try {
                        String inRideTxt = jsonObject.optString("inride_text");
                        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);

                        if (inRideTime > 1) {
                            conversation.setUserOnline(true);
                            conversation.setInRideText(inRideTxt);
                            conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                            conversation.setInRideTime(inRideTime);
                        }
                    } catch (Exception e) {

                    }
                    break;
                }
            }

            try {
                lastMuid = jsonObject.optString("muid");
            } catch (Exception e) {

            }


            if (chatType == MessageType.MY_CHAT.getOrdinal()
                    && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
                    && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                newConversation = false;
            }


            if (newConversation) {
                Log.v("New chat arrived", "send to unasssigned");
                Conversation conversation = new Conversation();
                conversation.setChannelId(jsonObject.optInt("channel_id"));
                conversation.setChannelName(jsonObject.optString("channel_name", ""));
                conversation.setUserId(jsonObject.optInt("user_id"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                if (jsonObject.optInt("message_type") != 10) {
                    conversation.setMessage(jsonObject.optString("message", ""));
                } else {
                    conversation.setMessage("");
                }
                conversation.setUserImage(jsonObject.optString("user_image", ""));
                conversation.setLabel(jsonObject.optString("label", ""));
                if (jsonObject.has("chat_status") && jsonObject.optInt("status", 1) == 0) {
                    conversation.setStatus(1);
                } else {
                    conversation.setStatus(jsonObject.optInt("status", 1));
                }
                conversation.setBotChannelName(jsonObject.optString("bot_channel_name", ""));
                conversation.setUnreadCount(jsonObject.optInt("unread_count", 1));
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                conversation.setAgentName(jsonObject.optString("agent_name"));

                conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                if (jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                    conversation.setBotEnabled(jsonObject.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));

                conversation.setMultiLangMessage(jsonObject.optString("multi_lang_message", ""));

                try {
                    String inRideTxt = jsonObject.optString("inride_text");
                    int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);

                    if (inRideTime > 1) {
                        conversation.setUserOnline(true);
                        conversation.setInRideText(inRideTxt);
                        conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                        conversation.setInRideTime(inRideTime);
                    }
                } catch (Exception e) {

                }

                conversationChatList.add(0, conversation);
                conversationsList.add(0, conversation);
                setLlNoConversation();
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        conversationChatAdapter.notifyItemInserted(0);
                        if (layoutManager.findFirstVisibleItemPosition() == 0) {
                            rvAll.scrollToPosition(0);
                        } else if (layoutManager.findFirstVisibleItemPosition() > 0) {
                            newConversationSnackBar();
                        }
                    }
                });
            } else {
                if (!isAllChats()
                        && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
                        && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                    pos = -1;
                    //if (jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                    for (int i = 0; i < conversationChatList.size(); i++) {
                        if (jsonObject.getInt("channel_id") == conversationChatList.get(i).getChannelId()) {
                            pos = i;
                            break;
                        }
                    }
                    if (pos > -1) {
                        //conversationChatList.remove(pos);
                        remove(pos);
                    }
                    //}
                } else {

                    Collections.sort(conversationChatList, new Comparator<Conversation>() {
                        public int compare(Conversation o1, Conversation o2) {
                            if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null)
                                return 0;
                            return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                        }
                    });

                    setConversationChatData(conversationChatList, false);
                }
                //checkBKSound(jsonObject.optInt("channel_id", -1));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateChannelData(JSONObject jsonObject) {
        try {
            try {
                if (!TextUtils.isEmpty(lastMuid) && lastMuid.equalsIgnoreCase(jsonObject.optString("muid"))) {
                    JSONObject jsonObject1 = jsonObject;
                    if (!jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                        return;
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            for (Conversation conversation : conversationChatList) {
                                if (conversation.getChannelId().equals(jsonObject1.optInt("channel_id"))) {
                                    if (jsonObject1.optInt("message_type") != 10) {
                                        conversation.setMessage(jsonObject1.optString("message", ""));
                                    } else {
                                        conversation.setMessage("");
                                    }
                                    conversation.setAgentName(jsonObject.optString("agent_name"));
                                    conversation.setAgentId(jsonObject1.optInt("agent_id", 0));
                                    String userImage = jsonObject1.optString("user_image", "");
                                    if (!TextUtils.isEmpty(userImage)) {
                                        conversation.setUserImage(userImage);
                                    }
                                    conversation.setLast_sent_by_id(jsonObject1.optInt("last_sent_by_id"));
                                    conversation.setLast_sent_by_full_name(jsonObject1.optString("last_sent_by_full_name"));
                                    if (jsonObject1.has("last_sent_by_user_type"))
                                        conversation.setLast_sent_by_user_type(jsonObject1.optInt("last_sent_by_user_type", 2));
                                    if (jsonObject1.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                                        conversation.setBotEnabled(jsonObject1.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));


                                    conversation.setMultiLangMessage(jsonObject1.optString("multi_lang_message", ""));
                                    conversation.setLastUpdatedAt(jsonObject1.optString("date_time", ""));
                                    if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == 1) {
                                        if (jsonObject1.optInt("last_sent_by_id", 0) != HippoApplication.getInstance().getUserData().getUserId().intValue()
                                                && jsonObject1.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                                            conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                                        }
                                    }
                                    //conversation.setMuid
                                    if (jsonObject1.optInt("last_sent_by_id", -1) == HippoApplication.getInstance().getUserData().getUserId().intValue()) {
                                        conversation.setUnreadCount(0);

                                    }

                                    try {
                                        String inRideTxt = jsonObject1.optString("inride_text");
                                        int inRideTime = jsonObject1.optInt("estimated_inride_secs", 0);

                                        if (inRideTime > 1) {
                                            conversation.setUserOnline(true);
                                            conversation.setInRideText(inRideTxt);
                                            conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                                            conversation.setInRideTime(inRideTime);
                                        }
                                    } catch (Exception e) {

                                    }
                                    break;
                                }
                            }
                            if (!isAllChats()
                                    && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
                                    && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                                pos = -1;
                                for (int i = 0; i < conversationChatList.size(); i++) {
                                    if (jsonObject.optInt("channel_id") == conversationChatList.get(i).getChannelId()) {
                                        pos = i;
                                        break;
                                    }
                                }
                                if (pos > -1) {
                                    //conversationChatList.remove(pos);
                                    remove(pos);
                                }
                            } else {

                                Collections.sort(conversationChatList, new Comparator<Conversation>() {
                                    public int compare(Conversation o1, Conversation o2) {
                                        if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null)
                                            return 0;
                                        return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                                    }
                                });

                                setConversationChatData(conversationChatList, false);
                            }

                        }
                    }, 500);
                    return;
                } else {
                    lastMuid = jsonObject.optString("muid");
                }
            } catch (Exception e) {

            }


            if (jsonObject.optInt("chat_type") != 2)
                return;


            boolean newConversation = true;
            for (Conversation conversation : conversationChatList) {
                if (conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) {
                    newConversation = false;
                    if (jsonObject.optInt("message_type") != 10) {
                        conversation.setMessage(jsonObject.optString("message", ""));
                    } else {
                        conversation.setMessage("");
                    }
                    conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                    if (jsonObject.optString("agent_name").isEmpty())
                        conversation.setAgentName(jsonObject.optString("assigned_to_name"));
                    else
                        conversation.setAgentName(jsonObject.optString("agent_name"));

                    conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                    conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                    if (jsonObject.has("last_sent_by_user_type"))
                        conversation.setLast_sent_by_user_type(jsonObject.optInt("last_sent_by_user_type", 2));
                    if (jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                        conversation.setBotEnabled(jsonObject.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));

                    //conversation.setUserImage(jsonObject.optString("user_image", ""));
                    String userImage = jsonObject.optString("user_image", "");
                    if (!TextUtils.isEmpty(userImage)) {
                        conversation.setUserImage(userImage);
                    }
                    conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                    if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == 1) {
                        if (jsonObject.optInt("last_sent_by_id", 0) != HippoApplication.getInstance().getUserData().getUserId().intValue()
                                && jsonObject.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                            conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                        }
                    }
                    //conversation.setMuid
                    if (jsonObject.optInt("last_sent_by_id", -1) == HippoApplication.getInstance().getUserData().getUserId().intValue()) {
                        conversation.setUnreadCount(0);
                    }

                    conversation.setMultiLangMessage(jsonObject.optString("multi_lang_message", ""));
                    try {
                        String inRideTxt = jsonObject.optString("inride_text");
                        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);

                        if (inRideTime > 1) {
                            conversation.setUserOnline(true);
                            conversation.setInRideText(inRideTxt);
                            conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                            conversation.setInRideTime(inRideTime);
                        }
                    } catch (Exception e) {

                    }
                    break;
                }
            }

            try {
                lastMuid = jsonObject.optString("muid");
            } catch (Exception e) {

            }


            if (chatType == MessageType.MY_CHAT.getOrdinal()
                    && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
                    && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
                newConversation = false;
            }


            if (newConversation) {
                Log.v("New chat arrived", "send to unasssigned");
                Conversation conversation = new Conversation();
                conversation.setChannelId(jsonObject.optInt("channel_id"));
                conversation.setChannelName(jsonObject.optString("channel_name", ""));
                conversation.setUserId(jsonObject.optInt("user_id"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                if (jsonObject.optInt("message_type") != 10) {
                    conversation.setMessage(jsonObject.optString("message", ""));
                } else {
                    conversation.setMessage("");
                }
                conversation.setUserImage(jsonObject.optString("user_image", ""));
                conversation.setLabel(jsonObject.optString("label", ""));
                if (jsonObject.has("chat_status") && jsonObject.optInt("status", 1) == 0) {
                    conversation.setStatus(1);
                } else {
                    conversation.setStatus(jsonObject.optInt("status", 1));
                }
                conversation.setBotChannelName(jsonObject.optString("bot_channel_name", ""));
                conversation.setUnreadCount(jsonObject.optInt("unread_count", 1));
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
//                conversation.setAgentName(jsonObject.optString("agent_name"));

                conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                if (jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                    conversation.setBotEnabled(jsonObject.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS));

                conversation.setMultiLangMessage(jsonObject.optString("multi_lang_message", ""));

                try {
                    String inRideTxt = jsonObject.optString("inride_text");
                    int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);

                    if (inRideTime > 1) {
                        conversation.setUserOnline(true);
                        conversation.setInRideText(inRideTxt);
                        conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                        conversation.setInRideTime(inRideTime);
                    }
                } catch (Exception e) {

                }

                conversationChatList.add(0, conversation);
                conversationsList.add(0, conversation);
                setLlNoConversation();
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        conversationChatAdapter.notifyItemInserted(0);
                        if (layoutManager.findFirstVisibleItemPosition() == 0) {
                            rvAll.scrollToPosition(0);
                        } else if (layoutManager.findFirstVisibleItemPosition() > 0) {
                            newConversationSnackBar();
                        }
                    }
                });
            } else {
//                if (!isAllChats()
//                        && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()
//                        && jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
//                    pos = -1;
//                    //if (jsonObject.optInt("assigned_to") != HippoApplication.getInstance().getUserData().getUserId()) {
//                    for (int i = 0; i < conversationChatList.size(); i++) {
//                        if (jsonObject.getInt("channel_id") == conversationChatList.get(i).getChannelId()) {
//                            pos = i;
//                            break;
//                        }
//                    }
//                    if (pos > -1) {
//                        //conversationChatList.remove(pos);
////                        remove(pos);
//                    }
//
//                    //}
//                } else {

                Collections.sort(conversationChatList, new Comparator<Conversation>() {
                    public int compare(Conversation o1, Conversation o2) {
                        if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null)
                            return 0;
                        return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                    }
                });

                setConversationChatData(conversationChatList, false);
//                }
                //checkBKSound(jsonObject.optInt("channel_id", -1));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int pageEnd = 0;

    public int[] getAgentsFilter(FilterModel filterModel) {
        ArrayList<Integer> agentArrayList = new ArrayList<>();
        for (int i = 0; i < filterModel.getAgentList().size(); i++) {
            agentArrayList.add(filterModel.getAgentList().get(i).getId());
        }
        int[] agentIntArray = new int[agentArrayList.size()];
        for (int i = 0; i < agentIntArray.length; i++) {
            agentIntArray[i] = agentArrayList.get(i);
        }
        return agentIntArray;
    }


    public void apiGetConversation(String searchUserId, String userId, int[] statusArray, int[] typeArray,
                                   int[] labelsArray, int pageStart, final boolean isPagination,
                                   boolean showLoading, boolean fromOther, int[] channelArray, String search_custom_label, FilterModel filterModel) {
        if (isNetworkAvailable()) {
            Log.v("statusArray......------", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            Log.v("typeArray......------", Arrays.toString(typeArray));
            Log.v("labelsArray....------", Arrays.toString(labelsArray));
            Log.v("channelArray....------", Arrays.toString(channelArray));


            pageStart = pageStart > 0 ? pageStart : 1;
            pageEnd = pageStart + defaultPageSize - 1;

            HashMap<String, Object> params = new HashMap<>();
            params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
            params.put(Constants.CHANNEL_STATUS, Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            params.put(Constants.DEVICE_TYPE, Constants.ANDROID);
            params.put(Constants.APP_VERSION, BuildConfig.VERSION_CODE);
            params.put(Constants.PAGE_OFFSET, pageStart);
            params.put(Constants.ROW_COUNT, pageEnd);

            if (searchUserId == null)
                searchUserId = userId;

            if (!searchUserId.equalsIgnoreCase(userId))
                params.put("search_user_id", searchUserId);
            if (labelsArray.length > 0)
                params.put("label_list", Arrays.toString(labelsArray));
            if (!TextUtils.isEmpty(search_custom_label))
                params.put("search_custom_label", search_custom_label);
            if (channelArray != null && channelArray.length > 0)
                params.put("default_channels", Arrays.toString(channelArray));

            if (filterModel != null && filterModel.isHasDateFilter()) {
                params.put("start_date", filterModel.getFromDate());
                if (filterModel.getDatePos() == 2 || filterModel.getDatePos() == 5) {
                    params.put("end_date", filterModel.getToDate());
                }
            }

            try {
                if (filterModel != null && filterModel.getAgentList() != null && filterModel.getAgentList().size() > 0) {
                    int[] agentsArray = getAgentsFilter(filterModel);
                    if (agentsArray != null && agentsArray.length > 0)
                        params.put("agent_ids", Arrays.toString(agentsArray));
                }
            } catch (Exception e) {

            }

            boolean fetchMyChatBool = true;
            if (typeArray != null && typeArray.length > 0) {
                for (int i = 0; i < typeArray.length; i++) {
                    switch (typeArray[i]) {
                        case 0:
                            //fetchMyChatBool = true;
                            break;
                        case 1:
                            fetchMyChatBool = false;
                            params.put("fetch_my_chats_only", true);
                            break;
                        case 2:
                            fetchMyChatBool = false;
                            params.put("show_unassigned_chats", true);
                            break;
                        case 3:
                            fetchMyChatBool = false;
                            params.put("fetch_my_tagged_chats", true);
                            break;
                        case 10:
                            fetchMyChatBool = false;
                            params.put("fetch_all_chats", true);
                            break;
                        case 11:
                            fetchMyChatBool = false;
                            params.put("fetch_p2p_chats", true);
                        default:
                            break;
                    }
                }
                if (fetchMyChatBool)
                    params.put("fetch_my_chats", true);
            }

            if (isAllChats()) {
                params.put("fetch_all_chats", true);
            }

            CommonParamsObj paramsObj = new CommonParamsObj.Builder()
                    .addAll(params)
                    .build();

            Logger.INSTANCE.apiRequest("/api/conversation/v2/getConversations", new Gson().toJson(paramsObj.getMap()));

            RestClient.getApiInterface().getConversation(paramsObj.getMap())
                    .enqueue(new ResponseResolver<GetConversationResponse>(getActivity(), showLoading, false) {
                        @Override
                        public void success(final GetConversationResponse getConversationResponse) {
                            Logger.INSTANCE.apiResponse("/api/conversation/v2/getConversations", "");
                            LoadingBox.showOn(getActivity());
                            parseData(getConversationResponse, isPagination);
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", error.getMessage());
                            Log.e("error", "error" + error.getMessage());
                            LoadingBox.hide();
                            try {
                                Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                                if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                                    HippoApplication.getInstance().logout(getActivity());
                                    HippoApplication.getInstance().clearData();
                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                }
                                getSrLayout().setRefreshing(false);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } else {
            Toast.makeText(getActivity(), Restring.getString(getActivity(), R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    boolean isApiInProgress = false;

    public void apiGetConversation(String userId, int[] statusArray, int[] typeArray, int[] labelsArray,
                                   int pageStart, final boolean isPagination, boolean showLoading, boolean fromOther) {
        apiGetConversation(userId, statusArray, typeArray, labelsArray, pageStart, isPagination, showLoading, fromOther, -1);
    }

    public void apiGetConversation(String userId, int[] statusArray, int[] typeArray, int[] labelsArray,
                                   int pageStart, final boolean isPagination, boolean showLoading, boolean fromOther, int endPage) {
        if (isApiInProgress)
            return;

        if (isNetworkAvailable()) {
            Log.v("statusArray......------", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            Log.v("typeArray......------", Arrays.toString(typeArray));
            isApiInProgress = true;

            pageStart = pageStart > 0 ? pageStart : 1;
            endPage = endPage > 0 ? endPage : defaultPageSize;
            endPage = endPage + pageStart - 1;


            HashMap<String, Object> params = new HashMap<>();
            params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
            params.put(Constants.CHANNEL_STATUS, Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            params.put(Constants.DEVICE_TYPE, Constants.ANDROID);
            params.put(Constants.APP_VERSION, BuildConfig.VERSION_CODE);
            params.put(Constants.PAGE_OFFSET, pageStart);
            params.put(Constants.ROW_COUNT, endPage);

            if (labelsArray.length > 0)
                params.put("label_list", Arrays.toString(labelsArray));
            if (labelsArray.length > 0)
                params.put("label_list", Arrays.toString(labelsArray));

            boolean fetchMyChatBool = true;
            if (typeArray != null && typeArray.length > 0) {
                for (int i = 0; i < typeArray.length; i++) {
                    switch (typeArray[i]) {
                        case 0:
                            //fetchMyChatBool = true;
                            break;
                        case 1:
                            fetchMyChatBool = false;
                            params.put("fetch_my_chats_only", true);
                            break;
                        case 2:
                            fetchMyChatBool = false;
                            params.put("show_unassigned_chats", true);
                            break;
                        case 3:
                            fetchMyChatBool = false;
                            params.put("fetch_my_tagged_chats", true);
                            break;
                        case 10:
                            fetchMyChatBool = false;
                            params.put("fetch_all_chats", true);
                            break;
                        case 11:
                            fetchMyChatBool = false;
                            params.put("fetch_p2p_chats", true);
                        default:
                            break;
                    }
                }
                if (fetchMyChatBool)
                    params.put("fetch_my_chats", true);
            }

            if (isAllChats()) {
                params.put("fetch_all_chats", true);
            }

            // TODO: 18/11/20 changes for fragment, check in testing
//            try {
//                if(!TextUtils.isEmpty(((HomeActivity) getActivity()).getChannelId())) {
//                    params.put("append_channel_id", ((HomeActivity) getActivity()).getChannelId());
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            }

            CommonParamsObj paramsObj = new CommonParamsObj.Builder()
                    .addAll(params)
                    .build();

            String value = new Gson().toJson(paramsObj.getMap());
            Logger.INSTANCE.apiRequest("/api/conversation/v2/getConversations", value);

            RestClient.getApiInterface().getConversation(paramsObj.getMap())
                    .enqueue(new ResponseResolver<GetConversationResponse>(getActivity(), showLoading, false) {
                        @Override
                        public void success(final GetConversationResponse getConversationResponse) {
                            try {
                                Logger.INSTANCE.apiResponse("/api/conversation/v2/getConversations", "");
                                Log.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
                                rlUpdatingConvo.setVisibility(View.GONE);
                                if (getConversationResponse != null) {
                                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode()) {
                                        try {
                                            if (getConversationResponse.getData().getConversation().size() < defaultPageSize) {
                                                loadmore = false;
                                            } else {
                                                loadmore = true;

                                            }
                                        } catch (Exception e) {

                                        }

                                        try {
                                            for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                                if (conversation.getInRideTime() > 1) {
                                                    conversation.setUserOnline(true);
                                                    conversation.setEndTime(DateUtils.getInstance().getRemainingTime(conversation.getInRideTime()));
                                                }
                                            }
                                        } catch (Exception e) {

                                        }

                                        // TODO: 18/11/20 changes for fragment, need to verify in testing
                                        /*try {
                                            if(!TextUtils.isEmpty(((HomeActivity) getActivity()).getChannelId())) {
                                                ((HomeActivity) getActivity()).openChannelConversation(getConversationResponse);
                                            }

                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }*/

                                        if (getConversationResponse.getData().getVersion() != null &&
                                                getConversationResponse.getData().getVersion().getIsForce() != null) {

                                            if (getConversationResponse.getData().getVersion().getLatestVersion() > BuildConfig.VERSION_CODE) {
                                                if (getConversationResponse.getData().getVersion().getIsForce().equals(1)) {
                                                    SingleBtnUpdateWindow(getConversationResponse);
                                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                                    Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getIsForce());
                                                    getSrLayout().setRefreshing(false);
                                                } else if (getConversationResponse.getData().getVersion().getIsForce().equals(0)) {
                                                    Log.v("Latest Version--->>>>>>", String.valueOf(HippoApplication.getInstance().getLatestVersion()));
                                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                                    Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                                    getConversationApiHit = true;
                                                    //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                                    conversationChatList.clear();
                                                    conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                                    setConversationChatData(conversationChatList, isPagination);
                                                    toggleProgressBarVisibility(false);
                                                    getSrLayout().setRefreshing(false);

                                                    setPagingApiInProgress(false);
                                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                                    Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                                    showUpdateWindowTwoBtns(getConversationResponse, isPagination);
                                                } else {
                                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                                    Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                                    getConversationApiHit = true;
                                                    //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                                    conversationChatList.clear();
                                                    conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                                    setConversationChatData(conversationChatList, isPagination);
                                                    toggleProgressBarVisibility(false);
                                                    getSrLayout().setRefreshing(false);

                                                    setPagingApiInProgress(false);

                                                }
                                            } else {
                                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                                getConversationApiHit = true;
                                                //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                                conversationChatList.clear();
                                                conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                                setConversationChatData(conversationChatList, isPagination);
                                                toggleProgressBarVisibility(false);
                                                getSrLayout().setRefreshing(false);

                                                setPagingApiInProgress(false);

                                            }
                                        } else {
                                            getConversationApiHit = true;
                                            //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                            conversationChatList.clear();
                                            conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                            setConversationChatData(conversationChatList, isPagination);
                                            toggleProgressBarVisibility(false);
                                            getSrLayout().setRefreshing(false);

                                            setPagingApiInProgress(false);
                                        }
                                    }
                                    hasPagination = true;
                                    if (getConversationResponse.getData().getConversation().size() == 0) {
                                        hasPagination = false;
                                    }

                                }
                                //LoadingBox.hide();
                                getSrLayout().setEnabled(true);
                                rlUpdatingConvo.setVisibility(View.GONE);
                                isApiInProgress = false;
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", error.getMessage());
                            rlUpdatingConvo.setVisibility(View.GONE);

                            Log.e("error", "error" + error.getMessage());
                            try {
                                LoadingBox.hide();
                                isApiInProgress = false;
                                rlUpdatingConvo.setVisibility(View.GONE);

                                try {
                                    Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                                    if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                                        HippoApplication.getInstance().logout(getActivity());
                                        HippoApplication.getInstance().clearData();
                                        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                    }
                                    getSrLayout().setRefreshing(false);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                getSrLayout().setEnabled(true);
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        }
                    });
        } else {
            rlUpdatingConvo.setVisibility(View.GONE);
            Toast.makeText(getActivity(), Restring.getString(getActivity(), R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    public boolean isAllChats() {
        try {
            if (chatType == MessageType.ALL_CHAT.getOrdinal() && (!HippoApplication.getInstance().getUserData().getBusinessProperty().hideAllChatTab() || HippoApplication.getInstance().getUserData().getAgentType() == AgentType.ADMIN.getOrdinal())) {
                return true;
            }
        } catch (Exception e) {

        }
        return false;//position == 1;
    }

    public boolean isP2pChats() {
        try {
            if (chatType == MessageType.P2P_CHAT.getOrdinal() && HippoApplication.getInstance().getUserData().getBusinessProperty().getP2pEnabled() != null && HippoApplication.getInstance().getUserData().getBusinessProperty().getP2pEnabled().intValue() == 1) {
                return true;
            }
        } catch (Exception e) {

        }
        return false;// position == 2;
    }


    boolean isApiGetAgents = false;
    HashSet<String> apiRunning = new HashSet<>();


    private void showUpdateWindowTwoBtns(final GetConversationResponse getConversationResponse, final boolean isPagination) {

        VersionUpdate update = CommonData.getVersionInfo();
        if (update == null)
            update = new VersionUpdate(getConversationResponse.getData().getVersion().getLatestVersion(),
                    0,
                    true, 0, getConversationResponse.getData().getVersion().getAlertInterval(),
                    getConversationResponse.getData().getVersion().getText(),
                    getConversationResponse.getData().getVersion().getDownloadLink());
        else {
            update.setVersion(getConversationResponse.getData().getVersion().getLatestVersion());
            update.setInterval(getConversationResponse.getData().getVersion().getAlertInterval());
            update.setText(getConversationResponse.getData().getVersion().getText());
            update.setLink(getConversationResponse.getData().getVersion().getDownloadLink());
        }


        CommonData.saveVersionInfo(update);
        BusProvider.getInstance().post(new UpdateEvent(2));
        //((MainActivity) getActivity()).showFlexiablePopup(View.VISIBLE);
    }

    private void SingleBtnUpdateWindow(final GetConversationResponse getConversationResponse) {
        try {
            BusProvider.getInstance().post(new UpdateEvent(1));
            //((MainActivity) getActivity()).showForceUpdate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkBKSound(Integer channelId) {
        try {
            CopyOnWriteArraySet<Integer> arrayList = CommonData.getPushChannelID();
            if (channelId > -1) {
                try {
                    stopAlarmRing(channelId);
                } catch (Exception e) {

                }
                arrayList.remove(channelId);
            }

            ArrayList<Integer> integers = new ArrayList<>();
            integers.addAll(arrayList);

            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < conversationChatList.size(); i++) {
                    for (Integer id : arrayList) {
                        if (id.equals(conversationChatList.get(i).getChannelId()) && conversationChatList.get(i).getUnreadCount() < 1) {
                            arrayList.remove(id);
                            //break;
                        }
                    }
                }

                if (arrayList.size() == 0)
                    CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
            } else {
                CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
            }
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (CommonData.getPushChannelID() == null || CommonData.getPushChannelID().size() == 0)
                            stopAlarmRing(-101);
                    } catch (Exception e) {

                    }
                }
            }, 1000);
        } catch (Exception e) {

        }

    }


    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        //mainActivity = (MainActivity) activity;
    }

    public void stopAlarmRing(final Integer channelId) throws Exception {
        try {
            if (isMyServiceRunning(AudioPlay.class)) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Intent intent = new Intent(getActivity(), AudioPlay.class);
                            intent.putExtra("channelId", channelId);
                            intent.putExtra("type", AppManager.AudioType.STOP);
                            getActivity().startService(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, 50);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        try {
            ActivityManager manager = (ActivityManager) getActivity().getSystemService(Context.ACTIVITY_SERVICE);
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (serviceClass.getName().equals(service.service.getClassName())) {
                    return true;
                }
            }
        } catch (Exception e) {

        }
        return false;
    }

    public void setConnectionMessage(int status) {
        try {
            if (isNetworkAvailable()) {
                switch (status) {
                    case 0:
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    if (retryLayout != null)
                                        retryLayout.setVisibility(View.GONE);
                                } catch (Exception e) {

                                }
                            }
                        });
                        break;
                    case 1:
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    retryLayout.setVisibility(View.VISIBLE);
                                    btnRetry.setText(Restring.getString(getActivity(), R.string.fetching_messages));
                                    retryLayout.setBackgroundColor(Color.parseColor("#00AA00"));
                                } catch (Exception e) {

                                }
                            }
                        });
                        break;
                    case 2:
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    retryLayout.setVisibility(View.VISIBLE);
                                    btnRetry.setText(Restring.getString(getActivity(), R.string.hippo_server_disconnected));
                                    retryLayout.setBackgroundColor(Color.parseColor("#FF0000"));
                                } catch (Exception e) {

                                }
                                //enableButtons();
                            }
                        });
                        break;
                    case 3:
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    retryLayout.setVisibility(View.VISIBLE);
                                    btnRetry.setText(Restring.getString(getActivity(), R.string.fugu_unable_to_connect_internet));
                                    retryLayout.setBackgroundColor(Color.parseColor("#FF0000"));
                                } catch (Exception e) {

                                }
                                //enableButtons();
                            }
                        });
                        break;
                    case 4:
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    retryLayout.setVisibility(View.VISIBLE);
                                    btnRetry.setText(Restring.getString(getActivity(), R.string.hippo_server_connecting));
                                    retryLayout.setBackgroundColor(Color.parseColor("#00AA00"));
                                } catch (Exception e) {

                                }
                                //enableButtons();
                            }
                        });
                        break;
                    default:

                        break;
                }
            } else {
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            retryLayout.setVisibility(View.VISIBLE);
                            btnRetry.setText(Restring.getString(getActivity(), R.string.fugu_unable_to_connect_internet));
                            retryLayout.setBackgroundColor(Color.parseColor("#FF0000"));
                        } catch (Exception e) {

                        }
                        //enableButtons();
                    }
                });
            }
        } catch (Exception e) {

        }
    }

    public void updateList(JSONObject jsonObject) {
        boolean flag = false;
        try {
            for (Conversation conversation : conversationChatList) {
                if (conversation.getUserId().equals(jsonObject.optInt("user_id"))) {
                    conversation.setUserId(jsonObject.optInt("migrated_to", 0));
                    conversation.setLabel(jsonObject.optString("full_name"));
                    flag = true;
                    break;
                }
            }
            if (flag) {
                setConversationChatData(conversationChatList, false);
            }
        } catch (Exception e) {

        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getActivity().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination) {
        setConversationChatData(allChatData, isPagination, true);
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination, final boolean soundRefresh) {
        if (!isPagination) {
            conversationsList.clear();
        }
        // TODO: 18/11/20 changes for fragment, need to check in testing
        /*try {
            if(((HomeActivity) activity).isNotifiacrionClicked()) {
                Integer channelId = ((HomeActivity) activity).getConversation().getChannelId();
                ((HomeActivity) activity).setNotifiacrionClick(false);
                for (int i = 0; i < allChatData.size(); i++) {
                    if (channelId.intValue() == allChatData.get(i).getChannelId().intValue()) {
                        allChatData.get(i).setUnreadCount(0);
                        break;
                    }
                }
            }
        } catch (Exception e) {

        }*/

        conversationsList.addAll(allChatData);

        if (getView() != null && conversationChatAdapter != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    conversationChatAdapter.notifyDataSetChanged();
                }
            });
        }
        setLlNoConversation();
        // TODO: 2019-12-30
        /*try {
            if(soundRefresh && getHomeFragment() != null)
                getHomeFragment().checkBKSound(-1);
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    boolean isSnackbarVisible = false;
    private Snackbar snackbar;
    private int newMessageCount = 0;

    public void newConversationSnackBar() {
        if (isSnackbarVisible)
            return;

        String message;
        newMessageCount++;
        if (newMessageCount > 1) {
            message = newMessageCount + " " + Restring.getString(getActivity(), R.string.fugu_new_conversations);
        } else {
            message = newMessageCount + " " + Restring.getString(getActivity(), R.string.fugu_new_conversation);
        }
        snackbar = Snackbar
                .make(relative, message, Snackbar.LENGTH_LONG)
                .setAction(Restring.getString(getActivity(), R.string.tap_to_view), new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        // do work
                        newMessageCount = 0;
                        //getHomeFragment().getConversationFragment().getRvAll().smoothScrollToPosition(0);
                    }
                });

        snackbar.setActionTextColor(Color.WHITE);
        View sbView = snackbar.getView();
        sbView.setBackgroundColor(ContextCompat.getColor(getActivity(), R.color.green));
        TextView textView = (TextView) sbView.findViewById(com.google.android.material.R.id.snackbar_text);
        textView.setTextColor(Color.WHITE);
        //textView.setTypeface(face);
        Button button = (Button) sbView.findViewById(com.google.android.material.R.id.snackbar_action);
        //button.setTypeface(face);
        snackbar.setDuration(Snackbar.LENGTH_INDEFINITE);
        snackbar.show();

    }


    // filter view
    private FilterModel filterModel;
    public boolean loadmore = true;
    private boolean isFromFilter = false;
    public String selectedPeople = null;
    public String selectedPeopleUserId = null;
    public ArrayList<Tag> labels = new ArrayList<>();
    public int selectedPos = 0;
    private ArrayList<Integer> selectedStatus = new ArrayList<>();

    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};
    private int[] labelsIntArray = new int[]{};
    private int[] channelsIntArray = new int[]{};

    public FilterModel getFilterModel() {
        return filterModel;
    }

    public int[] getStatusFilter() {
        ArrayList<Integer> statusArrayList = new ArrayList<>();
        if (filterModel.getStatusArrayList().get(0).getChecked()) {
            statusArrayList.add(MessageMode.OPEN_CHAT.getOrdinal());
        }
        if (filterModel.getStatusArrayList().get(1).getChecked()) {
            statusArrayList.add(MessageMode.CLOSED_CHAT.getOrdinal());
        }
        Collections.sort(statusArrayList);
        statusIntArray = new int[statusArrayList.size()];
        for (int i = 0; i < statusIntArray.length; i++) {
            statusIntArray[i] = statusArrayList.get(i);
        }
        return statusIntArray;
    }

    public int[] getTypeFilter() {
        ArrayList<Integer> typeArrayList = new ArrayList<>();
        if (isFromFilter) {
            for (int i = 0; i < filterModel.getTypeArrayList().size(); i++) {
                if (filterModel.getTypeArrayList().get(i).getChecked()) {
                    typeArrayList.add(filterModel.getTypeArrayList().get(i).getId());
                }
            }
            if (typeArrayList.size() == 0) {
                if (chatType == MessageType.ALL_CHAT.getOrdinal()) {
                    typeArrayList.add(ConversationMode.ALL.getOrdinal());
                } else {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal());
                }
            }
        } else {
            if (chatType == MessageType.ALL_CHAT.getOrdinal()) {
                typeArrayList.add(ConversationMode.ALL.getOrdinal());
            } else {
                for (int i = 0; i < filterModel.getTypeArrayList().size(); i++) {
                    if (filterModel.getTypeArrayList().get(i).getChecked()) {
                        typeArrayList.add(filterModel.getTypeArrayList().get(i).getId());
                    }
                }
                if (typeArrayList.size() == 0) {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal());
                }
            }
        }
        Collections.sort(typeArrayList);
        typeIntArray = new int[typeArrayList.size()];
        for (int i = 0; i < typeIntArray.length; i++) {
            typeIntArray[i] = typeArrayList.get(i);
        }
        return typeIntArray;
    }

    public int[] getLabelsFilter() {
        ArrayList<Integer> labelsList = new ArrayList<>();
        for (int i = 0; i < filterModel.getLabelsList().size(); i++) {
            if (filterModel.getLabelsList().get(i).getChecked()) {
                labelsList.add(filterModel.getLabelsList().get(i).getId());
            }
        }
        Collections.sort(labelsList);
        labelsIntArray = new int[labelsList.size()];
        for (int i = 0; i < labelsIntArray.length; i++) {
            labelsIntArray[i] = labelsList.get(i);
        }
        return labelsIntArray;
    }

    public int[] getChannelFilter() {
        ArrayList<Integer> channelsList = new ArrayList<>();
        for (int i = 0; i < filterModel.getChannelList().size(); i++) {
            if (filterModel.getChannelList().get(i).getChecked()) {
                channelsList.add(filterModel.getChannelList().get(i).getId());
            }
        }
        Collections.sort(channelsList);
        channelsIntArray = new int[channelsList.size()];
        for (int i = 0; i < channelsIntArray.length; i++) {
            channelsIntArray[i] = channelsList.get(i);
        }
        return channelsIntArray;
    }

    public int[] getStatusIntArray() {
        return statusIntArray;
    }

    public int[] getTypeIntArray() {
        return typeIntArray;
    }

    public int[] getLabelsIntArray() {
        return labelsIntArray;
    }

    public void setFilterAdapter() {
        isFromFilter = false;
        labels = new ArrayList<>();
        labels = (ArrayList<Tag>) HippoApplication.getInstance().getUserData().getTags();

        filterModel = new FilterModel();

        filterModel.setAgentList(new ArrayList());

        for (int i = 0; i < 2; i++) {
            Filter filter = new Filter();
            if (i == 0) {
                filter.setId(1);
                filter.setName(Restring.getString(getActivity(), R.string.open_chats));
                filter.setChecked(true);
            } else {
                filter.setId(2);
                filter.setName(Restring.getString(getActivity(), R.string.closed_chats));
                filter.setChecked(false);
            }
            filterModel.getStatusArrayList().add(filter);
        }


        for (int i = 0; i < 3; i++) {
            Filter filter = new Filter();
            if (i == 0) {
                filter.setId(1);
                filter.setName(Restring.getString(getActivity(), R.string.my_chats));
                filter.setChecked(false);
            } else if (i == 1) {
                filter.setId(2);
                filter.setName(Restring.getString(getActivity(), R.string.unassigned));
                filter.setChecked(false);
            } else {
                filter.setId(3);
                filter.setName(Restring.getString(getActivity(), R.string.tagged));
                filter.setChecked(false);
            }
            filterModel.getTypeArrayList().add(filter);
        }


        //labelView
        for (int i = 0; i < labels.size(); i++) {
            Filter filter = new Filter();
            filter.setId(labels.get(i).getTagId());
            filter.setName(labels.get(i).getTagName());
            filter.setChecked(false);
            filterModel.getLabelsList().add(filter);
        }

        ArrayList<ChannelFilter> channelFilters = new ArrayList<>();
        channelFilters.addAll(HippoApplication.getInstance().getUserData().getChannelFilter());

        for (int i = 0; i < channelFilters.size(); i++) {
            Filter filter = new Filter();
            filter.setId(channelFilters.get(i).getId());
            filter.setName(channelFilters.get(i).getName());
            filter.setChecked(false);
            filterModel.getChannelList().add(filter);
        }

        filterModel.setSelectedPeople("");
        filterModel.setSelectedPeopleUserId("");

        filterModel.setSearchCustomName("");
        filterModel.setSearchCustomLabel(-1);

        try {
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    int dataType = 2;
                    if (position == 1 && isAllChats())
                        dataType = 3;
                    BusProvider.getInstance().post(new FragmentEvent(1, dataType, filterModel));
                }
            }, 100);
        } catch (Exception e) {
            e.printStackTrace();
        }


        /*if(isAllChats())
            BusProvider.getInstance().post(new FragmentEvent(1, isAllChats() ? 3 : 2, filterModel));
        else
            BusProvider.getInstance().post(new FragmentEvent(1, 2, filterModel));*/



        /*try {
            getHomeFragment().filerIcon.setIcon(ContextCompat.getDrawable(MainActivity.this, R.drawable.ic_filter_unslected));
        } catch (Exception e) {

        }*/
    }

    @Subscribe
    public void onFilterEvent(FilterEvent filterEvent) {
        if (chatType == filterEvent.filterType) {
            isFromFilter = true;
            filterModel = new Gson().fromJson(filterEvent.data.getStringExtra("filterData"), FilterModel.class);
            switch (filterModel.getViewType()) {
                case 0:
                    loadmore = true;
                    selectedPeopleUserId = null;
                    selectedPeople = null;
                    applyFilter(filterModel);
                    BusProvider.getInstance().post(new FragmentEvent(1, isAllChats() ? 5 : 4, false));
                    try {
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                isFromFilter = false;
                            }
                        }, 1000);
                    } catch (Exception e) {

                    }
                    break;
                case 1:
                    loadmore = true;
                    selectPeopleItem();
                    BusProvider.getInstance().post(new FragmentEvent(1, isAllChats() ? 5 : 4, true));
                    break;
                case 2:
                    loadmore = true;
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            Intent chatIntent = new Intent(getActivity(), FuguChatActivity.class);
                            chatIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(filterModel.getConversation(), Conversation.class));
                            startActivityForResult(chatIntent, 100);
                            //HippoApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.CHAT_CLICKED, "conversation_clicked");
                            isFromFilter = false;
                            BusProvider.getInstance().post(new FragmentEvent(1, isAllChats() ? 5 : 4, false));
                        }
                    }, 50);
                    break;
                default:
                    loadmore = true;
                    applyFilter(filterModel);
                    BusProvider.getInstance().post(new FragmentEvent(1, isAllChats() ? 5 : 4, true));
                    break;
            }
        }
    }

    private void selectPeopleItem() {
        selectedPeopleUserId = null;
        selectedPeopleUserId = filterModel.getSelectedPeopleUserId();
        String customLabel = null;
        if (filterModel.getSearchCustomLabel() > 0)
            customLabel = Integer.toString(filterModel.getSearchCustomLabel());
        apiGetConversation(selectedPeopleUserId, String.valueOf(HippoApplication.getInstance().getUserData().getUserId()), getStatusFilter(),
                getTypeFilter(), getLabelsFilter(), 0, false, true, true, getChannelFilter(), customLabel, filterModel);
        selectedPeople = null;
        selectedPeople = filterModel.getSelectedPeople();
    }

    private void applyFilter(FilterModel filterModel) {
        String customLabel = null;
        if (filterModel.getSearchCustomLabel() > 0)
            customLabel = Integer.toString(filterModel.getSearchCustomLabel());

        String searchUserId = String.valueOf(HippoApplication.getInstance().getUserData().getUserId());
        if (!TextUtils.isEmpty(selectedPeopleUserId))
            searchUserId = selectedPeopleUserId;

        apiGetConversation(searchUserId,
                String.valueOf(HippoApplication.getInstance().getUserData().getUserId()),
                getStatusFilter(), getTypeFilter(), getLabelsFilter(),
                0, false, true, true, getChannelFilter(), customLabel, filterModel);
    }

    private void removeTotalPushUnread(int channelId) {
        try {
            if (HippoConfig.getInstance().getInternalListener() != null) {
                HippoConfig.getInstance().getInternalListener().removeTotalPushUnread(channelId);
            } else {
                for (UnreadListener listener : HippoApplication.getInstance().getUIListeners(UnreadListener.class)) {
                    if (listener != null)
                        listener.removeTotalPushUnread(channelId);
                }
            }
        } catch (Exception e) {

        }
    }

    private void addTotalPushUnread(int channelId) {
        try {
            if (HippoConfig.getInstance().getInternalListener() != null) {
                HippoConfig.getInstance().getInternalListener().addTotalPushUnread(channelId);
            } else {
                for (UnreadListener listener : HippoApplication.getInstance().getUIListeners(UnreadListener.class)) {
                    if (listener != null)
                        listener.addTotalPushUnread(channelId);
                }
            }
        } catch (Exception e) {

        }
    }

    private void getAgentSupportChannels(int pageStart, final boolean isPagination,
                                         boolean showLoading, boolean isFromFilter, int selectedPos, ArrayList<Integer> selectedStatus) {
        pageStart = pageStart > 0 ? pageStart : 1;
        pageEnd = pageStart + defaultPageSize - 1;
        HashMap<String, Object> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put(Constants.DEVICE_TYPE, Constants.ANDROID);
        params.put(Constants.APP_VERSION, BuildConfig.VERSION_CODE);
        params.put(Constants.PAGE_OFFSET, pageStart);
        params.put(Constants.ROW_COUNT, pageEnd);
        if (isFromFilter) {
            switch (selectedPos) {
                case 0:
                    break;
                case 1:
                    params.put("fetch_my_chats_only", true);
                    break;
                case 2:
                    params.put("fetch_unassigned_chats", true);
                    break;
                case 3:
                    params.put("fetch_my_support_chats", true);
                    break;

            }
            if (selectedStatus != null && selectedStatus.size() > 0) {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < selectedStatus.size(); i++) {
                    jsonArray.put(selectedStatus.get(i));

                }
                params.put("channel_status", jsonArray);
            }
        }

        CommonParamsObj paramsObj = new CommonParamsObj.Builder()
                .addAll(params)
                .build();

        RestClient.getApiInterface().getAgentSupportChannels(paramsObj.getMap()).enqueue(new ResponseResolver<GetConversationResponse>(getActivity(), showLoading, true) {
            @Override
            public void success(GetConversationResponse createConversation) {
                LoadingBox.showOn(getActivity());
                rlUpdatingConvo.setGravity(View.GONE);
                parseData(createConversation, isPagination);
            }

            @Override
            public void failure(APIError error) {
                rlUpdatingConvo.setGravity(View.GONE);
            }
        });
    }

    private void parseData(GetConversationResponse getConversationResponse, Boolean isPagination) {
        try {
            Log.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
            if (getConversationResponse != null) {
                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode()) {
                    try {

                        if (getConversationResponse.getData().getConversation().size() < defaultPageSize) {
                            loadmore = false;
                        } else {
                            loadmore = true;

                        }
                    } catch (Exception e) {

                    }

                    try {
                        for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                            if (conversation.getInRideTime() > 1) {
                                conversation.setUserOnline(true);
                                conversation.setEndTime(DateUtils.getInstance().getRemainingTime(conversation.getInRideTime()));
                            }
                        }
                    } catch (Exception e) {

                    }
                    if (getConversationResponse.getData().getVersion() != null &&
                            getConversationResponse.getData().getVersion().getIsForce() != null) {

                        if (getConversationResponse.getData().getVersion().getLatestVersion() > BuildConfig.VERSION_CODE) {
                            if (getConversationResponse.getData().getVersion().getIsForce().equals(1)) {
                                SingleBtnUpdateWindow(getConversationResponse);
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getIsForce());
                                getSrLayout().setRefreshing(false);
                            } else if (getConversationResponse.getData().getVersion().getIsForce().equals(0)) {
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                getConversationApiHit = true;
                                // TODO: 2019-12-30
                                //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                conversationChatList.clear();
                                conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                setConversationChatData(conversationChatList, isPagination);
                                toggleProgressBarVisibility(false);
                                getSrLayout().setRefreshing(false);

                                setPagingApiInProgress(false);
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                showUpdateWindowTwoBtns(getConversationResponse, isPagination);
                            } else {
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                                getConversationApiHit = true;
                                //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                                conversationChatList.clear();
                                conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                setConversationChatData(conversationChatList, isPagination);
                                toggleProgressBarVisibility(false);
                                getSrLayout().setRefreshing(false);

                                setPagingApiInProgress(false);

                            }
                        } else {
                            Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                            Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, getConversationResponse.getData().getVersion().getLatestVersion());
                            getConversationApiHit = true;
                            //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                            conversationChatList.clear();
                            conversationChatList.addAll(getConversationResponse.getData().getConversation());
                            setConversationChatData(conversationChatList, isPagination);
                            toggleProgressBarVisibility(false);
                            getSrLayout().setRefreshing(false);

                            setPagingApiInProgress(false);

                        }
                    } else {
                        getConversationApiHit = true;
                        //((MainActivity) getActivity()).getConversationResponse = getConversationResponse;
                        conversationChatList.clear();
                        conversationChatList.addAll(getConversationResponse.getData().getConversation());
                        setConversationChatData(conversationChatList, isPagination);
                        toggleProgressBarVisibility(false);
                        getSrLayout().setRefreshing(false);

                        setPagingApiInProgress(false);
                    }
                }
            }
            LoadingBox.hide();
        } catch (Exception e) {
            Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }


    public void applyFilter(Boolean isReset, int selectedPos, ArrayList<Integer> selectedStatus) {
        isFromFilter = !isReset;
        this.selectedPos = selectedPos;
        this.selectedStatus = selectedStatus;
        getAgentSupportChannels(1, false, true, isFromFilter, selectedPos, selectedStatus);

    }

}