package com.hippoagent.fragments;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.databinding.FragmentStatusBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Filter;

import java.util.ArrayList;

import static androidx.databinding.DataBindingUtil.inflate;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class StatusFragment extends Fragment {
    private static final String TAG = StatusFragment.class.getSimpleName();

    private FragmentStatusBinding fragmentBinding;
    public ArrayList<Filter> chatStatus = new ArrayList<>();
    private FilterActivity activity;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
         fragmentBinding = inflate(inflater, R.layout.fragment_status,
                container, false);
        View view = fragmentBinding.getRoot();
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = (FilterActivity) getActivity();
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        chatStatus.addAll(activity.getFilterModel().getStatusArrayList());

        fragmentBinding.cbOpenChat.setText(Restring.getString(getActivity(), R.string.open_chats));
        fragmentBinding.cbClosedChat.setText(Restring.getString(getActivity(), R.string.closed_chats));

        if(chatStatus.get(0).getChecked()) {
            fragmentBinding.cbOpenChat.setChecked(true);
        }

        if(chatStatus.get(1).getChecked()) {
            fragmentBinding.cbClosedChat.setChecked(true);
        }

        fragmentBinding.cbOpenChat.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(compoundButton.isPressed()) {
                    chatStatus.get(0).setChecked(b);
                }
            }
        });
        fragmentBinding.cbClosedChat.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(compoundButton.isPressed()) {
                    chatStatus.get(1).setChecked(b);
                }
            }
        });

    }

}
