package com.hippoagent.helper

import android.os.Handler
import android.text.TextUtils
import com.google.gson.Gson
import com.hippoagent.Config
import com.hippoagent.HippoActivityLifecycleCallback
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.callback.ConnectionListener
import com.hippoagent.callback.CountDownTimerListener
import com.hippoagent.callback.OnCloseListener
import com.hippoagent.callback.OnInitializedListener
import com.hippoagent.confcall.OngoingCallService
import com.hippoagent.database.CommonData
import com.hippoagent.encription.Encrypt
import com.hippoagent.encription.MainActivityInterface
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.model.InfoModel
import com.hippoagent.receiver.NetworkStatus
import com.hippoagent.utils.DateUtils
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import org.json.JSONObject
import socket.io.BaseSocketClient
import socket.io.FayeClientListener
import socket.io.SocketIOClient
import socket.io.SocketMessage
import java.util.*


/**
 * Created by gurmail on 2020-04-18.
 * @author gurmail
 */
object ConnectionManager : OnCloseListener, OnInitializedListener {

    override fun onClose() {
        stopFayeClient()
        //closeConnection()
    }

    override fun onInitialized() {
        initFayeConnection()
    }

    private var fayeClient: BaseSocketClient? = null
    private val mChannels: HashSet<String> = HashSet()
    private val mPendingChannels: HashSet<String> = HashSet()
    private var connecting = false
    private var isDelaySubscribe = false

    //private var handler: Handler = Handler(Looper.getMainLooper())
    private val RECONNECTION_TIME = 5000
    private var retryCount = 0
    private var stopConnection = false

    private val NOT_CONNECTED = 0
    private val CONNECTED_TO_INTERNET = 1
    private val CONNECTED_TO_INTERNET_VIA_WIFI = 2
    private var NETWORK_STATUS = 1

    private var pongCount = 0
    private const val MAX_COUNT = 5
    private const val MAX_RETRY_ATTEMPTS = 50

    fun initFayeConnection() {
        println("~~~~~~~~~>> " + "initfye called")
//        if (fayeClient == null) {
        if (!isConnected()) {
            println("~~~~~~~~~>> " + "initfye is null")

            val time = Date().time + CommonData.getDiff()
            val localDate = DateUtils.getFormattedDate(Date(time))
            val info = InfoModel(
                2,
                HippoApplication.getInstance().userData.enUserId,
                HippoApplication.getInstance().userData.accessToken,
                DateUtils.getInstance().convertToUTC(localDate)
            )
            println("info~~~~~~~~~>>" + Gson().toJson(info))

            val encryptionObj = Encrypt(MainActivityInterface { message ->
                println("~~~~~~~~~>> " + message)
                connectSocket(message)
            }, HippoActivityLifecycleCallback.mJsEncryptor)

            GlobalScope.launch(Dispatchers.Main) {
                encryptionObj.encryptAndUpdate(Gson().toJson(info), CommonData.getAuthKey())
            }
        }
        setListener()
    }

    private fun connectSocket(message: String) {
        getSocketIOClicnt(message, object : ConnectionListener {
            override fun onConnect(socketClient: BaseSocketClient?) {
                fayeClient = socketClient
                if (fayeClient != null && !isConnected() && !connecting) {
                    fayeClient!!.connectServer()
                    connecting = true
                    println("########################## ConnectionManager initFayeConnection ##########################")
                }
                setListener()
            }
        })
    }

    private fun getSocketIOClicnt(message: String, callback: ConnectionListener) {
        val socketMessage = SocketMessage()
        if (fayeClient != null) {
            fayeClient == null
        }
        if (HippoApplication.getInstance().userData != null && !TextUtils.isEmpty(HippoApplication.getInstance().userData.enUserId)) {
            val jObj = JSONObject()
            jObj.putOpt(
                SocketMessage.KEY_APP_SECRET_KEY,
                HippoApplication.getInstance().userData.appSecretKey
            )
            jObj.putOpt(
                SocketMessage.KEY_EN_USER_ID,
                HippoApplication.getInstance().userData.enUserId
            )
            jObj.putOpt(SocketMessage.KEY_DEVICE_TYPE, 1)
            jObj.putOpt(SocketMessage.KEY_SOURCE, 1)
            println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")
            println("language = " + HippoConfig.getInstance().currentLanguage)
            println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")
            if (TextUtils.isEmpty(HippoConfig.getInstance().currentLanguage)) {
                jObj.putOpt(SocketMessage.KEY_LANG, "en")
            } else {
                jObj.putOpt(SocketMessage.KEY_LANG, HippoConfig.getInstance().currentLanguage)
            }

            socketMessage.setUserAuthObj(jObj)

            fayeClient = SocketIOClient(getSocketIOUrl(), socketMessage, message)
            callback.onConnect(fayeClient)
        } else {
            return callback.onConnect(null)
        }

    }


    fun forceInitFayeConnection() {
        fayeClient = null
        if (fayeClient == null) {
            val time = Date().time + CommonData.getDiff()
            val localDate = DateUtils.getFormattedDate(Date(time))
            val info = InfoModel(
                2,
                HippoApplication.getInstance().userData.enUserId,
                HippoApplication.getInstance().userData.accessToken,
                DateUtils.getInstance().convertToUTC(localDate)
            )
            println(Gson().toJson(info))
            val encryptionObj = Encrypt(MainActivityInterface { message ->
                println("~~~~~~~~~>> " + message)
                connectSocket(message)
            }, HippoActivityLifecycleCallback.mJsEncryptor)

            encryptionObj.encryptAndUpdate(Gson().toJson(info), CommonData.getAuthKey())
        }
        setListener()
    }

    private fun getSocketIOClient(): BaseSocketClient? {
        val socketMessage = SocketMessage()
        var data: String = ""
        if (fayeClient != null) {
            fayeClient == null
        }

        if (fayeClient == null) {
            if (HippoApplication.getInstance().userData != null && !TextUtils.isEmpty(
                    HippoApplication.getInstance().userData.enUserId
                )
            ) {
                val jObj = JSONObject()
                jObj.putOpt(
                    SocketMessage.KEY_APP_SECRET_KEY,
                    HippoApplication.getInstance().userData.appSecretKey
                )
                jObj.putOpt(
                    SocketMessage.KEY_EN_USER_ID,
                    HippoApplication.getInstance().userData.enUserId
                )
                jObj.putOpt(SocketMessage.KEY_DEVICE_TYPE, 1)
                jObj.putOpt(SocketMessage.KEY_SOURCE, 1)
                println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")
                println("language = " + HippoConfig.getInstance().currentLanguage)
                println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")
                if (TextUtils.isEmpty(HippoConfig.getInstance().currentLanguage)) {
                    jObj.putOpt(SocketMessage.KEY_LANG, "en")
                } else {
                    jObj.putOpt(SocketMessage.KEY_LANG, HippoConfig.getInstance().currentLanguage)
                }

                socketMessage.setUserAuthObj(jObj)
                data = Gson().toJson(jObj)
            } else {
                return null
            }
            //val enData = encrypt(HippoConfig.KEY, data)!!
            //println("~~~~~~~~~>> "+enData)
            fayeClient = SocketIOClient(getSocketIOUrl(), socketMessage, "enData")
        }
        return fayeClient
    }

    fun encryption(key: String, message: String, encryptionObj: Encrypt) {
        encryptionObj.encryptAndUpdate(message, key)
    }

    fun encrypt(
        socketMessage: SocketMessage,
        key: String,
        message: String,
        callback: ConnectionListener
    ) {
        val encryptionObj = Encrypt(MainActivityInterface { message ->
            fayeClient = SocketIOClient(getSocketIOUrl(), socketMessage, message)
            callback.onConnect(fayeClient)
        }, HippoActivityLifecycleCallback.mJsEncryptor)

        encryptionObj.encryptAndUpdate(message, key)
    }

    private fun getUpdatedTime(
        socketMessage: SocketMessage,
        key: String,
        value: InfoModel,
        callback: ConnectionListener
    ) {
        encrypt(socketMessage, key, Gson().toJson(value), callback)

//        println("~~~~~~~~~>> in getUpdatedTime")
//        FirebaseFunctions.getInstance().getHttpsCallable("getTime")
//            .call().addOnSuccessListener { HttpsCallableResult ->
//                val timestamp: Long = HttpsCallableResult.data as Long
//                println("timestamp ~~~~~~~~~>> "+timestamp)
//                value.created_at = timestamp.toString()
//                println(Gson().toJson(value))
//                encrypt(socketMessage, key, Gson().toJson(value), callback)
//            }
    }


    private fun reconnectConnection() {
        initFayeConnection()
    }

    private fun forceReConnection() {
        forceInitFayeConnection();
    }

    private fun getSocketIOUrl(): String {
        if (Config.getServerUrl() == Config.getLiveBetaServerUrl()) {
//            return "https://beta-live-api.fuguchat.com:3001"
//            return "https://beta-live-api1.fuguchat.com:3003"
            return "https://socket-temp.hippochat.io/";
        } else
            return Config.getFayeServerUrl();
    }


    private fun setListener() {
        if (fayeClient != null) {
            fayeClient!!.setmConnectionListener(object : FayeClientListener {

                override fun onConnectedServer(fc: BaseSocketClient?) {
                    stopConnection = true
                    connecting = false
                    retryCount = 0
                    if (!isDelaySubscribe)
                        subscribePendingChannels()
                    else
                        subscribeDelayPendingChannels()
                    BusProvider.getInstance()
                        .post(FayeMessage(BusEvents.CONNECTED_SERVER.toString(), "", ""))
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onConnectedServer <<<<<<<<<<<<<<<<<<<<<<")
                    stopAutoAttemptConnection()
                }

                override fun onDisconnectedServer(fc: BaseSocketClient?) {
                    connecting = false
                    stopConnection = false
                    if (!forceStop) {
                        saveSubsribedChannels()
                        BusProvider.getInstance()
                            .post(FayeMessage(BusEvents.DISCONNECTED_SERVER.toString(), "", ""))
                        println(">>>>>>>>>>>>>>>>> ConnectionManager onDisconnectedServer <<<<<<<<<<<<<<<<<<<<<<")
                        attemptAutoConnection()
                    }
                }

                override fun onReceivedMessage(
                    fc: BaseSocketClient?,
                    msg: String?,
                    channel: String?
                ) {
                    //connecting = true
                    stopConnection = true
                    retryCount = 0
                    ParseMessage.receivedMessage(msg, channel)
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onReceived >>>>>>>>>>>>>>>>> ConnectionManager onReceivedMessage <<<<<<<<<<<<<<<<<<<<<<Message <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onPongReceived() {
                    //connecting = true
                    stopConnection = true
                    retryCount = 0
                    subscribePendingChannels()
                    BusProvider.getInstance()
                        .post(FayeMessage(BusEvents.PONG_RECEIVED.toString(), "", ""))
                    pongCount()
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onPongReceived <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onWebSocketError() {
                    connecting = false
                    pongCount = 0
                    BusProvider.getInstance()
                        .post(FayeMessage(BusEvents.WEBSOCKET_ERROR.toString(), "", ""))
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onWebSocketError <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onErrorReceived(
                    fc: BaseSocketClient?,
                    msg: String?,
                    channel: String?
                ) {
                    //connecting = true
                    BusProvider.getInstance()
                        .post(FayeMessage(BusEvents.ERROR_RECEIVED.toString(), channel, msg))
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onErrorReceived <<<<<<<<<<<<<<<<<<<<<<")
                    if (timerListener != null) {
                        timerListener!!.onErrorReceived(channel, msg)
                    }
                }

                override fun onNotConnected() {
                    connecting = false
                    pongCount = 0
                    BusProvider.getInstance()
                        .post(FayeMessage(BusEvents.NOT_CONNECTED.toString(), "", ""))
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onNotConnected <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onSubscriptionError() {
                    //connecting = true
                    retryCount = 0
                    println(">>>>>>>>>>>>>>>>> ConnectionManager subscriptionError <<<<<<<<<<<<<<<<<<<<<<")
                    reSubscribeChannels()
                }
            })
        }
    }

    public fun isConnected(): Boolean {
        return fayeClient != null && fayeClient!!.isConnectedServer()
    }

    public fun subScribeChannel(channel: String) {
        println(">>>>>>>>>>>>>>>>>>  $channel <<<<<<<<<<<<<<<<<")
        if (isConnected()) {
            if (!mChannels.contains(channel)) {
                mChannels.add(channel)
                fayeClient!!.subscribeChannel(channel)
            } else {
                // already subscribed channel
            }
        } else {
            // pending channels for subscriptions
            mPendingChannels.add(channel)
            reconnectConnection()
        }
    }

    public fun subscribeOnDelay(channel: String) {
        if (isConnected()) {
            if (!mChannels.contains(channel)) {
                mChannels.add(channel)
                fayeClient!!.subscribeChannel(channel)
            } else {
                mChannels.add(channel)
                fayeClient!!.subscribeChannel(channel)
                // already subscribed channel
            }
        } else {
            isDelaySubscribe = true
            mPendingChannels.add(channel)
            reconnectConnection()
        }
    }

    public fun unsubScribeChannel(channel: String) {
        mChannels.remove(channel)
        if (isConnected())
            fayeClient!!.unsubscribeChannel(channel)
    }

    public fun publish(channel: String, jsonObject: JSONObject) {
//        if (jsonObject.has(FuguAppConstant.IS_TYPING)) {
//            jsonObject.put("lang", HippoConfig.getInstance().currentLanguage)
//        }
        publish(channel, jsonObject, false)
    }

    var count: Int = 0
    public fun publish(channel: String, jsonObject: JSONObject, hasEncrypt: Boolean) {
        if (isConnected()) {
            fayeClient!!.publish(channel, jsonObject, hasEncrypt)
        } else {
            mPendingChannels.add(channel)
            if (connecting) {
                count += 1;
            }

            if (count > 2) {
                count = 0;
                forceReConnection()
            } else {
                //CoroutineScope
                reconnectConnection()
            }
        }
    }

    private fun pongCount() {
        pongCount += 1
        if (pongCount > MAX_COUNT) {
            if (HippoConfig.getInstance().context == null || !ConnectionUtils.isAppRunning(
                    HippoConfig.getInstance().context
                )
            ) {
                if (!OngoingCallService.NotificationServiceState.isConferenceConnected) {
//                if (HippoConfig.getInstance().fayeCallDate == null || !HippoConfig.getInstance().fayeCallDate.isCallServiceRunning()) {
                    println("Closing connection")
                    stopFayeClient()
                } else {
                    pongCount = 0
                    println("Inside the running activities")
                }
            } else {
                pongCount = 0
                println("Outside the running activities")
            }
        }
    }

    var forceStop: Boolean = false
    private fun stopFayeClient() {
        if (fayeClient != null && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
//        if(fayeClient != null &&
//                (HippoConfig.getInstance().fayeCallDate == null || !HippoConfig.getInstance().fayeCallDate.isCallServiceRunning())) {
//            val thread = HandlerThread("TerminateThread")
//            thread.start()
//            Handler(thread.looper).post(Runnable {
            if (fayeClient != null) {
                mPendingChannels.clear()
                mChannels.clear()
                if (isConnected()) {
                    forceStop = true
                    fayeClient!!.disconnectServer()
                }
                pongCount = 0
                fayeClient = null
                connecting = false
            }
//            })
        }
    }

    private fun reSubscribeChannels() {
        synchronized(this) {
            val tempChannel = mChannels
            for (channel in tempChannel) {
                unsubScribeChannel(channel)
            }
            Handler().postDelayed({
                for (channel in tempChannel) {
                    subScribeChannel(channel)
                }
            }, 500)
        }
    }

    private fun subscribePendingChannels() {
        synchronized(this) {
            if (mPendingChannels.size > 0) {
                val tempChannel = mPendingChannels
                for (channel in tempChannel) {
                    fayeClient!!.subscribeChannel(channel)
                    mChannels.add(channel)
                }
                mPendingChannels.removeAll(tempChannel)
            }
        }
    }

    private fun subscribeDelayPendingChannels() {
        Handler().postDelayed({
            isDelaySubscribe = false
            if (mPendingChannels.size > 0) {
                val tempChannel = mPendingChannels
                for (channel in tempChannel) {
                    fayeClient!!.subscribeChannel(channel)
                }
                mPendingChannels.removeAll(tempChannel)
            }
        }, 2000)
    }

    public fun changeStatus(status: Int) {
        NETWORK_STATUS = status
        when (status) {
            NOT_CONNECTED -> {
                saveSubsribedChannels()
                stopAutoAttemptConnection()
                retryCount = 0
                BusProvider.getInstance().post(NetworkStatus(NOT_CONNECTED))
            }
            CONNECTED_TO_INTERNET, CONNECTED_TO_INTERNET_VIA_WIFI -> {
                initFayeConnection()
                BusProvider.getInstance().post(NetworkStatus(CONNECTED_TO_INTERNET))
            }
        }
    }

    @Synchronized
    private fun saveSubsribedChannels() {
        connecting = false
        if (mChannels.size > 0) {
            mPendingChannels.addAll(mChannels)
            mChannels.clear()
        }
    }

    private fun attemptAutoConnection() {
        if (NETWORK_STATUS != NOT_CONNECTED) {
            if (retryCount < MAX_RETRY_ATTEMPTS && !stopConnection) {
                retryCount += 1
                try {
                    Timer().schedule(object : TimerTask() {
                        override fun run() {
                            try {
                                if (!stopConnection)
                                    initFayeConnection()
                            } catch (e: Exception) {

                            }
                        }
                    }, RECONNECTION_TIME.toLong())
                } catch (e: Exception) {
                }
            }
        }
    }

    private fun stopAutoAttemptConnection() {
        //handler.removeCallbacks(runnable)
    }

    internal var runnable: Runnable = Runnable {
        try {
            println("************************** RECONNECTING ***********************************")
            initFayeConnection()
        } catch (e: Exception) {

        }
    }


    // todo: need to check this callback
    internal var timerListener: CountDownTimerListener? = null
    fun setCountDownTimerListener(listener: CountDownTimerListener?) {
        timerListener = listener;
    }

}