package com.hippoagent.helper

import android.content.Intent
import android.text.TextUtils
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.google.gson.Gson
import com.hippoagent.HippoActivityLifecycleCallback
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.callback.UnreadListener
import com.hippoagent.confcall.HippoAudioManager
import com.hippoagent.confcall.HungUpBroadcast
import com.hippoagent.confcall.OngoingCallService
import com.hippoagent.confcall.PushReceiver
import com.hippoagent.database.CommonData
import com.hippoagent.database.UserCommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.FuguAppConstant.CHANNEL_ID
import com.hippoagent.encription.Encrypt
import com.hippoagent.encription.MainActivityInterface
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.hippocall.*
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.MESSAGE_UNIQUE_ID
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.VIDEO_CALL_TYPE
import com.hippoagent.model.MessageInfo
import com.hippoagent.utils.Log
import org.json.JSONObject
import java.util.*

/**
 * Created by gurmail on 2020-04-19.
 * @author gurmail
 */
object ParseMessage {


    fun receivedMessage(msg: String?, channel: String?) {
        if (TextUtils.isEmpty(msg))
            return

        try {
            val data = JSONObject(msg)
            when (data.optInt("message_type")) {
                18 -> callingFlow(data, msg, channel)
                27 -> GroupCallingFlow(data, msg, channel)
                else -> {
                    BusProvider.getInstance().post(FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg))
                    try {
                        if (data.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.ASSIGN_CHAT) {
                            if (data.optInt("assigned_to") == HippoApplication.getInstance().userData.userId) {
                                if (HippoConfig.getInstance().assignmentListener != null)
                                    HippoConfig.getInstance().assignmentListener.onChatAssign(msg)
                            } else {
                                removeTotalPushUnread(data.optInt("channel_id"))
                            }
                        }
                        if (data.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.TEXT_MESSAGE) {
                            if (data.optInt("last_sent_by_id", -1) == HippoApplication.getInstance().userData.userId!!.toInt()) {
                                removeTotalPushUnread(data.optInt("channel_id"))
                            } else {
                                updateCount(data.optInt("channel_id"))
                            }
                        } else if (data.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.READ_MESSAGE) {
                            removeTotalPushUnread(data.optInt("channel_id"))
                        }
                    } catch (e: Exception) {
                    }
                }
            }
        } catch (e: Exception) {
            //e.printStackTrace()
            BusProvider.getInstance().post(FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg))
        }
    }

    private fun GroupCallingFlow(data: JSONObject, msg: String?, channel: String?) {
        when (data.getString(VIDEO_CALL_TYPE)) {
            WebRTCCallConstants.JitsiCallType.JOIN_GROUP_CALL.toString() -> {
                val finalUserId1 = HippoApplication.getInstance().userData.userId
                val deviceId = com.hippoagent.hippocall.CommonData.getUniqueIMEIId(HippoApplication.getInstance().applicationContext)
                val remoteDeviceId = data.getJSONObject("device_payload").optString("device_id")
                if (finalUserId1 == data.optInt("user_id", -1) && deviceId != remoteDeviceId
                        && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
                    val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                    mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
                    if (ConnectionUtils.isMyServiceRunning(HippoCallConfig.getInstance().context, OngoingCallService::class.java)) {
                        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
                        val startIntent = Intent(HippoCallConfig.getInstance().context, OngoingCallService::class.java)
                        HippoCallConfig.getInstance().context.stopService(startIntent)
                    }
                    if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                        ConnectionManager.onClose()
                    }
                }
            }
            WebRTCCallConstants.VideoCallType.END_GROUP_CALL.toString() -> endSessionConference(data)

        }
    }

    private fun callingFlow(data: JSONObject, msg: String?, channel: String?) {
        when (data.getString(VIDEO_CALL_TYPE)) {
            FuguAppConstant.JitsiCallType.START_CONFERENCE.toString() -> startConference(data)
            FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString() -> offerConference(data)
            FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString() -> rejectConference(data)
            FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString() -> hungupConference(data)
            FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString() -> {
                val finalUserId1 = HippoApplication.getInstance().userData.userId
                val deviceId = com.hippoagent.hippocall.CommonData.getUniqueIMEIId(HippoApplication.getInstance().applicationContext)
                val remoteDeviceId: String = try {
                    data.optJSONObject("device_payload").optString("device_id")
                } catch (e: Exception) {
                    ""
                }
                if (finalUserId1 == data.optInt("user_id", -1) && deviceId != remoteDeviceId) {
                    val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                    mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
                    mIntent2.putExtra(FuguAppConstant.JITSI_URL, data.optString(FuguAppConstant.JITSI_URL))
                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
                    if (ConnectionUtils.isMyServiceRunning(HippoCallConfig.getInstance().context, OngoingCallService::class.java)) {
                        val startIntent = Intent(HippoCallConfig.getInstance().context, OngoingCallService::class.java)
                        HippoCallConfig.getInstance().context.stopService(startIntent)
                        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
                    }
                    if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                        ConnectionManager.onClose()
                    }
                } else {
                    if (!TextUtils.isEmpty(msg))
                        BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                }

            }
            WebRTCCallConstants.VideoCallType.CALL_HUNG_UP.toString() -> {

                val finalUserId1 = HippoApplication.getInstance().userData.userId
                val deviceId = com.hippoagent.hippocall.CommonData.getUniqueIMEIId(HippoApplication.getInstance().applicationContext)
                val remoteDeviceId: String = try {
                    data.optJSONObject("device_payload").optString("device_id")
                } catch (e: Exception) {
                    ""
                }
                if (finalUserId1 == data.optInt("user_id", -1) && deviceId != remoteDeviceId) {
                    val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                    mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
                    if (ConnectionUtils.isMyServiceRunning(HippoCallConfig.getInstance().context, OngoingCallService::class.java)) {
                        val startIntent = Intent(HippoCallConfig.getInstance().context, OngoingCallService::class.java)
                        HippoCallConfig.getInstance().context.stopService(startIntent)
                        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
                    }
                    if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                        ConnectionManager.onClose()
                    }
                }
            }
            FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE.toString() -> {
                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                if (OngoingCallService.CallState.muid.equals(data.optString("muid"), ignoreCase = true)) {
                    OngoingCallService.CallState.readyToConnect = 1
                }
            }
            WebRTCCallConstants.VideoCallType.START_CALL.toString() -> HippoCallConfig.getInstance().oldSDKCall(msg, channel)
            WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString() -> HippoCallConfig.getInstance().oldSDKCall(msg, channel)
            FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE.toString() -> {
//                if(!TextUtils.isEmpty(msg))
//                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                HippoConfig.getInstance().setBusyMuid(data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID));
                val finalUserId1 = HippoApplication.getInstance().userData.userId
                val deviceId = com.hippoagent.hippocall.CommonData.getUniqueIMEIId(HippoApplication.getInstance().applicationContext)
                val remoteDeviceId = data.getJSONObject("device_payload").optString("device_id")
                if (finalUserId1 == data.optInt("user_id", -1) && deviceId != remoteDeviceId) {
                    val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                    mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
                    mIntent2.putExtra(FuguAppConstant.JITSI_URL, data.optString(FuguAppConstant.JITSI_URL))
                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
                    if (ConnectionUtils.isMyServiceRunning(HippoCallConfig.getInstance().context, OngoingCallService::class.java)) {
                        val startIntent = Intent(HippoCallConfig.getInstance().context, OngoingCallService::class.java)
                        HippoCallConfig.getInstance().context.stopService(startIntent)
                        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
                    }
                    if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                        ConnectionManager.onClose()
                    }
                } else {
                    if (!TextUtils.isEmpty(msg))
                        BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                }
            }
            else -> {
                if (!TextUtils.isEmpty(msg))
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                Log.e("msg", "~~&~^*&^~*&^~*&^~*^~*~^*~^*~&^~*^~*&^~*&~^*~&^&*~ => $msg");
            }
        }
    }

    //
    private fun startConference(data: JSONObject) {
        val finalUserId1 = HippoApplication.getInstance().userData.userId
        if (finalUserId1 != data.optInt("user_id", -1)
                && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
            var flag = true
            if (OngoingCallService.CallState.muid.equals(data.optString("muid"), ignoreCase = true) && OngoingCallService.CallState.readyToConnect == 1) {
                flag = false
            }
            if (flag) {
                preStartConference(data)
            }
            return
        }

        if (OngoingCallService.NotificationServiceState.isConferenceConnected) {
            emitUserBusy(data, finalUserId1)
            emitUserChannelBusy(data, finalUserId1)
        }
    }

    private fun offerConference(data: JSONObject) {
        val finalUserId1 = HippoApplication.getInstance().userData.userId
        if (finalUserId1 != data.optInt("user_id", -1)
                && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
            val turnCredentials = AppContants().turnCredentials
            val myName = HippoApplication.getInstance().userData.fullName
            val myImage = HippoApplication.getInstance().userData.userImage


            val userId = HippoApplication.getInstance().userData.userId
            val fullname = data.optString("full_name")
            val channelId = data.optLong("channel_id")
            val messageUniqueId = data.optString("muid")
            val videoCallType = data.optString("video_call_type", "")

            val callType = data.optString("call_type", "")
            val activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString()
            val userImage = data.optString("user_thumbnail_image")
            val jitsiUrl = data.optString(FuguAppConstant.JITSI_URL)

            val authObj = HippoCallConfig.getInstance().getAuthObj(messageUniqueId)
            if (!TextUtils.isEmpty(authObj))
                data.put("auth0", authObj)


            val videoCallModel = VideoCallModel(channelId,
                    data.optString("user_thumbnail_image"),
                    data.optString("full_name"),
                    userId,
                    -1,
                    fullname,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    ArrayList(),
                    ArrayList(),
                    activityLaunchState,
                    messageUniqueId,
                    callType.toUpperCase(), "", jitsiUrl, "",
                    myName, myImage)

            if (HippoConfig.getInstance().busyMuid.equals(data.getString(MESSAGE_UNIQUE_ID), ignoreCase = true)) {
                return
            }

            OngoingCallService.NotificationServiceState.authObj = authObj

            if (OngoingCallService.NotificationServiceState.muid == data.getString(MESSAGE_UNIQUE_ID))
                return
            OngoingCallService.NotificationServiceState.muid = data.getString(MESSAGE_UNIQUE_ID)
            OngoingCallService.NotificationServiceState.inviteLink = data.getString("invite_link")
            val fuguNotificationConfig = PushReceiver().getInstance();
            fuguNotificationConfig.incomingCallNotification(HippoApplication.getInstance().applicationContext, data, videoCallModel)
        }
    }

    private fun rejectConference(data: JSONObject) {
        //val finalUserId1 = HippoApplication.getInstance().userData.userId
        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
        if (ConnectionUtils.isMyServiceRunning(HippoApplication.getInstance().applicationContext, OngoingCallService::class.java)) {
            val startIntent = Intent(HippoApplication.getInstance().applicationContext, OngoingCallService::class.java)
            HippoApplication.getInstance().applicationContext.stopService(startIntent)
        } else if (OngoingCallService.NotificationServiceState.inviteLink == data.optString("invite_link")) {
            BusProvider.getInstance().post(FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""))
            if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                ConnectionManager.onClose()
            }
        }
    }

    private fun endSessionConference(data: JSONObject) {
        if (OngoingCallService.NotificationServiceState.transactionId.equals(data.optString("transaction_id"))) {
            val hungupIntent = Intent(HippoApplication.getInstance().applicationContext, HungUpBroadcast::class.java)
            hungupIntent.putExtra("action", "endSession")
            HippoApplication.getInstance().applicationContext.sendBroadcast(hungupIntent)
            val mIntent = Intent("CALL_HANGUP")
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent)

            val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
            mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)

        }
        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
        if (HippoConfig.getInstance().groupSessionListener != null)
            HippoConfig.getInstance().groupSessionListener.onSessionEnded(data.optString("transaction_id"))
    }

    private fun hungupConference(data: JSONObject) {
        HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false)
        if (OngoingCallService.NotificationServiceState.inviteLink == data.optString("invite_link")) {
            val hungupIntent = Intent(HippoApplication.getInstance().applicationContext, HungUpBroadcast::class.java)
            hungupIntent.putExtra("action", "rejectCall")
            hungupIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID))
            HippoApplication.getInstance().applicationContext.sendBroadcast(hungupIntent)
            val mIntent = Intent("CALL_HANGUP")
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent)

            val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
            mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)

        } else {
            val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
            mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)

            if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                ConnectionManager.onClose()
            }
        }
    }

    private fun checkAnswerFrom(data: JSONObject) {
        val finalUserId1 = HippoApplication.getInstance().userData.userId
        val deviceId = com.hippoagent.hippocall.CommonData.getUniqueIMEIId(HippoApplication.getInstance().applicationContext)
        val remoteDeviceId = data.getJSONObject("device_payload").optString("device_id")
        if (finalUserId1 == data.optInt("user_id", -1) && deviceId != remoteDeviceId) {
            val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
            mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
            if (!ConnectionUtils.isAppRunning(HippoApplication.getInstance().applicationContext)) {
                ConnectionManager.onClose()
            }
        }
    }

    private fun preStartConference(data: JSONObject) {
        val authObj = HippoCallConfig.getInstance().getAuthObj(data.optString("muid", ""))
        val finalUserId1 = HippoApplication.getInstance().userData.userId
        if (TextUtils.isEmpty(authObj)) {
            val info = MessageInfo(HippoApplication.getInstance().userData.userId.toString(), data.getString("muid"))
            println(Gson().toJson(info))
            val encryptionObj = Encrypt(MainActivityInterface { message ->
                println("~~~~~~~~~>> " + message)
                HippoCallConfig.getInstance().saveData(data.optString("muid"), message)
                emitReadyToConnect(data, finalUserId1.toInt(), message)
            }, HippoActivityLifecycleCallback.mJsEncryptor)
            encryptionObj.encryptAndUpdate(Gson().toJson(info),  CommonData.getAuthKey())
        } else {
            emitReadyToConnect(data, finalUserId1.toInt(), authObj)
        }
    }


    private fun emitReadyToConnect(data: JSONObject, userId: Int?, authObj: String) {
        try {
            OngoingCallService.CallState.muid = data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID)
            val startCallJson = JSONObject()
            startCallJson.put(FuguAppConstant.IS_SILENT, true)
            startCallJson.put(FuguAppConstant.VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE)
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, data.getString(FuguAppConstant.CHANNEL_ID))
            startCallJson.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            try {
                startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, CommonData.deviceDetails(HippoApplication.getInstance().applicationContext))
            } catch (e: Exception) {
            }
            startCallJson.put(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            startCallJson.put(FuguAppConstant.JITSI_URL, data.optString(FuguAppConstant.JITSI_URL))
            startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID))
            startCallJson.put("auth0", authObj)

            startCallJson.put(WebRTCCallConstants.FULL_NAME, data.optString("full_name", ""))
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)

            val channelId = "/" + data.optLong(FuguAppConstant.CHANNEL_ID)
            ConnectionManager.publish(channelId, startCallJson)
            Log.e("Video_CONF-->", startCallJson.toString())
        } catch (e: Exception) {

        }
    }

    private fun emitUserBusy(jsonObject: JSONObject, userId: Int?) {
        try {
            val info = MessageInfo(HippoApplication.getInstance().userData.userId.toString(), jsonObject.getString("muid"))
            println(Gson().toJson(info))
            val encryptionObj = Encrypt(MainActivityInterface { message ->
                println("~~~~~~~~~>> " + message)
                val startCallJson = JSONObject()
                startCallJson.put(FuguAppConstant.IS_SILENT, false)
                startCallJson.put(FuguAppConstant.VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE)
                startCallJson.put(FuguAppConstant.USER_ID, userId)
                startCallJson.put(FuguAppConstant.CHANNEL_ID, jsonObject.optString(FuguAppConstant.CHANNEL_ID))
                startCallJson.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
                startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
                startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, CommonData.deviceDetails(HippoCallConfig.getInstance().context))
                startCallJson.put(FuguAppConstant.INVITE_LINK, jsonObject.optString(FuguAppConstant.INVITE_LINK))
                startCallJson.put(FuguAppConstant.JITSI_URL, jsonObject.optString(FuguAppConstant.JITSI_URL))
                startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, jsonObject.optString(FuguAppConstant.MESSAGE_UNIQUE_ID))
                startCallJson.put("auth0", message)
                startCallJson.put(WebRTCCallConstants.FULL_NAME, jsonObject.optString("full_name", ""))
                startCallJson.put("message", "")
                startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
                startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)

                val channelId = "/" + jsonObject.optLong(CHANNEL_ID)
                ConnectionManager.publish(channelId, startCallJson)
            }, HippoActivityLifecycleCallback.mJsEncryptor)
            encryptionObj.encryptAndUpdate(Gson().toJson(info),  CommonData.getAuthKey())


        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun emitUserChannelBusy(jsonObject: JSONObject, userId: Int?) {
        try {
            val startCallJson = JSONObject()
            startCallJson.put("server_push", true)
            startCallJson.put(FuguAppConstant.IS_SILENT, false)
            startCallJson.put(FuguAppConstant.VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE)
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, jsonObject.optString(FuguAppConstant.CHANNEL_ID))
            startCallJson.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, com.hippoagent.hippocall.CommonData.deviceDetails(HippoApplication.getInstance().applicationContext))
            startCallJson.put(FuguAppConstant.INVITE_LINK, jsonObject.optString(FuguAppConstant.INVITE_LINK))
            startCallJson.put(FuguAppConstant.JITSI_URL, jsonObject.optString(FuguAppConstant.JITSI_URL))
            startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, jsonObject.optString(FuguAppConstant.MESSAGE_UNIQUE_ID))

            startCallJson.put(WebRTCCallConstants.FULL_NAME, jsonObject.optString("full_name", ""))
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)

            val channelId = "/" + HippoApplication.getInstance().userData.userChannel.toString()
            ConnectionManager.publish(channelId, startCallJson)

        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun updateCount(channelId: Int) {
        try {
            if (HippoConfig.getInstance().internalListener != null) {
                HippoConfig.getInstance().internalListener.addTotalPushUnread(channelId)
            } else {
                for (listener in HippoApplication.getInstance().getUIListeners(UnreadListener::class.java)) {
                    if (listener != null)
                        listener.addTotalPushUnread(channelId)
                }
            }
        } catch (e: Exception) {

        }
    }

    private fun removeTotalPushUnread(channelId: Int) {
        try {
            if (HippoConfig.getInstance().internalListener != null) {
                HippoConfig.getInstance().internalListener.removeTotalPushUnread(channelId)
            } else {
                for (listener in HippoApplication.getInstance().getUIListeners(UnreadListener::class.java)) {
                    if (listener != null)
                        listener.removeTotalPushUnread(channelId)
                }
            }
        } catch (e: Exception) {

        }
    }
}