package com.hippoagent.hippocall;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.hippoagent.BuildConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.VideoSdkMeetingActivity;
import com.hippoagent.confcall.HungUpBroadcast;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.ShowDialg;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.hippocall.model.Message;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;

import org.jitsi.meet.sdk.JitsiMeet;
import org.jitsi.meet.sdk.JitsiMeetActivity;
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions;
import org.jitsi.meet.sdk.JitsiMeetUserInfo;
import org.json.JSONArray;
import org.json.JSONObject;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

import static android.content.Context.ACTIVITY_SERVICE;

/**
 * Created by gurmail on 04/01/19.
 *
 * @author gurmail
 */
public class HippoCallConfig implements FuguAppConstant {

    private static HippoCallConfig instance;
    private Boolean state = true;
    private CountDownTimer countDown;
    private StringAttributes actionString;
    private Context mContext;

    public static final String LOCAL_SURFACE = "hippo_local_status";
    public static final String REMOTE_SURFACE = "hippo_remote_status";
    public static final String FLIP_CAMERA = "hippo_flip_camera";
    public HashMap<String, String> authObj = new HashMap<>();

    private String INCOMING_CALL = "incoming Call";

    protected boolean isNetworkConnected() {
        return state;
    }

    public void networkStatus(boolean status) {
        this.state = status;
    }

    private HippoCallConfig() {

    }

    private String jitsiURL = "";

    public String getJitsiURL() {
        if (TextUtils.isEmpty(jitsiURL)) {
            if (HippoApplication.getInstance().getUserData() != null &&
                    HippoApplication.getInstance().getUserData().getBusinessProperty() != null &&
                    !TextUtils.isEmpty(HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl())) {
                jitsiURL = HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl();
            }
        }
        return jitsiURL;
    }

    public static HippoCallConfig getInstance() {
        if (instance == null) {
            synchronized (HippoCallConfig.class) {
                if (instance == null)
                    instance = new HippoCallConfig();
            }
        }
        return instance;
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public void setCallBackListener(Context context) {
        this.mContext = context;
        //setCallBackListener();
    }

    public void sendMessage(Long channelId, JSONObject jsonObject) {
        ConnectionManager.INSTANCE.publish("/" + channelId, jsonObject, true);
    }


    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId,
                                       String videoCallType, long userId) {
        Intent videoCallIntent = new Intent(VIDEO_CALL_INTENT);
        videoCallIntent.putExtra(CHANNEL_ID, channelId);
        videoCallIntent.putExtra(MESSAGE_UNIQUE_ID, messageUniqueId);
        videoCallIntent.putExtra(VIDEO_CALL_TYPE, videoCallType);
        videoCallIntent.putExtra(USER_ID, userId);
        LocalBroadcastManager.getInstance(context).sendBroadcast(videoCallIntent);
    }


    public void onNotificationReceived(Context context, JSONObject data) {
        try {
            onCallIncomming(context, data);
        } catch (Exception e) {
            if (HippoConfig.getInstance().getAttributes().isShowLog())
                e.printStackTrace();
        }
    }

    public void onConfNotificationReceived(Context context, JSONObject data) {
        try {
            onStartConferenceCall(context, data);
        } catch (Exception e) {
            if (HippoConfig.getInstance().getAttributes().isShowLog())
                e.printStackTrace();
        }
    }


    public void onCallClick(Context context, int callType, Long channelId, Integer userId, boolean isAgentFlow,
                            boolean isAllowCall, String fullname, String image) {

        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);

        if (!isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();

            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();

            String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
            if (callType == 2)
                typeCall = WebRTCCallConstants.CallType.AUDIO.toString();

            VideoCallModel videoCallModel = new VideoCallModel(channelId,
                    image, fullname, userId, -1, fullname,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                    (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                    activityLaunchState,
                    messageUniqueId,
                    typeCall, "", "", "", "", "");
            videoIntent.putExtra("videoCallModel", videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    public void onConfCallClick(Context context, VideoCallModel videoCallModel) {
        this.context = context;
        if (!isMyServiceRunning(context, OngoingCallService.class)) {
            Intent videoIntent = new Intent(context.getApplicationContext(), MainCallingActivity.class);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            videoIntent.putExtra("videoCallModel", videoCallModel);
            context.startActivity(videoIntent);
        }
    }

    private Long timeInMillis(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        Long timeInMilliseconds = 0L;
        try {
            Date mDate = sdf.parse(DateUtils.getInstance().convertToLocal(timeStamp));
            timeInMilliseconds = mDate.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return timeInMilliseconds;
    }


    private Context context;
    private JSONObject jsonObject;

    private void onCallIncomming(Context context, JSONObject jsonObject) throws Exception {
        this.context = context;
        this.jsonObject = jsonObject;

        Log.v("TAG", "jsonObject = " + jsonObject.toString());
        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);

        Integer userId = HippoApplication.getInstance().getUserData().getUserId();
        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");

        if (!taskList.get(0).topActivity.getClassName().equals("com.hippoagent.hippocall.FuguCallActivity")
                && !isMyServiceRunning(context, VideoCallService.class)
                && jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                && jsonObject.has(VIDEO_CALL_TYPE)
                && (jsonObject.optString(VIDEO_CALL_TYPE).equals("START_CALL"))
                && userId.compareTo(-1) != 0
                && !jsonObject.optString(DEVICE_ID, "").equals(UniqueIMEIID.getUniqueIMEIId(context))
                && userId.compareTo(jsonObject.optInt(USER_ID)) != 0
                && System.currentTimeMillis() - timeInMillis(jsonObject.getString("date_time")) < 30000) {

            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    countDown = new CountDownTimer(30000, 1000) {
                        @Override
                        public void onTick(long millisUntilFinished) {
                            //HippoLog.e("Socket Connection Timer", millisUntilFinished + "");
                        }

                        @Override
                        public void onFinish() {

                            ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);

                            if (!taskList.get(0).topActivity.getClassName().contains("hippocall")) {
//                                mClient.unsubscribeChannel("/"+channelId);
//                                mClient.disconnectServer();
                            }
                        }
                    };
                    countDown.start();
                }
            }, 0);


            ConnectionManager.INSTANCE.initFayeConnection();
            ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);

        } else {
            if (jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                    && jsonObject.has(VIDEO_CALL_TYPE)
                    && (jsonObject.optString(VIDEO_CALL_TYPE).equals("START_CALL"))) {

                ConnectionManager.INSTANCE.initFayeConnection();
                try {
                    JSONObject json = new JSONObject();

                    json.put(FuguAppConstant.VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.USER_BUSY.toString());
                    json.put(FuguAppConstant.IS_SILENT, true);
                    json.put(FuguAppConstant.USER_ID, userId);
                    json.put(FuguAppConstant.FULL_NAME, fullname);
                    json.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL);
                    json.put(FuguAppConstant.IS_TYPING, TYPING_SHOW_MESSAGE);
                    json.put(FuguAppConstant.MESSAGE_UNIQUE_ID, messageUniqueId);

                    JSONObject devicePayload = new JSONObject();
                    devicePayload.put(FuguAppConstant.DEVICE_ID, CommonData.getUniqueIMEIId(context));
                    devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
                    devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME);
                    devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context));
                    json.put("device_payload", devicePayload);

                    ConnectionManager.INSTANCE.publish("/" + channelId, json, true);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            } else {
                sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, userId);
            }
        }
    }

    protected boolean isCallActive(Context context) {
        AudioManager manager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        return manager.getMode() == AudioManager.MODE_IN_CALL;
    }

    public void oldSDKCall(String message, String channel) {
        Message turnCredentials = new AppContants().getTurnCredentials();
        Integer userId = HippoApplication.getInstance().getUserData().getUserId();

        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");

        String callType = jsonObject.optString("call_type", "");
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();

        String userImage = !TextUtils.isEmpty(jsonObject.optString("user_image"))
                ? jsonObject.optString("user_image")
                : !TextUtils.isEmpty(jsonObject.optString("thumbnail_url"))
                ? jsonObject.optString("thumbnail_url")
                : jsonObject.optString("image_url", "");

        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        VideoCallModel videoCallModel = new VideoCallModel(channelId,
                userImage,
                fullname,
                userId,
                -1,
                fullname,
                turnCredentials.getTurnApiKey(),
                turnCredentials.getUsername(),
                turnCredentials.getCredentials(),
                (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                activityLaunchState,
                messageUniqueId,
                callType.toUpperCase(), "", "", "", "", "");

        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
        videoIntent.putExtra("videoCallModel", videoCallModel);

        callRecieved(context, message, videoIntent, jsonObject, videoCallModel, Long.valueOf(userId));
    }

    private void callRecieved(Context context, String messageJson, Intent videoIntent, JSONObject notificationJson,
                              VideoCallModel videoCallModel, Long myUserId) {
        try {
            JSONObject json = new JSONObject(messageJson);
            if (json.has(MESSAGE_TYPE) && json.getInt(MESSAGE_TYPE) == 18 &&
                    json.getString("muid").equals(notificationJson.getString("muid"))) {
                Log.e("VIDEO_JSON", json.toString());

                if (json.getString(VIDEO_CALL_TYPE).equals("START_CALL")) {
                    JSONObject readyToConnectJson = new JSONObject();
                    readyToConnectJson.put(VIDEO_CALL_TYPE, "READY_TO_CONNECT");
                    readyToConnectJson.put(IS_SILENT, true);
                    readyToConnectJson.put("user_id", myUserId);
                    readyToConnectJson.put(MESSAGE_TYPE, VIDEO_CALL);
                    readyToConnectJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
                    readyToConnectJson.put("muid", notificationJson.getString("muid"));
                    addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel,
                            notificationJson.getString("channel_id"), videoCallModel.getCallType());
                } else if (json.getString(VIDEO_CALL_TYPE).equals("VIDEO_OFFER")) {
                    /*if (!isCallActive(context)) {
                        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
                        countDown.cancel();
                        if (!taskList.get(0).topActivity.getClassName().equals("com.hippoagent.hippocall.FuguCallActivity")
                                && !isMyServiceRunning(context, VideoCallService.class)
                                && !taskList.get(0).topActivity.getClassName().contains("GrantPermissionsActivity")) {
                            videoIntent.putExtra("video_offer", messageJson);
                            context.startActivity(videoIntent);
                        }
                    }*/

                    if (!isCallActive(context)) {
                        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
                        countDown.cancel();
                        if (!taskList.get(0).topActivity.getClassName().equals("com.hippocall.FuguCallActivity")
                                && !isMyServiceRunning(context, VideoCallService.class)
                                && !taskList.get(0).topActivity.getClassName().contains("GrantPermissionsActivity")) {
                            videoIntent.putExtra("video_offer", messageJson);
                            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.P) {
                                startCallForegroundService(context, INCOMING_CALL, videoCallModel, messageJson);
                            } else {
                                context.startActivity(videoIntent);
                            }
                        }
                    } else {
                        JSONObject readyToConnectJson = new JSONObject();
                        readyToConnectJson.put(VIDEO_CALL_TYPE, "USER_BUSY");
                        readyToConnectJson.put(IS_SILENT, true);
                        readyToConnectJson.put("user_id", myUserId);
                        readyToConnectJson.put(MESSAGE_TYPE, VIDEO_CALL);
                        readyToConnectJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
                        readyToConnectJson.put("muid", notificationJson.getString("muid"));
                        addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel,
                                notificationJson.getString("channel_id"), videoCallModel.getCallType());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTurnCredentialsAndDeviceDetails(Context context, JSONObject readyToConnectJson,
                                                    VideoCallModel videoCallModel, String channelId, String callType) {
        try {
            JSONArray stunServers = new JSONArray();
            JSONArray turnServers = new JSONArray();
            JSONObject videoCallCredentials = new JSONObject();

            videoCallCredentials.put("turnApiKey", videoCallModel.getTurnApiKey());
            videoCallCredentials.put("username", videoCallModel.getTurnUserName());
            videoCallCredentials.put("credential", videoCallModel.getTurnCredential());
            for (int i = 0; i < videoCallModel.getStunServers().size(); i++) {
                stunServers.put(videoCallModel.getStunServers().get(i));
            }
            for (int i = 0; i < videoCallModel.getTurnServers().size(); i++) {
                turnServers.put(videoCallModel.getTurnServers().get(i));
            }


            JSONObject devicePayload = new JSONObject();
            devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
            devicePayload.put(FuguAppConstant.APP_VERSION, "2.0.5");
            devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context));

            videoCallCredentials.put("stun", stunServers);
            videoCallCredentials.put("turn", turnServers);
            readyToConnectJson.put("turn_creds", videoCallCredentials);
            readyToConnectJson.put("device_payload", devicePayload);

            readyToConnectJson.put("call_type", callType);

            publishSignalToFaye(channelId, readyToConnectJson);
        } catch (Exception e) {

        }
    }

    private void publishSignalToFaye(String channelId, JSONObject signalJson) {
        ConnectionManager.INSTANCE.publish("/" + channelId, signalJson, true);
    }


    private Fragment fragment;

    protected Fragment getFragment() {
        return fragment;
    }


    private boolean isMyServiceRunning(Context context, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }


    // for jitsi call

    private void sendBusyStatus(JSONObject jsonObject) {
        try {
            Integer userId = HippoApplication.getInstance().getUserData().getUserId();
            JSONObject startCallJson = new JSONObject();
            startCallJson.put(IS_SILENT, false);
            startCallJson.put(VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put(USER_ID, userId);
            startCallJson.put(CHANNEL_ID, jsonObject.optString(CHANNEL_ID));
            startCallJson.put(MESSAGE_TYPE, VIDEO_CALL);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), "VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), getDeviceDetails(context));
            startCallJson.put(INVITE_LINK, jsonObject.optString(INVITE_LINK));
            startCallJson.put(MESSAGE_UNIQUE_ID, jsonObject.optString(MESSAGE_UNIQUE_ID));

            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), jsonObject.optString("full_name", ""));
            startCallJson.put("message", "");
            startCallJson.put("is_typing", TYPING_SHOW_MESSAGE);
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER);

            //String channelId = "/"+jsonObject.optLong(CHANNEL_ID);
            sendMessage(jsonObject.optLong(CHANNEL_ID), startCallJson);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    boolean emitUserBusy;

    private void onStartConferenceCall(Context context, JSONObject jsonObject) throws Exception {
        this.context = context;
        this.jsonObject = jsonObject;

        if (jsonObject.has(VIDEO_CALL_TYPE)) {
            if (jsonObject.getString(VIDEO_CALL_TYPE).equals(FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
                    emitUserBusy = true;
                    sendBusyStatus(jsonObject); // close connection is app killed
                } else {
                    Long channelId = jsonObject.optLong("channel_id");
                    ConnectionManager.INSTANCE.initFayeConnection();
                    ConnectionManager.INSTANCE.subScribeChannel("/" + HippoApplication.getInstance().getUserData().getUserChannel());
                    ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
                    ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
//
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra(MESSAGE_UNIQUE_ID, jsonObject.getString(MESSAGE_UNIQUE_ID));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);

                    Intent mIntent2 = new Intent(VIDEO_CONFERENCE_HUNGUP_INTENT);
                    mIntent2.putExtra(INVITE_LINK, jsonObject.getString(INVITE_LINK));
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent2);
                } else {
                    Intent mIntent2 = new Intent(VIDEO_CONFERENCE_HUNGUP_INTENT);
                    mIntent2.putExtra(INVITE_LINK, jsonObject.getString(INVITE_LINK));
                    mIntent2.putExtra(JITSI_URL, jsonObject.optString(JITSI_URL));
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent2);

                    if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                        ConnectionManager.INSTANCE.onClose();
                    }
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra(MESSAGE_UNIQUE_ID, jsonObject.getString(MESSAGE_UNIQUE_ID));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);

                    Intent mIntent2 = new Intent(VIDEO_CONFERENCE_HUNGUP_INTENT);
                    mIntent2.putExtra(INVITE_LINK, jsonObject.getString(INVITE_LINK));
                    mIntent2.putExtra(JITSI_URL, jsonObject.optString(JITSI_URL));
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent2);
                } else {
                    if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                        ConnectionManager.INSTANCE.onClose();
                    }
                }
            }
        }
    }

    public JSONObject getDeviceDetails(Context context) {
        try {
            JSONObject devicePayload = new JSONObject();
            devicePayload.put(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put(DEVICE_TYPE, ANDROID_USER);
            devicePayload.put(APP_VERSION, BuildConfig.VERSION_NAME);
            devicePayload.put(DEVICE_DETAILS, CommonData.deviceDetails(context));
            return devicePayload;
        } catch (Exception e) {
            return new JSONObject();
        }
    }

    protected void initOldCall(VideoCallModel videoCallModel) {
        try {
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            if (!isMyServiceRunning(context, VideoCallService.class)) {
                videoIntent.putExtra("videoCallModel", videoCallModel);
            }
            context.startActivity(videoIntent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallForegroundService(Context context, String status, VideoCallModel videoCallModel, String messageJson) {
        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
        String channelName = "";
        channelName = videoCallModel.getChannelName();
        startIntent.setAction("com.fuguchat.start");
        startIntent.putExtra(CALL_STATUS, status);
        startIntent.putExtra(CHANNEL_NAME, channelName);
        startIntent.putExtra(VIDEO_CALL_MODEL, videoCallModel);
        startIntent.putExtra(INIT_FULL_SCREEN_SERVICE, true);
        startIntent.putExtra("messageJson", messageJson);
        new Thread(new Runnable() {
            @Override
            public void run() {
                CommonData.setVideoCallModel(videoCallModel);
            }
        }).start();
        try {
            ContextCompat.startForegroundService(context, startIntent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getServerUrl() {
        URL serverURL;
        if (!TextUtils.isEmpty(getJitsiURL())) {
            try {
                serverURL = new URL(getJitsiURL());
                return serverURL;
            } catch (Exception e) {

            }
        }
        try {
            serverURL = new URL(FuguAppConstant.CONFERENCING_LIVE);
        } catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }

    /*private URL getServerUrl() {
        URL serverURL;
        try {
            serverURL = new URL(FuguAppConstant.CONFERENCING_LIVE);
        } catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }*/

    public void joinSession(Context context, String roomName, String title,
                            int callType, String transactionId, int isAudioEnable) {
        URL serverURL = getServerUrl();
        JitsiMeetUserInfo userInfo = new JitsiMeetUserInfo();
        try {
            userInfo.setDisplayName(title);
//                if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
//                userInfo.avatar = URL(videoCallModel?.myImagePath)
        } catch (Exception e) {
            userInfo.setDisplayName("Fellow User");
        }

        if (HippoApplication.getInstance().getUserData().getBusinessProperty().getCallingType().equalsIgnoreCase("3")) {
            String type="VIDEO";

            if (callType==2){
                type="AUDIO";
            }

           VideoCallModel model=new VideoCallModel(0,"","",0,0,title,"","",""
           ,new ArrayList<>(),new ArrayList<>(),"","",type,transactionId,transactionId,roomName,"","");

//            VideoCallModel model = new VideoCallModel(0, "", "", 0, 0, title,
//                    "", "", "", new ArrayList<>(), new ArrayList<>(), "", ""
//                    , callType, transactionId, transactionId, "", "", ""
//                    , true, false, false, transactionId);

            ShowDialg.INSTANCE.hideDialog();

            Intent videoIntent =
                    new Intent(context, VideoSdkMeetingActivity.class);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            videoIntent.putExtra("videoCallModel", model);
            videoIntent.putExtra("token", "");
            videoIntent.putExtra("meetingId", transactionId);

            context.startActivity(videoIntent);

        } else {

            try {
                if (callType == 2) {
                    JitsiMeetConferenceOptions defaultOptions = new JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
//                            .setWelcomePageEnabled(false)
                            .setAudioOnly(true)
                            .setAudioMuted(isAudioEnable == 0)
                            .setFeatureFlag("call-integration.enabled", false)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setFeatureFlag("kick-out.enabled", false)
                            .setFeatureFlag("live-streaming.enabled", false)
                            .setFeatureFlag("add-people.enabled", false)
                            .setFeatureFlag("notifications.enabled", false)
                            .setFeatureFlag("raise-hand.enabled", false)
                            .setFeatureFlag("recording.enabled", false)
                            .setFeatureFlag("video-share.enabled", false)
                            .setFeatureFlag("welcomepage.enabled", false)
                            .setFeatureFlag("close-captions.enabled", false)
                            .setFeatureFlag("meeting-name.enabled", false)
                            .setFeatureFlag("meeting-password.enabled", false)
                            .setUserInfo(userInfo)
                            .build();
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions);
                } else {
                    JitsiMeetConferenceOptions defaultOptions = new JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
//                            .setWelcomePageEnabled(false)
                            .setAudioOnly(false)
                            .setAudioMuted(isAudioEnable == 0)
                            .setFeatureFlag("call-integration.enabled", false)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setFeatureFlag("kick-out.enabled", false)
                            .setFeatureFlag("live-streaming.enabled", false)
                            .setFeatureFlag("add-people.enabled", false)
                            .setFeatureFlag("notifications.enabled", false)
                            .setFeatureFlag("raise-hand.enabled", false)
                            .setFeatureFlag("recording.enabled", false)
                            .setFeatureFlag("video-share.enabled", false)
                            .setFeatureFlag("welcomepage.enabled", false)
                            .setFeatureFlag("close-captions.enabled", false)
                            .setFeatureFlag("meeting-name.enabled", false)
                            .setFeatureFlag("meeting-password.enabled", false)
                            .setUserInfo(userInfo)
                            .build();
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions);
                }
            } catch (Exception e) {
                JitsiMeetConferenceOptions defaultOptions = new JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
//                        .setWelcomePageEnabled(false)
                        .setAudioOnly(false)
                        .setAudioMuted(isAudioEnable == 0)
                        .setFeatureFlag("call-integration.enabled", false)
                        .setFeatureFlag("chat.enabled", false)
                        .setFeatureFlag("invite.enabled", false)
                        .setFeatureFlag("kick-out.enabled", false)
                        .setFeatureFlag("live-streaming.enabled", false)
                        .setFeatureFlag("add-people.enabled", false)
                        .setFeatureFlag("notifications.enabled", false)
                        .setFeatureFlag("raise-hand.enabled", false)
                        .setFeatureFlag("recording.enabled", false)
                        .setFeatureFlag("video-share.enabled", false)
                        .setFeatureFlag("welcomepage.enabled", false)
                        .setFeatureFlag("close-captions.enabled", false)
                        .setFeatureFlag("meeting-name.enabled", false)
                        .setFeatureFlag("meeting-password.enabled", false)
                        .setUserInfo(userInfo)
                        .build();
                JitsiMeet.setDefaultConferenceOptions(defaultOptions);
            }

            JitsiMeetConferenceOptions options = new JitsiMeetConferenceOptions.Builder()
                    .setRoom(roomName)
                    .build();

            OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
            OngoingCallService.NotificationServiceState.INSTANCE.setTransactionId(transactionId);

            startOngoingCallService(context, transactionId);
            JitsiMeetActivity.launch(context, options);
//        JitsiMeetActivity.launch(context, options);

            ShowDialg.INSTANCE.hideDialog();
        }
    }

    private void startOngoingCallService(Context context, String transactionId) {
        GroupCallData groupCallData = com.hippoagent.database.CommonData.getGroupData(transactionId);
        Intent startIntent = new Intent(context, OngoingCallService.class);
        startIntent.setAction("com.hippochat.notification.start");
        startIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, groupCallData.getMuid());
        startIntent.putExtra(FuguAppConstant.CHANNEL_ID, groupCallData.getChannelId());
        ContextCompat.startForegroundService(context, startIntent);
    }

    public static void startOngoingCallService(Context context, String transactionId, String unique_id, String channel_id) {
        Intent startIntent = new Intent(context, OngoingCallService.class);
        startIntent.setAction("com.hippochat.notification.start");
        startIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, unique_id);
        startIntent.putExtra(FuguAppConstant.CHANNEL_ID, channel_id);
        ContextCompat.startForegroundService(context, startIntent);
    }


    public void startOngoingService(Context context, String inviteLink, String signalUniqueId, Long channelId, String jitsiLink) {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                Intent startIntent = new Intent(getContext(), OngoingCallService.class);
                startIntent.setAction("com.hippochat.notification.start");
                startIntent.putExtra(FuguAppConstant.INVITE_LINK, inviteLink);
                startIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, signalUniqueId);
                startIntent.putExtra(FuguAppConstant.CHANNEL_ID, channelId);
                startIntent.putExtra(FuguAppConstant.JITSI_URL, jitsiLink);
                ContextCompat.startForegroundService(getContext(), startIntent);
            }
        }, 500);

    }

    private volatile boolean isAppVisible;

    public void setAppStatus(boolean b) {
        isAppVisible = b;
    }

    public boolean isAppVisible() {
        return isAppVisible;
    }

    public void saveData(String key, String value) {
        authObj.put(key, value);
    }

    public String getAuthObj(String key) {
        return authObj.get(key);
    }


}
