package com.hippoagent.hippocall

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.WindowManager
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.hippoagent.BuildConfig
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.R
import com.hippoagent.activities.VideoSdkMeetingActivity
import com.hippoagent.confcall.*
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.helper.BusEvents
import com.hippoagent.helper.ConnectionManager
import com.hippoagent.helper.FayeMessage
import com.hippoagent.hippocall.model.FragmentFlow
import com.hippoagent.langs.Restring
import com.hippoagent.model.shareurl.ShareUrlModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParamsObj
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants.ACCESS_TOKEN
import com.hippoagent.utils.Log
import com.hippoagent.utils.UniqueIMEIID
import com.hippoagent.utils.Utils
import com.squareup.otto.Subscribe
import org.jitsi.meet.sdk.JitsiMeet
import org.jitsi.meet.sdk.JitsiMeetActivity
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions
import org.jitsi.meet.sdk.JitsiMeetUserInfo
import org.json.JSONObject
import java.net.MalformedURLException
import java.net.URL
import java.util.*

/**
 * Created by gurmail on 2020-04-09.
 * @author gurmail
 */
class MainCallingActivity : AppCompatActivity() {

    private var videoCallModel: VideoCallModel? = null
    private var needToStartCall: Boolean = false
    private var initOldCall = false
    private var isShareclick = false
    private var meetingId: String? = ""
    private var token: String? = ""
    private val mLinkShare = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            if (intent?.action.equals("URL SHARED", true) && !isShareclick) {
                isShareclick = true
                intent?.getStringExtra("roomUrl")?.let { createUrl(it) };
            }

        }
    }

    private fun createUrl(url: String) {
        if (HippoApplication.getInstance().getUserData().getBusinessProperty()
                .getIsCallInviteEnabled() == 1
        ) {
            val params = CommonParamsObj.Builder()
                .add(ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add("en_creator_id", HippoApplication.getInstance().userData.enUserId)
                .add("creator_id", HippoApplication.getInstance().userData.userId)
                .add("meet_url", url)
                .build()
            RestClient.getApiInterface().createInviteLink(params.map)
                .enqueue(object : ResponseResolver<ShareUrlModel>() {
                    override fun success(shareUrlModel: ShareUrlModel) {
                        isShareclick = false
                        Utils.shareCallUrl(shareUrlModel.data.meetUrl, this@MainCallingActivity)
                    }

                    override fun failure(error: APIError) {
                        isShareclick = false
                    }
                })
        }
    }


    private fun registerBroadcast() {
        LocalBroadcastManager.getInstance(this)
            .registerReceiver(mLinkShare, IntentFilter("URL SHARED"))
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.hippo_activity_maincalling)
        val win = window
        win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD)
        win.addFlags(WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON)
        initOldCall = false

        if (intent.hasExtra("videoCallModel")) {
            videoCallModel = intent.extras?.getParcelable("videoCallModel")
            //prestartOngoingCallService()
            if (intent.hasExtra("answer_call")) {
                needToStartCall = false

            } else if (intent.hasExtra("incomming_call")) {
                // check the link if empty don't do anything
                needToStartCall = false
            } else {
                needToStartCall = true
                val linkArray = randomVideoConferenceLink()
                var inviteLink = linkArray[0] + "/" + linkArray[1]
                var jistsiLink = HippoCallConfig.getInstance().jitsiURL + "/" + linkArray[1]
                if (videoCallModel?.callType!! == "AUDIO") {
                    inviteLink += "#config.startWithVideoMuted=true"
                }
                if (videoCallModel?.callType!! == "AUDIO") {
                    jistsiLink += "#config.startWithVideoMuted=true"
                }

                if (HippoApplication.getInstance().userData.businessProperty.callingType.equals(
                        "3",
                        ignoreCase = true
                    )
                ) {
                    meetingId = videoCallModel?.jitsiLink
                    videoCallModel?.jitsiLink = meetingId!!
                    videoCallModel?.inviteLink = meetingId

                } else {
                    videoCallModel?.jitsiLink = jistsiLink
                    videoCallModel?.inviteLink = inviteLink
                }


            }
        }

        ConnectionManager.initFayeConnection()
        ConnectionManager.subScribeChannel("/${videoCallModel?.channelId!!}")
        registerBroadcast()
        if (intent.hasExtra("incomming_call")) {
            openIncommingCallFragment()
            startMedia()
//            val serverURL: URL = getServerUrl(videoCallModel?.jitsiLink)
//            preInitCall(serverURL)
        } else if (intent.hasExtra("answer_call")) {
            onVideoConfActivityCreate(false)
        } else {
            openJitsiFragment()
            if (ConnectionManager.isConnected()) {
                Handler().postDelayed({
                    onStartCall()
                }, 200)
            }
        }
    }

    private fun onStartCall() {
        if (needToStartCall) {
            Handler().postDelayed({
                BusProvider.getInstance().post(
                    FragmentFlow(
                        WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString(),
                        1, JSONObject(), ""
                    )
                )
                needToStartCall = false
            }, 500)
        }
    }

    override fun onResume() {
        super.onResume()
        registerBroadcast()
    }

    override fun onPause() {
        super.onPause()

    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this)
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this)
    }

    override fun onBackPressed() {

    }

    override fun onDestroy() {
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
        super.onDestroy()

    }


    private fun openJitsiFragment() {
        var fragment = JitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle
        bundle.putString("token", token)
        bundle.putString("meetingId", meetingId)


        supportFragmentManager.beginTransaction()
            .add(R.id.main_layout, fragment, JitsiCallActivity::class.java.simpleName)
            .addToBackStack(JitsiCallActivity::class.java.simpleName)
            .commitAllowingStateLoss()
    }

    private fun openIncommingCallFragment() {
        var fragment = IncomingJitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
            .add(R.id.main_layout, fragment, IncomingJitsiCallActivity::class.java.simpleName)
            .addToBackStack(IncomingJitsiCallActivity::class.java.simpleName)
            .commitAllowingStateLoss()
    }

    public fun sendMessage(channelId: Long, jsonObject: JSONObject) {
        ConnectionManager.publish("/$channelId", jsonObject, false)
    }

    @Subscribe
    public fun onBusFragmentType(data: FragmentFlow) {
        when (data.fragmentType) {
            WebRTCCallConstants.BusFragmentType.INCOMMING_JITSI_CALL.toString() -> {
                incomingBusOpration(data.type)
            }
            WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString() -> {
                jitsiActivityOperation(data)
            }
            WebRTCCallConstants.BusFragmentType.INCOMING_VIDEO_CONF.toString() -> {

            }

        }
    }


    @Subscribe
    public fun onFayeMessageEvent(event: FayeMessage) {
        Log.d("onFayeMessageEvent", "onFayeMessageEvent -> " + event.type);
        when (event.type) {
            BusEvents.ERROR_RECEIVED.toString() -> {
                try {
                    if (!initOldCall) {
                        initOldCall = true
                        val fragment =
                            supportFragmentManager.findFragmentByTag(JitsiCallActivity::class.java.simpleName) as JitsiCallActivity
                        fragment.onErrorRecieved(event.message)
                    }
                } catch (e: Exception) {
                }
            }
            WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString() -> {
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                finish()
            }
        }
    }


    private fun randomVideoConferenceLink(): ArrayList<String> {
        val linkArray = ArrayList<String>()
        val ALLOWED_CHARACTERS = "qwertyuiopasdfghjklzxcvbnm"
        val random = Random()
        val sb = StringBuilder(10)
        for (i in 0 until 10)
            sb.append(ALLOWED_CHARACTERS[random.nextInt(ALLOWED_CHARACTERS.length)])
        linkArray.add(FuguAppConstant.CONFERENCING_LIVE)
        linkArray.add(sb.toString())
        videoCallModel?.roomName = sb.toString()

        return linkArray
    }


    //==============================================================================================
    // for IncomingJitsiCallActivity
    //==============================================================================================


    private fun incomingBusOpration(type: Int) {
        when (type) {
            WebRTCCallConstants.IncommintJitsiCall.START_MEDIA -> startMedia()
            WebRTCCallConstants.IncommintJitsiCall.UNREGISTER_BROADCAST -> {
                //mediaPlayer?.stop()
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                try {
                    LocalBroadcastManager.getInstance(this)
                        .unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.REGISTER_BROADCAST -> {
                try {
                    LocalBroadcastManager.getInstance(this)
                        .unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                LocalBroadcastManager.getInstance(this).registerReceiver(
                    mVideoConferenceHungup,
                    IntentFilter(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                )
            }
            WebRTCCallConstants.IncommintJitsiCall.STOP -> {
                try {
                    LocalBroadcastManager.getInstance(this)
                        .unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.ANSWERCALL -> {
                onVideoConfActivityCreate(false)
            }
            WebRTCCallConstants.IncommintJitsiCall.REJECTCALL -> {

                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)

                val hungupIntent = Intent(this@MainCallingActivity, HungUpBroadcast::class.java)
                hungupIntent.putExtra("action", "rejectCall")
                hungupIntent.putExtra(
                    WebRTCCallConstants.DEVICE_PAYLOAD,
                    getDeviceDetails().toString()
                )
                hungupIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
                hungupIntent.putExtra(FuguAppConstant.JITSI_URL, videoCallModel?.jitsiLink)
                hungupIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
                hungupIntent.putExtra("auth0", OngoingCallService.NotificationServiceState.authObj)
                hungupIntent.putExtra("muid", OngoingCallService.NotificationServiceState.muid)

                sendBroadcast(hungupIntent)
                finish()
            }
        }
    }

    private fun startMedia() {
        HippoAudioManager.getInstance(this@MainCallingActivity).startIncomingRinger()
    }

    private val mVideoConferenceHungup = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            //mediaPlayer?.stop()
            HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
            finish()
        }
    }

    private fun getDeviceDetails(): JSONObject {
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        return devicePayload
    }

    // Ending IncommingJitsi Call data
    //==============================================================================================

    //for VideoConfActivity here

    //==============================================================================================


    private fun jitsiActivityOperation(data: FragmentFlow) {
        when (data.type) {
            WebRTCCallConstants.JitsiCallActivity.POST_DATA -> {
                //Log.d("POST_DATA", "POST_DATA = "+ Gson().toJson(data))
                sendMessage(videoCallModel?.channelId!!, data?.json!!)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_VIDEO_CONF -> {
                onVideoConfActivityCreate(true)
            }
            WebRTCCallConstants.JitsiCallActivity.PRE_LOAD_DATA -> {
//                val serverURL: URL = getServerUrl(videoCallModel?.jitsiLink)
//                preInitCall(serverURL)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_OLD_CALL -> {
                Toast.makeText(this@MainCallingActivity, "Update your app", Toast.LENGTH_LONG)
                    .show()
                HippoCallConfig.getInstance().initOldCall(videoCallModel)
                finish()
            }
        }
    }

    private fun onVideoConfActivityCreate(hasAnswer: Boolean) {

        stopForegroundService()
        //HippoAudioManager.getInstance(this@MainCallingActivity).startCommunication(false)
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
        OngoingCallService.NotificationServiceState.isConferenceConnected = true
        if (!hasAnswer) {
            answerConference()
        }


        startOngoingCallService()
        val serverURL: URL = getServerUrl(videoCallModel?.jitsiLink)
        if (!TextUtils.isEmpty(videoCallModel?.jitsiLink)) {
            options = null
        }
        initCall(serverURL)

        finish()
    }

    private fun stopForegroundService() {
        try {
            val startIntent = Intent(this@MainCallingActivity, VideoCallService::class.java)
            startIntent.action = "com.hippochat.start"
            startIntent.putExtra("isHungUpToBeSent", false)
            stopService(startIntent)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun startOngoingCallService() {
        HippoCallConfig.getInstance().startOngoingService(
            this@MainCallingActivity, videoCallModel?.inviteLink, videoCallModel?.signalUniqueId,
            videoCallModel?.channelId, videoCallModel?.jitsiLink
        )
    }

    private fun answerConference() {
        val userId = HippoApplication.getInstance().userData.userId
        val fullName = HippoApplication.getInstance().userData.fullName
        val startCallJson = JSONObject()
        startCallJson.put(FuguAppConstant.IS_SILENT, true)
        startCallJson.put(
            WebRTCCallConstants.VIDEO_CALL_TYPE,
            WebRTCCallConstants.JitsiCallType.ANSWER_CONFERENCE.toString()
        )
        startCallJson.put(FuguAppConstant.USER_ID, userId)
        startCallJson.put(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
        startCallJson.put(FuguAppConstant.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
        startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
        startCallJson.put(
            FuguAppConstant.MESSAGE_UNIQUE_ID,
            OngoingCallService.NotificationServiceState.muid
        )
        startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails())
        startCallJson.put(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
        startCallJson.put(FuguAppConstant.JITSI_URL, videoCallModel?.jitsiLink)
        //ConnectionManager.sendMessage(intent?.getLongExtra(CHANNEL_ID, -1L)!!, startCallJson)
        startCallJson.put("message", "")
        startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
        startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
        startCallJson.put("full_name", videoCallModel?.fullName)
        val authObj = HippoCallConfig.getInstance()
            .getAuthObj(OngoingCallService.NotificationServiceState.muid)
        if (!TextUtils.isEmpty(authObj))
            startCallJson.put("auth0", authObj)


        sendMessage(videoCallModel?.channelId!!, startCallJson)

    }

    private fun getServerUrl(link: String?): URL {
        var serverURL: URL
        if (!TextUtils.isEmpty(link) && !TextUtils.isEmpty(
                HippoCallConfig.getInstance().getJitsiURL()
            )
        ) {
            try {
                serverURL = URL(HippoCallConfig.getInstance().getJitsiURL())
                return serverURL
            } catch (e: java.lang.Exception) {
            }
        }
        try {
            serverURL = URL(FuguAppConstant.CONFERENCING_LIVE)
        } catch (e: MalformedURLException) {
            e.printStackTrace()
            throw RuntimeException("Invalid server URL!")
        }
        return serverURL
        /*var serverURL: URL
        try {
            serverURL = URL(FuguAppConstant.CONFERENCING_LIVE)
        } catch (e: MalformedURLException) {
            e.printStackTrace()
            throw RuntimeException("Invalid server URL!")
        }
        return serverURL*/
    }

    private fun initCall(serverURL: URL) {

        if (HippoApplication.getInstance().userData.businessProperty.callingType.equals(
                "3",
                ignoreCase = true
            )
        ) {

            val videoIntent =
                Intent(this, VideoSdkMeetingActivity::class.java)
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
            videoIntent.putExtra("videoCallModel", videoCallModel)
            videoIntent.putExtra("token", token)
            videoIntent.putExtra("meetingId", videoCallModel?.jitsiLink)

            startActivity(videoIntent)

        } else {

            if (options == null) {
                val userInfo = JitsiMeetUserInfo()
                try {
                    userInfo.displayName = videoCallModel?.myname
                    if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
                        userInfo.avatar = URL(videoCallModel?.myImagePath)
                } catch (e: Exception) {
                    userInfo.displayName = "Fellow User"
                }
                var roomName = videoCallModel?.roomName

                try {
                    if ((videoCallModel?.callType == "AUDIO")
                        || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true"))
                        || roomName?.contains("#config.startWithVideoMuted=true")!!
                    ) {
                        val defaultOptions = JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
                            //.setWelcomePageEnabled(false)
                            .setAudioOnly(true)
                            .setFeatureFlag("call-integration.enabled", false)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setFeatureFlag("kick-out.enabled", false)
                            .setFeatureFlag("live-streaming.enabled", false)
                            .setFeatureFlag("add-people.enabled", false)
                            .setFeatureFlag("notifications.enabled", false)
                            .setFeatureFlag("raise-hand.enabled", false)
                            .setFeatureFlag("recording.enabled", false)
                            .setFeatureFlag("video-share.enabled", false)
                            .setFeatureFlag("welcomepage.enabled", false)
                            .setFeatureFlag("close-captions.enabled", false)
                            .setFeatureFlag("meeting-name.enabled", false)
                            .setFeatureFlag("meeting-password.enabled", false)
                            .setUserInfo(userInfo)
                            .build()
                        JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                    } else {
                        val defaultOptions = JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
                            //.setWelcomePageEnabled(false)
                            .setAudioOnly(false)
                            .setFeatureFlag("call-integration.enabled", false)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setFeatureFlag("kick-out.enabled", false)
                            .setFeatureFlag("live-streaming.enabled", false)
                            .setFeatureFlag("add-people.enabled", false)
                            .setFeatureFlag("notifications.enabled", false)
                            .setFeatureFlag("raise-hand.enabled", false)
                            .setFeatureFlag("recording.enabled", false)
                            .setFeatureFlag("video-share.enabled", false)
                            .setFeatureFlag("welcomepage.enabled", false)
                            .setFeatureFlag("close-captions.enabled", false)
                            .setFeatureFlag("meeting-name.enabled", false)
                            .setFeatureFlag("meeting-password.enabled", false)
                            .setUserInfo(userInfo)
                            .build()
                        JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                    }
                } catch (e: Exception) {
                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        //.setWelcomePageEnabled(false)
                        .setAudioOnly(false)
                        .setFeatureFlag("call-integration.enabled", false)
                        .setFeatureFlag("chat.enabled", false)
                        .setFeatureFlag("invite.enabled", false)
                        .setFeatureFlag("kick-out.enabled", false)
                        .setFeatureFlag("live-streaming.enabled", false)
                        .setFeatureFlag("add-people.enabled", false)
                        .setFeatureFlag("notifications.enabled", false)
                        .setFeatureFlag("raise-hand.enabled", false)
                        .setFeatureFlag("recording.enabled", false)
                        .setFeatureFlag("video-share.enabled", false)
                        .setFeatureFlag("welcomepage.enabled", false)
                        .setFeatureFlag("close-captions.enabled", false)
                        .setFeatureFlag("meeting-name.enabled", false)
                        .setFeatureFlag("meeting-password.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                }
                roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
                options = JitsiMeetConferenceOptions.Builder()
                    .setRoom(roomName)
                    .build()
            }
            OngoingCallService.NotificationServiceState.isConferenceConnected = true
            JitsiMeetActivity.launch(
                this,
                options
            )
//        JitsiMeetActivity.launch(this, options)
        }
    }

    var options: JitsiMeetConferenceOptions? = null
    private fun preInitCall(serverURL: URL) {
        val userInfo = JitsiMeetUserInfo()
        try {
            userInfo.displayName = videoCallModel?.myname
            if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
                userInfo.avatar = URL(videoCallModel?.myImagePath)
        } catch (e: Exception) {
            userInfo.displayName = "Fellow User"
        }


        //todo check this room thing right now
        var roomName = videoCallModel?.roomName
        /*if (!TextUtils.isEmpty(intent.getStringExtra("room_name"))) {
            roomName = intent.getStringExtra("room_name")
        } else {
            roomName = intent?.data?.lastPathSegment!!

        }*/

        try {
            if ((videoCallModel?.callType == "AUDIO") || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true")) || roomName?.contains(
                    "#config.startWithVideoMuted=true"
                )!!
            ) {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    //.setWelcomePageEnabled(false)
                    .setAudioOnly(true)
                    .setFeatureFlag("call-integration.enabled", false)
                    .setFeatureFlag("chat.enabled", false)
                    .setFeatureFlag("invite.enabled", false)
                    .setFeatureFlag("kick-out.enabled", false)
                    .setFeatureFlag("live-streaming.enabled", false)
                    .setFeatureFlag("add-people.enabled", false)
                    .setFeatureFlag("notifications.enabled", false)
                    .setFeatureFlag("raise-hand.enabled", false)
                    .setFeatureFlag("recording.enabled", false)
                    .setFeatureFlag("video-share.enabled", false)
                    .setFeatureFlag("welcomepage.enabled", false)
                    .setFeatureFlag("close-captions.enabled", false)
                    .setFeatureFlag("meeting-name.enabled", false)
                    .setFeatureFlag("meeting-password.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            } else {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    //.setWelcomePageEnabled(false)
                    .setAudioOnly(false)
                    .setFeatureFlag("call-integration.enabled", false)
                    .setFeatureFlag("chat.enabled", false)
                    .setFeatureFlag("invite.enabled", false)
                    .setFeatureFlag("kick-out.enabled", false)
                    .setFeatureFlag("live-streaming.enabled", false)
                    .setFeatureFlag("add-people.enabled", false)
                    .setFeatureFlag("notifications.enabled", false)
                    .setFeatureFlag("raise-hand.enabled", false)
                    .setFeatureFlag("recording.enabled", false)
                    .setFeatureFlag("video-share.enabled", false)
                    .setFeatureFlag("welcomepage.enabled", false)
                    .setFeatureFlag("close-captions.enabled", false)
                    .setFeatureFlag("meeting-name.enabled", false)
                    .setFeatureFlag("meeting-password.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            }
        } catch (e: Exception) {
            val defaultOptions = JitsiMeetConferenceOptions.Builder()
                .setServerURL(serverURL)
                //.setWelcomePageEnabled(false)
                .setAudioOnly(false)
                .setFeatureFlag("call-integration.enabled", false)
                .setFeatureFlag("chat.enabled", false)
                .setFeatureFlag("invite.enabled", false)
                .setFeatureFlag("kick-out.enabled", false)
                .setFeatureFlag("live-streaming.enabled", false)
                .setFeatureFlag("add-people.enabled", false)
                .setFeatureFlag("notifications.enabled", false)
                .setFeatureFlag("raise-hand.enabled", false)
                .setFeatureFlag("recording.enabled", false)
                .setFeatureFlag("video-share.enabled", false)
                .setFeatureFlag("welcomepage.enabled", false)
                .setFeatureFlag("close-captions.enabled", false)
                .setFeatureFlag("meeting-name.enabled", false)
                .setFeatureFlag("meeting-password.enabled", false)
                .setUserInfo(userInfo)
                .build()
            JitsiMeet.setDefaultConferenceOptions(defaultOptions)
        }
        roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
        options = JitsiMeetConferenceOptions.Builder()
            .setRoom(roomName)
            .build()
    }

}