package com.hippoagent.langs

import android.widget.Toast
import com.google.gson.Gson
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.eventbus.FragmentEvent
import com.hippoagent.model.EditProfileResponse
import com.hippoagent.model.lang.LangRequest
import com.hippoagent.model.lang.MultilangualResponse
import com.hippoagent.retrofit.*
import com.hippoagent.utils.Constants
import com.hippoagent.utils.UniqueIMEIID
import com.hippoagent.utils.filelogger.Logger
import kotlinx.android.synthetic.main.fragment_web_pager.*

/**
 * Created by gurmail on 2020-06-18.
 * @author gurmail
 */
object FetchLanguageData {
    fun fetchLanguage(lang: String) {
        val params = LangRequest(HippoApplication.getInstance().userData.accessToken,
                1, lang)
        RestClient.getApiInterface().getLanguageData(params)
            .enqueue(object : ResponseResolver<MultilangualResponse>() {
                override fun success(response: MultilangualResponse?) {
                    Restring.saveStrings(response?.data)
                    CommonData.saveCurrentLang(lang)
                    updateUserLanguage(lang)
                }
                override fun failure(error: APIError?) {

                }
            })
    }


    private fun updateUserLanguage(lang: String) {
        val multipartBuilder = MultipartParams.Builder()
        val multipartParams: MultipartParams
        multipartParams = multipartBuilder
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add(Constants.EN_USER_ID, HippoApplication.getInstance().userData.enUserId)
                .add(Constants.AGENT_TYPE, HippoApplication.getInstance().userData.agentType.toString())
                .add(Constants.BUSINESS_ID, HippoApplication.getInstance().userData.businessId.toString())
                .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                .add("lang_code", lang)
                .add("device_id", UniqueIMEIID.getUniqueIMEIId(HippoConfig.getInstance().activity))
                .build()

        val value = Gson().toJson(multipartParams.map)
        Logger.apiRequest("/api/agent/editInfo", value)

        RestClient.getApiInterface().editAgentInfo(multipartParams.map)
                .enqueue(object : ResponseResolver<EditProfileResponse>() {
                    override fun success(editProfileResponse: EditProfileResponse) {

                    }
                    override fun failure(error: APIError) {

                    }

                })
    }
}