package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

/**
 * Created by cl-macmini-01 on 12/15/17.
 */

public class CustomAction  implements Parcelable {

    @SerializedName("title")
    private String title;

    @SerializedName("title_description")
    private String titleDescription;

    @SerializedName("image_url")
    private String imageUrl;

    @SerializedName("description")
    private ArrayList<DescriptionObject> descriptionObjects;

    @SerializedName("action_buttons")
    private ArrayList<ActionButtonModel> actionButtons;
    @SerializedName("items")
    @Expose
    private ArrayList<HippoPayment> hippoPayment;
    @SerializedName("selected_id")
    @Expose
    private String selectedId;
    @SerializedName("result_message")
    @Expose
    private String resultMessage;
    @SerializedName("is_replied")
    @Expose
    private Integer isReplied;
    @SerializedName("multi_select_buttons")
    @Expose
    private ArrayList<MultiSelectButtons> multiSelectButtons;
    @SerializedName("min_selection")
    @Expose
    private Integer minSelection;
    @SerializedName("max_selection")
    @Expose
    private Integer maxSelection;

    public String getTitleDescription() {
        return titleDescription;
    }

    public void setTitleDescription(final String titleDescription) {
        this.titleDescription = titleDescription;
    }

    public String getTitle() {
        return title;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public ArrayList<DescriptionObject> getDescriptionObjects() {
        return descriptionObjects;
    }

    public ArrayList<ActionButtonModel> getActionButtons() {
        return actionButtons;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public void setImageUrl(final String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setDescriptionObjects(final ArrayList<DescriptionObject> descriptionObjects) {
        this.descriptionObjects = descriptionObjects;
    }

    public void setActionButtons(final ArrayList<ActionButtonModel> actionButtons) {
        this.actionButtons = actionButtons;
    }

    // for new payment


    public ArrayList<HippoPayment> getHippoPayment() {
        return hippoPayment;
    }

    public void setHippoPayment(ArrayList<HippoPayment> hippoPayment) {
        this.hippoPayment = hippoPayment;
    }

    public String getSelectedId() {
        return selectedId;
    }

    public void setSelectedId(String selectedId) {
        this.selectedId = selectedId;
    }

    public String getResultMessage() {
        return resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public Integer getIsReplied() {
        return isReplied;
    }

    public boolean isReplied() {
        try {
            return isReplied == 1;
        } catch (Exception e) {
            return false;
        }
    }

    public void setIsReplied(Integer isReplied) {
        this.isReplied = isReplied;
    }

    public ArrayList<MultiSelectButtons> getMultiSelectButtons() {
        return multiSelectButtons;
    }

    public void setMultiSelectButtons(ArrayList<MultiSelectButtons> multiSelectButtons) {
        this.multiSelectButtons = multiSelectButtons;
    }

    public Integer getMinSelection() {
        return minSelection;
    }

    public void setMinSelection(Integer minSelection) {
        this.minSelection = minSelection;
    }

    public Integer getMaxSelection() {
        return maxSelection;
    }

    public void setMaxSelection(Integer maxSelection) {
        this.maxSelection = maxSelection;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        dest.writeString(this.titleDescription);
        dest.writeString(this.imageUrl);
        dest.writeList(this.descriptionObjects);
        dest.writeList(this.actionButtons);

        dest.writeList(this.hippoPayment);
        dest.writeString(this.selectedId);
        dest.writeString(this.resultMessage);
        dest.writeInt(this.isReplied);
        dest.writeList(this.multiSelectButtons);
        dest.writeInt(this.minSelection);
        dest.writeInt(this.maxSelection);
    }

    public CustomAction() {
    }

    protected CustomAction(Parcel in) {
        this.title = in.readString();
        this.titleDescription = in.readString();
        this.imageUrl = in.readString();
        this.descriptionObjects = new ArrayList<DescriptionObject>();
        in.readList(this.descriptionObjects, DescriptionObject.class.getClassLoader());
        this.actionButtons = new ArrayList<ActionButtonModel>();
        in.readList(this.actionButtons, ActionButtonModel.class.getClassLoader());

        this.hippoPayment = new ArrayList<HippoPayment>();
        in.readList(this.hippoPayment, HippoPayment.class.getClassLoader());
        this.selectedId = in.readString();
        this.resultMessage = in.readString();
        this.isReplied = in.readInt();
        this.multiSelectButtons = new ArrayList<MultiSelectButtons>();
        in.readList(this.multiSelectButtons, MultiSelectButtons.class.getClassLoader());
        this.minSelection = in.readInt();
        this.maxSelection = in.readInt();
    }

    public static final Creator<CustomAction> CREATOR = new Creator<CustomAction>() {
        @Override
        public CustomAction createFromParcel(Parcel source) {
            return new CustomAction(source);
        }

        @Override
        public CustomAction[] newArray(int size) {
            return new CustomAction[size];
        }
    };
}
