package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

/**
 * Created by cl-macmini-01 on 12/15/17.
 */

public class DescriptionObject implements Parcelable {

    @SerializedName("header")
    private String header;

    @SerializedName("content")
    private String content;

    public String getHeader() {
        return header;
    }

    public String getContent() {
        return content;
    }

    public void setHeader(final String header) {
        this.header = header;
    }

    public void setContent(final String content) {
        this.content = content;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.header);
        dest.writeString(this.content);
    }

    public DescriptionObject() {
    }

    protected DescriptionObject(Parcel in) {
        this.header = in.readString();
        this.content = in.readString();
    }

    public static final Parcelable.Creator<DescriptionObject> CREATOR = new Parcelable.Creator<DescriptionObject>() {
        @Override
        public DescriptionObject createFromParcel(Parcel source) {
            return new DescriptionObject(source);
        }

        @Override
        public DescriptionObject[] newArray(int size) {
            return new DescriptionObject[size];
        }
    };
}
