package com.hippoagent.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Created by ankit on 17/08/17.
 */

public class GetHeatChatResponse {

    @SerializedName("flag")
    @Expose
    private Integer flag;
    @SerializedName("message")
    @Expose
    private String message;
    @SerializedName("data")
    @Expose
    private Data data;

    public Integer getStatusCode() {
        return flag;
    }

    public void setStatusCode(Integer statusCode) {
        this.flag = statusCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public class AgentResponse {

        @SerializedName("agent_id")
        @Expose
        private Integer agentId;
        @SerializedName("name")
        @Expose
        private String name;
        @SerializedName("new")
        @Expose
        private Integer _new;
        @SerializedName("close")
        @Expose
        private Integer close;
        @SerializedName("average_response_time")
        @Expose
        private Double averageResponseTime;

        public Integer getAgentId() {
            return agentId;
        }

        public void setAgentId(Integer agentId) {
            this.agentId = agentId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getNew() {
            return _new;
        }

        public void setNew(Integer _new) {
            this._new = _new;
        }

        public Integer getClose() {
            return close;
        }

        public void setClose(Integer close) {
            this.close = close;
        }

        public Double getAverageResponseTime() {
            return averageResponseTime;
        }

        public void setAverageResponseTime(Double averageResponseTime) {
            this.averageResponseTime = averageResponseTime;
        }
    }

    public class Data {

        @SerializedName("agent_response")
        @Expose
        private List<AgentResponse> agentResponse = null;
        @SerializedName("total_new_chats")
        @Expose
        private Integer totalNewChats;
        @SerializedName("total_closed")
        @Expose
        private Integer totalClosed;
        @SerializedName("date_time_res")
        @Expose
        private List<DateTimeRe> dateTimeRes = null;
        @SerializedName("total_average_response_time")
        @Expose
        private Double totalAverageResponseTime;

        public List<AgentResponse> getAgentResponse() {
            return agentResponse;
        }

        public void setAgentResponse(List<AgentResponse> agentResponse) {
            this.agentResponse = agentResponse;
        }

        public Integer getTotalNewChats() {
            return totalNewChats;
        }

        public void setTotalNewChats(Integer totalNewChats) {
            this.totalNewChats = totalNewChats;
        }

        public Integer getTotalClosed() {
            return totalClosed;
        }

        public void setTotalClosed(Integer totalClosed) {
            this.totalClosed = totalClosed;
        }

        public List<DateTimeRe> getDateTimeRes() {
            return dateTimeRes;
        }

        public void setDateTimeRes(List<DateTimeRe> dateTimeRes) {
            this.dateTimeRes = dateTimeRes;
        }

        public Double getTotalAverageResponseTime() {
            return totalAverageResponseTime;
        }

        public void setTotalAverageResponseTime(Double totalAverageResponseTime) {
            this.totalAverageResponseTime = totalAverageResponseTime;
        }
    }

    public class DateTimeRe {

        @SerializedName("date")
        @Expose
        private String date;
        @SerializedName("new_chats")
        @Expose
        private Integer newChats;
        @SerializedName("closed_chats")
        @Expose
        private Integer closedChats;
        @SerializedName("average_response_time")
        @Expose
        private Double averageResponseTime;

        public String getDate() {
            return date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public Integer getNewChats() {
            return newChats;
        }

        public void setNewChats(Integer newChats) {
            this.newChats = newChats;
        }

        public Integer getClosedChats() {
            return closedChats;
        }

        public void setClosedChats(Integer closedChats) {
            this.closedChats = closedChats;
        }

        public Double getAverageResponseTime() {
            return averageResponseTime;
        }

        public void setAverageResponseTime(Double averageResponseTime) {
            this.averageResponseTime = averageResponseTime;
        }
    }

}
