package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 2019-11-06.
 *
 * @author gurmail
 */
public class HippoPayment implements Parcelable {

    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("title")
    @Expose
    private String title;
    @SerializedName("description")
    @Expose
    private String description;
    @SerializedName("currency")
    @Expose
    private String currency;
    @SerializedName("amount")
    @Expose
    private String amount;
    @SerializedName("discount")
    @Expose
    private String discount;
    @SerializedName("currency_symbol")
    @Expose
    private String currencySymbol;
    @SerializedName("payment_url")
    @Expose
    private String paymentUrl;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public String getPaymentUrl() {
        return paymentUrl;
    }

    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeString(this.currency);
        dest.writeString(this.amount);
        dest.writeString(this.discount);
        dest.writeString(this.currencySymbol);
        dest.writeString(this.paymentUrl);
    }

    public HippoPayment() {
    }

    protected HippoPayment(Parcel in) {
        this.id = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.currency = in.readString();
        this.amount = in.readString();
        this.discount = in.readString();
        this.currencySymbol = in.readString();
        this.paymentUrl = in.readString();
    }

    public static final Creator<HippoPayment> CREATOR = new Creator<HippoPayment>() {
        @Override
        public HippoPayment createFromParcel(Parcel source) {
            return new HippoPayment(source);
        }

        @Override
        public HippoPayment[] newArray(int size) {
            return new HippoPayment[size];
        }
    };
}
