package com.hippoagent.model.LoginResponse;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by amit on 03/05/18.
 */
public class UserProperties implements Parcelable {


    public static final Creator<UserProperties> CREATOR = new Creator<UserProperties>() {
        @Override
        public UserProperties createFromParcel(Parcel in) {
            return new UserProperties(in);
        }

        @Override
        public UserProperties[] newArray(int size) {
            return new UserProperties[size];
        }
    };
    @SerializedName("terms_and_conditions")
    @Expose
    private Integer termsAndConditions;
    @SerializedName("device_logs_interval_mins")
    @Expose
    private Long deviceLogsIntervalMins;

    public Long getDeviceLogsIntervalMins() {
        return deviceLogsIntervalMins;
    }

    public void setDeviceLogsIntervalMins(Long deviceLogsIntervalMins) {
        this.deviceLogsIntervalMins = deviceLogsIntervalMins;
    }

    protected UserProperties(Parcel in) {
        if (in.readByte() == 0) {
            termsAndConditions = null;
            deviceLogsIntervalMins = 360L;
        } else {
            termsAndConditions = in.readInt();
            deviceLogsIntervalMins = in.readLong();
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (termsAndConditions == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(termsAndConditions);
        }
        dest.writeLong(deviceLogsIntervalMins);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /**
     * Gets terms and conditions.
     *
     * @return the terms and conditions
     */
    public Integer getTermsAndConditions() {
        return termsAndConditions;
    }

    /**
     * Sets terms and conditions.
     *
     * @param termsAndConditions the terms and conditions
     */
    public void setTermsAndConditions(Integer termsAndConditions) {
        this.termsAndConditions = termsAndConditions;
    }
}
