package com.hippoagent.model.agent_profile_response;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class Data implements Parcelable {

@SerializedName("full_name")
@Expose
private String fullName;
@SerializedName("phone_number")
@Expose
private String phoneNumber;
@SerializedName("email")
@Expose
private String email;
@SerializedName("user_image")
@Expose
private String userImage;
@SerializedName("user_sub_type")
@Expose
private Integer userSubType;
@SerializedName("business_id")
@Expose
private Integer businessId;

public String getFullName() {
return fullName;
}

public void setFullName(String fullName) {
this.fullName = fullName;
}

public String getPhoneNumber() {
return phoneNumber;
}

public void setPhoneNumber(String phoneNumber) {
this.phoneNumber = phoneNumber;
}

public String getEmail() {
return email;
}

public void setEmail(String email) {
this.email = email;
}

public String getUserImage() {
return userImage;
}

public void setUserImage(String userImage) {
this.userImage = userImage;
}

public Integer getUserSubType() {
return userSubType;
}

public void setUserSubType(Integer userSubType) {
this.userSubType = userSubType;
}

public Integer getBusinessId() {
return businessId;
}

public void setBusinessId(Integer businessId) {
this.businessId = businessId;
}

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.fullName);
        dest.writeString(this.phoneNumber);
        dest.writeString(this.email);
        dest.writeString(this.userImage);
        dest.writeValue(this.userSubType);
        dest.writeValue(this.businessId);
    }

    public Data() {
    }

    protected Data(Parcel in) {
        this.fullName = in.readString();
        this.phoneNumber = in.readString();
        this.email = in.readString();
        this.userImage = in.readString();
        this.userSubType = (Integer) in.readValue(Integer.class.getClassLoader());
        this.businessId = (Integer) in.readValue(Integer.class.getClassLoader());
    }

    public static final Parcelable.Creator<Data> CREATOR = new Parcelable.Creator<Data>() {
        @Override
        public Data createFromParcel(Parcel source) {
            return new Data(source);
        }

        @Override
        public Data[] newArray(int size) {
            return new Data[size];
        }
    };
}