package com.hippoagent.model.user_details;

import android.content.Context;

import com.hippoagent.model.LoginResponse.BusinessProperty;
import com.hippoagent.utils.VisitorInfoConstant;

import java.util.ArrayList;

/**
 * Created by gurmail on 11/04/18.
 * @author gurmail
 */

public class CreateVisitorData {

    private Context context;
    private ArrayList<CustomAttributeList> visitorInfo = new ArrayList<>();

    public CreateVisitorData(Context context) {
        this.context = context;
    }

    public ArrayList<CustomAttributeList> getVisitorData(BusinessProperty property, UtmSources utmSources) {
        visitorInfo.clear();

        if(property.getAgentUtmContinentCode()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.CONTINENT_CODE.getMessage(context), utmSources.getUtmContinentCode()));
        }

        if(property.getAgentUtmGclId()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.GCLID.getMessage(context), utmSources.getUtmGclId()));
        }

        if(property.getAgentUtmMedium()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_MEDIUM.getMessage(context), utmSources.getUtmMedium()));
        }

        if(property.getAgentUtmOldSource()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_OLD_SOURCE.getMessage(context), utmSources.getUtmOldSource()));
        }

        if(property.getAgentUtmOldMedium()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_OLD_MEDIUM.getMessage(context), utmSources.getUtmOldMedium()));
        }

        if(property.getAgentUtmPreviousPage()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.PREVIOUS_PAGE.getMessage(context), utmSources.getUtmPreviousPage()));
        }

        if(property.getAgentUtmProduct()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.PRODUCT.getMessage(context), utmSources.getUtmProduct()));
        }

        if(property.getAgentUtmReferrer()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.REFERRER.getMessage(context), utmSources.getUtmReferrer()));
        }

        if(property.getAgentUtmSource()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_SOURCE.getMessage(context), utmSources.getUtmSource()));
        }

        if(property.getAgentUtmTerm()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_TERM.getMessage(context), utmSources.getUtmTerm()));
        }

        if(property.getAgentUtmVerticalPage()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.VERTICAL_PAGE.getMessage(context), utmSources.getUtmVerticalPage()));
        }

        if(property.getAgentUtmWebRefrrer()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.WEB_REFERRER.getMessage(context), utmSources.getUtmWebRefrrer()));
        }

        if(property.getAgentOldUtmCampaign()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.OLD_UTM_CAMPAIGN.getMessage(context), utmSources.getOld_utm_campaign()));
        }

        if(property.getAgentUtmCampaign()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_CAMPAIGN.getMessage(context), utmSources.getUtm_campaign()));
        }

        if(property.getAgentUtmSessionIp()) {
            visitorInfo.add(new CustomAttributeList(VisitorInfoConstant.UTM_SESSION_IP.getMessage(context), utmSources.getSession_ip()));
        }

        return visitorInfo;
    }
}