package com.hippo.record

import android.app.Activity
import android.media.MediaRecorder
import android.os.Environment
import android.util.Log
import com.hippoagent.R
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.langs.Restring
import com.hippoagent.utils.easypermissions.AppSettingsDialog
import com.hippoagent.utils.easypermissions.EasyPermissions

import java.io.File
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*


class RecordingUtil(activity: Activity, recordingListener: RecordingListener) :
        EasyPermissions.PermissionCallbacks {
    lateinit var recorder: MediaRecorder
    lateinit var audiofile: File
    var activity: Activity = activity
    val TAG = "MediaRecording"
    var recordingListener: RecordingListener = recordingListener
    var isRecordStarted = false


    @Throws(IOException::class)
    public fun startRecording() {
        if (hasPermission()) {
            //Creating file

            val timeStamp = SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(Date())

            try {
                audiofile = File(
                        Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_MUSIC).absolutePath
                                + "/AUD_" + timeStamp + ".aac"
                )
            } catch (e: IOException) {
                Log.e(TAG, "external storage access error")
                return
            }
            isRecordStarted = true
            //Creating MediaRecorder and specifying audio source, output format, encoder & output format
            recorder = MediaRecorder()
            recorder.setAudioSource(MediaRecorder.AudioSource.MIC)
//            recorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP)
            recorder.setOutputFormat(MediaRecorder.OutputFormat.AAC_ADTS);
            recorder.setAudioEncoder(MediaRecorder.AudioEncoder.AAC)
            recorder.setOutputFile(audiofile.getAbsolutePath())
            recorder.prepare()
            recorder.start()
        }
    }

    public fun stopRecording() {
        //stopping recorder
        if (isRecordStarted) {

            recorder.stop()
            recorder.release()
            if (audiofile != null)
                recordingListener.onRecordedFile(audiofile.absolutePath, audiofile.length())
            else
                recordingListener.onRecordFileError()
            isRecordStarted = false

        }
        //after stopping the recorder, create the sound file and add it to media library.
    }

    public fun cancelRecording() {
        if (isRecordStarted) {
            try {
                recorder.stop()
                recorder.release()
            } catch (e: RuntimeException) {
//                e.printStackTrace()
            }


        }
    }

    override fun onRequestPermissionsResult(
            requestCode: Int,
            permissions: Array<out String>,
            grantResults: IntArray
    ) {

        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this)

    }

    override fun onPermissionsGranted(requestCode: Int, perms: MutableList<String>) {
        startRecording()
    }

    override fun onPermissionsDenied(requestCode: Int, perms: MutableList<String>) {
        if (EasyPermissions.somePermissionPermanentlyDenied(activity, perms)) {
            AppSettingsDialog.Builder(activity).build().show()
        }
    }


    private fun hasPermission(): Boolean {
        val isGranted = EasyPermissions.hasPermissions(
                activity,
                "android.permission.READ_EXTERNAL_STORAGE",
                "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"
        )
        if (isGranted) {
            return true
        } else {

            EasyPermissions.requestPermissions(
                    activity,
                    Restring.getString(activity, R.string.vw_rationale_storage),
                    FuguAppConstant.RC_READ_EXTERNAL_STORAGE,
                    "android.permission.READ_EXTERNAL_STORAGE",
                    "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"
            )
            return false
        }
    }

}