package com.hippoagent.retrofit;

import android.text.TextUtils;

import com.hippoagent.BuildConfig;
import com.hippoagent.HippoConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.utils.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import java.util.HashMap;

import static com.hippoagent.utils.Constants.APP_SOURCE_TYPE;
import static com.hippoagent.utils.Constants.APP_VERSION;
import static com.hippoagent.utils.Constants.DEVICE_DETAILS;
import static com.hippoagent.utils.Constants.DEVICE_ID;
import static com.hippoagent.utils.Constants.DEVICE_TYPE;
import static com.hippoagent.utils.Constants.ANDROID_USER;

/**
 * Created by cl-macmini-33 on 27/09/16.
 */

public class CommonParams {
    HashMap<String, String> map = new HashMap<>();
    Gson gson = new GsonBuilder().create();


    private CommonParams(Builder builder, boolean hasLang, String langCode) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new DeviceDetails(HippoApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
            Log.e("TAG", ""+gson.toJson(deviceDetailsJson));
        } catch (Exception e) {
            //e.printStackTrace();
        }

        try {
            deviceID = HippoApplication.getInstance().getDeviceId();
        } catch (Exception e) {

        }


        builder.map.put(APP_SOURCE_TYPE, String.valueOf(1));
        builder.map.put(APP_VERSION, String.valueOf(BuildConfig.VERSION_CODE));
        //builder.map.put(APP_VERSION_CODE, String.valueOf(HippoConfig.getInstance().getAttributes().getVersionCode()));
        builder.map.put(DEVICE_TYPE, String.valueOf(ANDROID_USER));
        if(deviceDetailsJson != null)
            builder.map.put(DEVICE_DETAILS, gson.toJson(deviceDetailsJson));
        if(!TextUtils.isEmpty(deviceID))
            builder.map.put(DEVICE_ID, deviceID);

        if(HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
          //  builder.map.put("reference_secret_key", HippoConfig.getInstance().getAttributes().getAppKey());
        }

        if(hasLang) {
            if(!TextUtils.isEmpty(langCode))
                builder.map.put("lang", langCode);
        } else {
            if(!TextUtils.isEmpty(HippoConfig.getInstance().getCurrentLanguage()))
                builder.map.put("lang", HippoConfig.getInstance().getCurrentLanguage());
        }
//
//        if(!hasLang && !TextUtils.isEmpty(HippoConfig.getInstance().getCurrentLanguage())) {
//            builder.map.put("lang", HippoConfig.getInstance().getCurrentLanguage());
//        }

        this.map = builder.map;

    }

    public HashMap<String, String> getMap() {
        return map;
    }


    public static class Builder {
        HashMap<String, String> map = new HashMap<>();

        public Builder() {
        }

        public Builder addAccessToken(String key, String value) {
            map.put(key, value);
            return this;
        }

        public Builder add(String key, Object value) {
            /*if(key.equalsIgnoreCase(Constants.ACCESS_TOKEN)) {
                addAccessToken(key, HippoApplication.getInstance().getUserData().getAccessToken());
            } else {
                map.put(key, String.valueOf(value));
            }*/
            map.put(key, String.valueOf(value));
            return this;
        }

        public Builder addAll(HashMap<String, String> objectHashMap) {
            map.putAll(objectHashMap);
            return this;
        }

        public CommonParams build() {
            return new CommonParams(this, false, "");
        }

        public CommonParams build(boolean hasLang, String langCode) {
            return new CommonParams(this, hasLang, langCode);
        }
    }
}


