package com.hippoagent.retrofit;


import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoConfig;
import com.hippoagent.database.CommonData;
import com.hippoagent.utils.SPLabels;

import java.util.concurrent.TimeUnit;

import io.paperdb.Paper;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Rest Client
 */
public class RestClient {

    public static Retrofit retrofit = null;
    public static Retrofit retrofitAws = null;
    private static ApiInterface API_SERVICES = null;

    public static Retrofit testRetrofit = null;

    /**
     * @return
     */
    public static ApiInterface getApiInterface() {
      //  if (retrofit == null) {
        String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getServerUrl());
            retrofit = new Retrofit.Builder()
                    .baseUrl(link)
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient().build())
                    .build();
    //    }
        return retrofit.create(ApiInterface.class);
    }

    public static ApiInterface getApiInterfaceAws(String link) {
      //  if (retrofit == null) {
//        String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getServerUrl());
        retrofitAws = new Retrofit.Builder()
                    .baseUrl(link)
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient().build())
                    .build();
    //    }
        return retrofitAws.create(ApiInterface.class);
    }

    public static ApiInterface getNotifyApiInterface() {
        retrofit = new Retrofit.Builder()
                .baseUrl("https://hippo-api-dev.fuguchat.com:3002")
                .addConverterFactory(GsonConverterFactory.create())
                .client(httpClient().build())
                .build();
        return retrofit.create(ApiInterface.class);
    }

    public static ApiInterface getApiInterfaceAnalytics() {
        retrofit = new Retrofit.Builder()
                .baseUrl("https://api.fuguchat.com")
                .addConverterFactory(GsonConverterFactory.create())
                .client(httpClient().build())
                .build();
        return retrofit.create(ApiInterface.class);
    }

    public static ApiInterface getTestApi() {
        testRetrofit = new Retrofit.Builder()
                .baseUrl("")
                .addConverterFactory(GsonConverterFactory.create())
                .client(httpClient().build())
                .build();

        return testRetrofit.create(ApiInterface.class);
    }

    /**
     * @return
     */
    public static ApiInterface getApiInterfaceForContinent() {
        //if (retrofit == null) {
            retrofit = new Retrofit.Builder()
                    .baseUrl("https://ip.tookanapp.com:8000") // TODO: 01/06/17
                    //.baseUrl("https://api.github.com/")
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient().build())
                    .build();
        //}
        return retrofit.create(ApiInterface.class);
    }

    /**
     * @return
     */
    public static Retrofit getRetrofitBuilder() {
        if (retrofit == null) {
            String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getServerUrl());
            retrofit = new Retrofit.Builder()
                    .baseUrl(link)
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient().build())
                    .build();
        }
        return retrofit;
    }

    /**
     * @return
     */
    private static OkHttpClient.Builder httpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        // set your desired log level
        //logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        logging.setLevel(HippoConfig.getInstance().getAttributes().isShowLog() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().readTimeout(30, TimeUnit.SECONDS)
                .connectTimeout(30, TimeUnit.SECONDS);


        // add_small your other interceptors …
        // add_small logging as last interceptor
        httpClient.addInterceptor(logging);
        return httpClient;
    }

    /**
     * @return
     */
//    private static OkHttpClient.Builder httpClient() {
//        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
//        // set your desired log level
//        //logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
////        logging.setLevel(HttpLoggingInterceptor.Level.NONE);
//        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
//        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().readTimeout(30, TimeUnit.SECONDS)
//                .connectTimeout(30, TimeUnit.SECONDS);
//
//        // add_small your other interceptors …
//        // add_small logging as last interceptor
//        httpClient.addInterceptor(logging);
//        return httpClient;
//    }

    /**
     * @return
     */
    /*private static OkHttpClient.Builder httpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        // set your desired log level
        //logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
//        if(HippoConfig.DEBUG)
//            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
//        else
//            logging.setLevel(HttpLoggingInterceptor.Level.NONE);
//        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        logging.setLevel(HippoConfig.getInstance().getAttributes().isdebugType() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().readTimeout(120, TimeUnit.SECONDS)
                .connectTimeout(120, TimeUnit.SECONDS);

        // add_small your other interceptors
        // add_small logging as last interceptor
        httpClient.addInterceptor(logging);
        return httpClient;
    }*/

//    private static OkHttpClient.Builder httpClient() {
//        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
//        // set your desired log level
////        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
//        //logging.setLevel(HippoConfig.getInstance().getAttributes().isdebugType() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
//        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
//
//        // add your other interceptors …
//        // add logging as last interceptor
//        Dispatcher dispatcher = new Dispatcher();
//        dispatcher.setMaxRequests(2);
//        //dispatcher.queuedCalls();
//        httpClient.dispatcher(dispatcher);
//
//        httpClient.addInterceptor(logging);
//        httpClient.readTimeout(40, TimeUnit.SECONDS);
//        httpClient.writeTimeout(40,TimeUnit.SECONDS);
//        httpClient.connectTimeout(40,TimeUnit.SECONDS);
//        return httpClient;
//    }

    public static void clearRestClients(){
        API_SERVICES = null;
        retrofit = null;
    }

    public static void setupAllClients(){
        getApiInterface();
    }


}
