package com.hippoagent.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.IBinder;
import android.widget.Toast;

import androidx.core.app.NotificationCompat;

import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.AdvanceSpecInfoModel;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonResponse;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import static com.hippoagent.utils.Constants.ACCESS_TOKEN;
import static com.hippoagent.utils.Constants.EN_USER_ID;

public class AdvanceSpecService extends Service {

    public static final String CHANNEL_ONE_ID = "com.hippoagent.ONE";
    private boolean isCtrSessionTime;
    private boolean isDelivered;
    private boolean isSeenStatus;
    private boolean isPromotionDialog;
    JSONObject jsonObject;

    @Override
    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }


    @Override
    public void onCreate() {
        super.onCreate();
        try {
            if (Build.VERSION.SDK_INT >= 26) {

                NotificationChannel channel = new NotificationChannel(CHANNEL_ONE_ID,
                        "Test",
                        NotificationManager.IMPORTANCE_DEFAULT);

                ((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE)).createNotificationChannel(channel);

                Notification notification = new NotificationCompat.Builder(this, CHANNEL_ONE_ID)
                        .setContentTitle(this.getResources().getString(R.string.app_name))
                        .setContentText("").build();


                startForeground(1001, notification);
            } else {
                startForeground(1001,
                        generateNotification(this,
                                10001, false));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        try {
            String messageString = intent.getStringExtra("messageJson");
            isCtrSessionTime = intent.getBooleanExtra("isCtrSessionTime", false);
            isDelivered = intent.getBooleanExtra("isDelivered", false);
            isSeenStatus = intent.getBooleanExtra("isSeenStatus", false);
            isPromotionDialog = intent.getBooleanExtra("isPromotionDialog", false);
            if (messageString != null && !messageString.isEmpty()) {
                try {
                    jsonObject = new JSONObject(messageString);
                    advanceSpecApi(jsonObject);

                } catch (JSONException e) {

                    stopSelf();
                }
            } else {
                stopSelf();
            }
        } catch (Exception e) {

        }


        return Service.START_STICKY;
    }

    private void advanceSpecApi(JSONObject jsonObject) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("channel_id", jsonObject.get("channel_id"));
            params.put(EN_USER_ID, HippoApplication.getInstance().getUserData().getEnUserId());

            params.put(ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken());

            if (isCtrSessionTime) {
                Long time;
                time = CommonData.getAdvanceSpecData().getStart_time_milis();
                time = System.currentTimeMillis() - time;
                params.put("ctr_session_time", TimeUnit.MILLISECONDS.toSeconds(time));
                CommonData.saveAdvanceSpecData(new AdvanceSpecInfoModel(0L, ""));
                Log.e("ctrsessionaTime", "" + time);

            }

            if (isDelivered)
                params.put("is_delivered", 1);
            if (isSeenStatus) {
//                params.put("seen_status", 1);
                params.put("app_opened_through_push", 1);
            }

            if (isPromotionDialog) {
                params.put("is_clicked", 1);
                params.put("open_links", jsonObject.getJSONArray("open_links"));
            }
            RestClient.getApiInterface().advanceSpecApi(params).enqueue(new ResponseResolver<CommonResponse>() {
                @Override
                public void success(CommonResponse commonResponse) {
                    stopSelf();
                }

                @Override
                public void failure(APIError error) {

                    stopSelf();
                }
            });
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);

    }


    @Override
    public void onDestroy() {

       stopSelf();

    }

    public Notification generateNotification(Context context, int notificationId, boolean notify) {
        try {


            long when = System.currentTimeMillis();
            NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

//            Intent notificationIntent = new Intent(context, DriverSplashActivity.class);
//
//            notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
//            PendingIntent intent = PendingIntent.getActivity(context, 0, notificationIntent, 0);


            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID);
            builder.setAutoCancel(false);
            builder.setContentTitle(context.getResources().getString(R.string.app_name));
            builder.setChannelId(CHANNEL_ONE_ID);

            builder.setWhen(when);
//            builder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), GCMIntentService.NOTIFICATION_BIG_ICON));
//            builder.setSmallIcon(R.drawable.hippo_default_notif_icon);
//            builder.setContentIntent(intent);


            Notification notification = builder.build();
            if (notify) {
                notificationManager.notify(notificationId, notification);
            }
            return notification;

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}

