package com.hippoagent.services;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;

import androidx.annotation.NonNull;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;

import com.hippoagent.database.CommonData;


public class AppLifecycleListener implements DefaultLifecycleObserver {
    Context context;

    public AppLifecycleListener(Context applicationContext) {
        context = applicationContext;
    }

    @Override
    public void onCreate(@NonNull LifecycleOwner owner) {

    }

    @Override
    public void onStart(@NonNull LifecycleOwner owner) {

    }

    @Override
    public void onResume(@NonNull LifecycleOwner owner) {

    }

    @Override
    public void onPause(@NonNull LifecycleOwner owner) {

    }

    @Override
    public void onStop(@NonNull LifecycleOwner owner) {
        try {
            if (CommonData.getAdvanceSpecData() != null && CommonData.getAdvanceSpecData().getStart_time_milis() > 0L) {
                Intent intent = new Intent(context, AdvanceSpecService.class);
                intent.putExtra("messageJson", CommonData.getAdvanceSpecData().getMessage());
                intent.putExtra("isCtrSessionTime", true);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
                    context.startForegroundService(intent);
                else
                    context.startService(intent);
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy(@NonNull LifecycleOwner owner) {


    }
}
