package com.hippoagent.tickets;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippoagent.R;
import com.hippoagent.tickets.models.Result;

import java.util.ArrayList;

public class BottomSheetTicketFragment extends BottomSheetDialogFragment {
    private RecyclerView rvOptions;
    private View mView;
    private Context mContext;
    private Boolean isIssue;
    ArrayList<Result> result;
    SelectedOptionCallback selectedOptionCallback;
    private TicketOptionsAdapter ticketOptionsAdapter;

    public BottomSheetTicketFragment(Boolean isIssue, ArrayList<Result> result, SelectedOptionCallback selectedOptionCallback) {
        this.result = result;
        this.isIssue = isIssue;
        this.selectedOptionCallback = selectedOptionCallback;
    }

    @Override
    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        if(getArguments() != null) {
//            bot = new Gson().fromJson(getArguments().getString("data"), null);
//        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.bottom_sheet_ticket_option, container, false);
        init(view);
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        mContext = context;
    }

    private void init(View rootView) {
        rvOptions = (RecyclerView) rootView.findViewById(R.id.rvOptions);

        LinearLayoutManager layoutManager = new LinearLayoutManager(mContext);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        rvOptions.setLayoutManager(layoutManager);
        ticketOptionsAdapter = new TicketOptionsAdapter(mContext, result);
        rvOptions.setAdapter(ticketOptionsAdapter);
        ticketOptionsAdapter.setClickListener(new TicketOptionsAdapter.ItemClickListener() {
            @Override
            public void onItemClick(View view, int position) {
                if (isIssue)
                    selectedOptionCallback.onSelectedIssue(result.get(position).getValue());
                else
                    selectedOptionCallback.onSelectedPriority(result.get(position).getValue());

//                ((CreateTicketActivity) getActivity()).closeBottomSheet();


            }
        });

        rootView.findViewById(R.id.btnCancel).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                ((CreateTicketActivity) getActivity()).closeBottomSheet();
            }
        });
    }


}
