package com.hippoagent.tickets


import android.app.Activity
import android.app.Dialog
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.graphics.Bitmap
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.util.Log
import android.view.View
import android.view.WindowManager
import android.widget.*
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.bumptech.glide.Glide
import com.bumptech.glide.Priority
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.request.RequestOptions
import com.google.gson.Gson
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.FuguBaseActivity
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.fragments.AttachmentSheetFragment
import com.hippoagent.model.Conversation
import com.hippoagent.model.FileuploadModel
import com.hippoagent.model.user_details.UserDetailsResponse
import com.hippoagent.retrofit.*
import com.hippoagent.tickets.models.CreateCustomerResponse
import com.hippoagent.tickets.models.Result
import com.hippoagent.tickets.models.TicketPriorityOptionsData
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Utils
import com.hippoagent.utils.compressor.Compressor
import com.hippoagent.utils.easypermissions.AppSettingsDialog
import com.hippoagent.utils.easypermissions.EasyPermissions
import com.hippoagent.utils.filePicker.*
import com.hippoagent.utils.filePicker.activity.AudioPickActivity
import com.hippoagent.utils.filePicker.activity.ImagePickActivity
import com.hippoagent.utils.filePicker.activity.NormalFilePickActivity
import com.hippoagent.utils.filePicker.activity.VideoPickActivity
import com.hippoagent.utils.filePicker.filter.entity.AudioFile
import com.hippoagent.utils.filePicker.filter.entity.ImageFile
import com.hippoagent.utils.filePicker.filter.entity.NormalFile
import com.hippoagent.utils.filePicker.filter.entity.VideoFile
import com.hippoagent.utils.filelogger.Logger
import com.hippoagent.utils.loadingBox.LoadingBox
import com.hippoagent.utils.zoomview.ZoomageView
import kotlinx.android.synthetic.main.activity_create_ticket.*
import org.json.JSONArray
import java.io.File
import java.util.*

import kotlin.collections.ArrayList

class CreateTicketActivity : FuguBaseActivity(), EasyPermissions.PermissionCallbacks {
    private var showdropdownPriority: Boolean = true
    private var showdropdownIssue: Boolean = true
    private lateinit var issueAdapter: ArrayAdapter<String>
    private lateinit var priorityAdapter: ArrayAdapter<String>
    private lateinit var userdetail: UserDetailsResponse
    private var selectedPriorityType: String? = ""
    private var selectedIssueType: String? = ""

    //    private lateinit var bottomSheetTicketFragment: BottomSheetTicketFragment
    private var conversation: Conversation? = null
    private var dealId: String? = null
    private var imageUtils: ImageUtils? = null
    var isCameraPermission = false
    private var isFromFilePicker = false
    private var checkAndCreated = false

    //    private var issueList: ArrayList<Result>? = null
//    private var priorityList: ArrayList<Result>? = null
    var attachments = ArrayList<String>()
    var attachmentsFileName = ArrayList<String>()
    lateinit var attachmentsAdapter: AttachmentsAdapter

    var issueList = mutableListOf("")
    var priorityList = mutableListOf("")


    private val fileUploadReceiver: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            val status = intent.getIntExtra(FuguAppConstant.BROADCAST_STATUS, 0)
            when (status) {
                FuguAppConstant.BroadCastStatus.UPLOADED_SUCESSFULLY -> {
                    val muid = intent.getStringExtra("muid")
                    val imageUrl = intent.getStringExtra("image_url")
                    val thumbnailUrl = intent.getStringExtra("thumbnail_url")
                    val fileuploadModel = Gson().fromJson(
                        intent.getStringExtra("fileuploadModel"),
                        FileuploadModel::class.java
                    )
                    attachments.add(imageUrl!!)
                    attachmentsFileName.add(fileuploadModel.fileName)
                    attachmentsAdapter.notifyDataSetChanged()
                }
                FuguAppConstant.BroadCastStatus.UPLOADING_FAILED -> {
                    val muid = intent.getStringExtra("muid")
                    val imageUrl = intent.getStringExtra("image_url")
                    val thumbnailUrl = intent.getStringExtra("thumbnail_url")
                    val fileuploadModel = Gson().fromJson(
                        intent.getStringExtra("fileuploadModel"),
                        FileuploadModel::class.java
                    )

                }
                FuguAppConstant.BroadCastStatus.FILE_TYPE_NOT_ALLOWED -> {
                    val muidd = intent.getStringExtra("muid")
                    val errorMessage = intent.getStringExtra("errorMessage")
                    val messageIndexx = intent.getIntExtra("messageIndex", 0)

                    Toast.makeText(this@CreateTicketActivity, errorMessage, Toast.LENGTH_SHORT)
                        .show()
                }

            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_create_ticket)
        setSupportActionBar(my_toolbar)
        setToolbar(my_toolbar, "Create Ticket")

        imageUtils = ImageUtils(this)

        getIntentData()

        initUI();

        val layoutManager = LinearLayoutManager(this)
        layoutManager.orientation = LinearLayoutManager.VERTICAL
        attachmentsRV.setLayoutManager(layoutManager)
        attachmentsAdapter = AttachmentsAdapter(this, attachments, attachmentsFileName)
        attachmentsRV.adapter = attachmentsAdapter
        attachmentsRV.setNestedScrollingEnabled(false);

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }



        priorityACTV.setThreshold(1)
        issueTypeACTV.setThreshold(1)

        priorityACTV.setOnFocusChangeListener(object : View.OnFocusChangeListener {
            override fun onFocusChange(v: View?, hasFocus: Boolean) {
                if (hasFocus) {
                    priorityAdapter = ArrayAdapter<String>(
                        this@CreateTicketActivity,
                        android.R.layout.simple_selectable_list_item,
                        priorityList
                    )
                    priorityACTV.setAdapter(priorityAdapter)
                    getDropdownData(false, "")
                }
            }

        })

        priorityACTV.onItemClickListener =
            AdapterView.OnItemClickListener { parent, view, position, id ->
                val selectedItem = parent.getItemAtPosition(position).toString()
                priorityACTV.setText(selectedItem)
                priorityACTV.setEnoughFilter(false)
                priorityACTV.dismissDropDown()

            }

        issueTypeACTV.onItemClickListener =
            AdapterView.OnItemClickListener { parent, view, position, id ->
                val selectedItem = parent.getItemAtPosition(position).toString()
                issueTypeACTV.setText(selectedItem)
                issueTypeACTV.setEnoughFilter(false)
                issueTypeACTV.dismissDropDown()

            }


        priorityACTV.addTextChangedListener(object : TextWatcher {
            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {}
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}
            override fun afterTextChanged(textString: Editable?) {
                if (textString?.length!! > 2) {
                    if (!selectedPriorityType.equals(textString.toString())) {
                        selectedPriorityType = textString.toString()
                        showdropdownPriority = true
                        getDropdownData(false, textString.toString())
                    } else {
                        showdropdownPriority = false
                    }
                } else if (textString?.length == 0) {
                    showdropdownPriority = true
                    getDropdownData(false, "")

                }
            }
        })


        issueTypeACTV.setOnFocusChangeListener(object : View.OnFocusChangeListener {
            override fun onFocusChange(v: View?, hasFocus: Boolean) {
                if (hasFocus) {
                    issueAdapter = ArrayAdapter<String>(
                        this@CreateTicketActivity,
                        android.R.layout.simple_selectable_list_item,
                        issueList
                    )
                    issueTypeACTV.setAdapter(issueAdapter)
                    getDropdownData(true, "")
                }
            }

        })

        issueTypeACTV.addTextChangedListener(object : TextWatcher {
            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {}
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}
            override fun afterTextChanged(textString: Editable?) {
                if (textString?.length!! > 2) {
                    if (!selectedIssueType.equals(textString.toString())) {
                        selectedIssueType = textString.toString()
                        showdropdownIssue = true
                        getDropdownData(true, textString.toString())
                    } else {
                        showdropdownIssue = false
                    }
                } else if (textString?.length == 0) {
                    showdropdownIssue = true
                    getDropdownData(true, "")

                }
            }
        })


        getUserData();
    }

    private fun initUI() {

        priorotyLabelTV.text = getString(R.string.priority) + " :"
        issueTypeLabelTV.text = getString(R.string.issue_type) + " :"
        descriptionLabelTV.text = getString(R.string.description) + "* :"
        subjectLabelTV.text = getString(R.string.subject) + "* :"
        customerNameLabelTV.text = getString(R.string.customer_name) + "* :"
        emailLabelTV.text = getString(R.string.customer_email) + "* :"
        submitBT.text = getString(R.string.submit)
        attachFileTV.text = getString(R.string.attach_file)
    }

    override fun onResume() {
        super.onResume()
        isFromFilePicker = false
        //LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver1, new IntentFilter("custom-event-name"));
        LocalBroadcastManager.getInstance(this)
            .registerReceiver(fileUploadReceiver, IntentFilter(FuguAppConstant.HIPPO_FILE_UPLOAD))


    }

    override fun onPause() {
        super.onPause()
        LocalBroadcastManager.getInstance(this).unregisterReceiver(fileUploadReceiver)

    }

    private fun getIntentData() {
        conversation =
            Gson().fromJson(intent.getStringExtra(Constants.CONVERSATION), Conversation::class.java)

        if (intent.hasExtra("deal_id"))
            dealId = intent.getStringExtra("deal_id")




        attachFileTV.setOnClickListener {
            if (attachments.size < 5) {
                val bottomSheetFragment = AttachmentSheetFragment().newInstance()
                bottomSheetFragment.show(supportFragmentManager, bottomSheetFragment.tag)
            } else {
                Toast.makeText(this, R.string.CanNotAddMoreFiles, Toast.LENGTH_SHORT).show();

            }
        }

        submitBT.setOnClickListener {
            if (Validate()) {
                if (checkAndCreated)
                    createTicket()
                else
                    checkAndCreateCustomer(
                        nameET.text.toString().trim(),
                        emailET.text.toString().trim(),
                        false
                    );

            }
        }


    }

    private fun createTicket() {
        if (isNetworkAvailable()) {

            val commonParams = CommonParams.Builder()
                .add("lang", "en")
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add("subject", subjectET.text.toString().trim())
                .add("description", descriptionET.text.toString().trim())
                .add("customer_id", userdetail.data[0].userId)
                .add("customer_email", emailET.text.toString().trim())
                .add("customer_name", nameET.text.toString().toString())
                .add("erp_customer_name", nameET.text.toString().trim())
                .build()


            if (!issueTypeACTV.text.toString().trim().isEmpty())
                commonParams.map.put("issue_type", issueTypeACTV.text.toString().trim())
            if (!priorityACTV.text.toString().trim().isEmpty())
                commonParams.map.put("priority", priorityACTV.text.toString().trim())

            if (attachments != null && attachments.size > 0) {
                val jsonArray = JSONArray()
                for (i in 0 until attachments.size) {
                    jsonArray.put(attachments[i])
                }
                commonParams.map.put("attachments", jsonArray.toString())
            }


            Logger.apiRequest("api/erpnext/createIssue", Gson().toJson(commonParams.map))

            RestClient.getApiInterface().createIssue(commonParams.map)
                .enqueue(object : ResponseResolver<CommonResponse>(this, true, true) {
                    override fun success(commonResponse: CommonResponse) {
                        Logger.apiResponse("api/erpnext/createIssue", "")
                        finish()
                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("api/erpnext/createIssue", error.message)
                        Log.e("error", "error")
                    }
                })
        } else {
            Toast.makeText(
                this,
                getString(R.string.fugu_unable_to_connect_internet),
                Toast.LENGTH_SHORT
            ).show()
        }
    }

    private fun Validate(): Boolean {
        if (emailET.text.trim().isEmpty()) {
            Toast.makeText(this, getString(R.string.PleaseEnterEmailId), Toast.LENGTH_SHORT).show();
            return false
        } else if (!Utils.isValidEmail(emailET.text.toString())) {
            Toast.makeText(this, getString(R.string.PleaseEnterValidEmail), Toast.LENGTH_SHORT)
                .show();
            return false
        } else if (nameET.text.trim().isEmpty()) {
            Toast.makeText(this, getString(R.string.PleaseEnterName), Toast.LENGTH_SHORT).show();
            return false
        } else if (subjectET.text.trim().isEmpty()) {
            Toast.makeText(this, R.string.PleaseenterSubject, Toast.LENGTH_SHORT).show();
            return false
        } else if (descriptionET.text.trim().isEmpty()) {
            Toast.makeText(this, R.string.PleaseenterDescription, Toast.LENGTH_SHORT).show();
            return false
        }
//        else if (issueTypeTV.text.trim().isEmpty()) {
//            Toast.makeText(this, "Please select Issue Type", Toast.LENGTH_SHORT).show();
//            return false
//        } else if (priorityTV.text.trim().isEmpty()) {
//            Toast.makeText(this, "Please select Issue Priority", Toast.LENGTH_SHORT).show();
//            return false
//        }
        return true
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

        when (requestCode) {

            Constant.REQUEST_CODE_PICK_IMAGE -> if (resultCode == Activity.RESULT_OK) {
                isFromFilePicker = true
                val list: ArrayList<ImageFile> =
                    data!!.getParcelableArrayListExtra(Constant.RESULT_PICK_IMAGE)!!
                val builder = StringBuilder()
                val path: String? = null
                val actualfile = list[0]
                val muid = UUID.randomUUID().toString() + "." + Date().time
                val fileExt = Utils.getExtension(actualfile!!.path)
                if (!TextUtils.isEmpty(fileExt)) {
                    actualfile.name = "$muid.$fileExt"
                }
                actualfile.muid = muid
                val localPath = Utils.setImageFullPath(this, muid + "_" + muid + "." + fileExt)
                actualfile.destinationPath = localPath
                actualfile.let { compressImage(it) }

                //HippoLog.v(TAG, "Image: "+builder.toString());
            }
            Constant.REQUEST_CODE_PICK_VIDEO -> if (resultCode == Activity.RESULT_OK) {
                isFromFilePicker = true
                val list: ArrayList<VideoFile> =
                    data!!.getParcelableArrayListExtra(Constant.RESULT_PICK_VIDEO)!!
                val file = list[0]
                val muid = UUID.randomUUID().toString() + "." + Date().time
                val fileExt = Utils.getExtension(file.path)
                //                    String fileName = file.getName();
                var fileName = muid //file.getName();
                if (!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "." + fileExt;
                    fileName = "$fileName.$fileExt"
                }
                val fileuploadModel =
                    FileuploadModel(fileName, file.size.toString(), file.path, muid)
                fileuploadModel.fileSizeReadable = Utils.humanReadableByteCount(file.size, true)
                fileuploadModel.documentType = FuguAppConstant.DocumentType.VIDEO.toString()
                copingFileToLocal(fileuploadModel, FuguAppConstant.VIDEO_FOLDER)
            }
            Constant.REQUEST_CODE_PICK_AUDIO -> if (resultCode == Activity.RESULT_OK) {
                isFromFilePicker = true
                val list: ArrayList<AudioFile> =
                    data!!.getParcelableArrayListExtra(Constant.RESULT_PICK_AUDIO)!!
                if (list == null || list.size == 0) return
                val file = list[0]
                val muid = UUID.randomUUID().toString() + "." + Date().time
                val fileExt = Utils.getExtension(file.path)
                //                    String fileName = file.getName();
//                    if (!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "." + fileExt;
//                    }
                var fileName = muid
                if (!TextUtils.isEmpty(fileExt)) {
                    fileName = "$fileName.$fileExt"
                }
                val fileuploadModel =
                    FileuploadModel(fileName, file.size.toString(), file.path, muid)
                fileuploadModel.fileSizeReadable = Utils.humanReadableByteCount(file.size, true)
                fileuploadModel.documentType = FuguAppConstant.DocumentType.AUDIO.toString()
                copingFileToLocal(fileuploadModel, FuguAppConstant.AUDIO_FOLDER)
            }
            Constant.REQUEST_CODE_PICK_FILE -> if (resultCode == Activity.RESULT_OK) {
                isFromFilePicker = true
                val list: ArrayList<NormalFile> =
                    data!!.getParcelableArrayListExtra(Constant.RESULT_PICK_FILE)!!
                val builder = StringBuilder()
                val file = list[0]
                val muid = UUID.randomUUID().toString() + "." + Date().time
                val fileExt = Utils.getExtension(file.path)
                //                    String fileName = file.getName();
//                    if (!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "." + fileExt;
//                    }
                var fileName = muid
                if (!TextUtils.isEmpty(fileExt)) {
                    fileName = "$fileName.$fileExt"
                }
                val filePath = ""
                val fileuploadModel =
                    FileuploadModel(fileName, file.size.toString(), file.path, muid)
                fileuploadModel.fileSizeReadable = Utils.humanReadableByteCount(file.size, true)
                fileuploadModel.documentType = FuguAppConstant.DocumentType.FILE.toString()

                copingFileToLocal(fileuploadModel, FuguAppConstant.DOC_FOLDER, Uri.parse(file.uri))
            }
            Constant.REQUEST_CODE_TAKE_IMAGE -> if (resultCode == Activity.RESULT_OK) {
                val path = CommonData.getTime()
                val imageFile = ImageFile()
                imageFile.path = path
                imageFile.destinationPath = path
                imageFile.muid = CommonData.getImageMuid()
                imageFile.size = File(path).length()
                imageFile.name = Utils.extractFileNameWithSuffix(path)
                compressImage(imageFile)
            }

        }
    }


    fun openScreenFromSheet(id: Int) {
        when (id) {
            R.id.llCamera -> openCamera()
            R.id.llGallery -> {
                val intent1 = Intent(this, ImagePickActivity::class.java)
                startActivityForResult(intent1, Constant.REQUEST_CODE_PICK_IMAGE)
            }
            R.id.llAudio -> {
                val intent3 = Intent(this, AudioPickActivity::class.java)
                startActivityForResult(intent3, Constant.REQUEST_CODE_PICK_AUDIO)
            }
            R.id.llVideo -> {
                val intent2 = Intent(this, VideoPickActivity::class.java)
                startActivityForResult(intent2, Constant.REQUEST_CODE_PICK_VIDEO)
            }
            R.id.llFiles -> {
                val intent4 = Intent(this, NormalFilePickActivity::class.java)
                intent4.putExtra(
                    NormalFilePickActivity.SUFFIX, arrayOf(
                        "txt", "xlsx", "xls", "doc", "docX", "ppt", ".pptx", "pdf",
                        "ODT", "apk", "zip", "CSV", "SQL", "PSD"
                    )
                )
                startActivityForResult(intent4, Constant.REQUEST_CODE_PICK_FILE)
            }
            else -> {
            }
        }
    }

    private fun openCamera() {
        if (imageUtils == null) imageUtils = ImageUtils(this)
        val isGranted = EasyPermissions.hasPermissions(
            this, "android.permission.CAMERA",
            "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"
        )
        isCameraPermission = true
        if (isGranted) {
            imageUtils!!.startCamera()
        } else {
            EasyPermissions.requestPermissions(
                this,
                getString(R.string.vw_rationale_storage),
                FuguAppConstant.RC_OPEN_CAMERA,
                "android.permission.CAMERA",
                "android.permission.READ_EXTERNAL_STORAGE",
                "android.permission.WRITE_EXTERNAL_STORAGE"
            )
        }
    }

    private fun getDropdownData(isIssueType: Boolean, text: String) {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                .add("lang", "en")
                .add("reference", "Issue")
                .add(
                    Constants.BUSINESS_ID,
                    HippoApplication.getInstance().userData.businessId.toString()
                )
                .add("text", text)
                .build()

            if (isIssueType) {
                commonParams.map[Constants.TYPE] = "Issue Type"
            } else {
                commonParams.map[Constants.TYPE] = "Issue Priority"
            }

            Logger.apiRequest("/api/erpnext/search", Gson().toJson(commonParams.map))

            RestClient.getApiInterface().erpNextSearch(commonParams.map)
                .enqueue(object : ResponseResolver<TicketPriorityOptionsData>(this, false, true) {
                    override fun success(searchResponse: TicketPriorityOptionsData) {
                        Logger.apiResponse("/api/erpnext/search", "")
                        var result: ArrayList<Result> = searchResponse.data.results

                        if (isIssueType) {
                            if (showdropdownIssue) {
                                issueList.clear()
                                for (i in 0 until searchResponse.data.results.size) {
                                    issueList.add(searchResponse.data.results[i].value)
                                }
                                issueAdapter = ArrayAdapter<String>(
                                    this@CreateTicketActivity,
                                    android.R.layout.simple_selectable_list_item,
                                    issueList
                                )
                                issueTypeACTV.setAdapter(issueAdapter)
                                issueTypeACTV.setEnoughFilter(true)
                                issueTypeACTV.showDropDown()
                            }
                        } else {
                            if (showdropdownPriority) {
                                priorityList.clear()
                                for (i in 0 until searchResponse.data.results.size) {
                                    priorityList.add(searchResponse.data.results[i].value)
                                }
                                priorityAdapter = ArrayAdapter<String>(
                                    this@CreateTicketActivity,
                                    android.R.layout.simple_selectable_list_item,
                                    priorityList
                                )
                                priorityACTV.setAdapter(priorityAdapter)
                                priorityACTV.setEnoughFilter(true)
                                priorityACTV.showDropDown()
                            }

                        }


//                            openBottomSheetOption(result, isIssueType)
                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("/api/erpnext/search", error.message)
                        Log.e("error", "error")
                    }
                })
        } else {
            Toast.makeText(
                this,
                getString(R.string.fugu_unable_to_connect_internet),
                Toast.LENGTH_SHORT
            ).show()
        }
    }

//    private fun openBottomSheetOption(result: ArrayList<Result>, issueType: Boolean) {
//        if (result != null && result.size > 0) {
//            bottomSheetTicketFragment = BottomSheetTicketFragment(issueType, result, this@CreateTicketActivity)
//            bottomSheetTicketFragment.show(supportFragmentManager, bottomSheetTicketFragment.getTag())
//        }
//    }
//
//    fun closeBottomSheet() {
//        bottomSheetTicketFragment.dismiss()
//    }

    private fun getUserData() {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add(Constants.USER_ID, conversation?.getUserId())
                .add(Constants.CHANNEL_ID, conversation?.channelId)
                .build()
            Logger.apiRequest("api/users/getUserDetails", Gson().toJson(commonParams.map))

            RestClient.getApiInterface().getUserDetails(commonParams.map)
                .enqueue(object : ResponseResolver<UserDetailsResponse>(this, true, false) {
                    override fun success(userDetailsResponse: UserDetailsResponse) {
                        Logger.apiResponse("api/users/getUserDetails", "")
                        try {
                            userdetail = userDetailsResponse
                            this@CreateTicketActivity.emailET.setText(userDetailsResponse.data[0].email)

                            if (userDetailsResponse.data[0].email.isEmpty()) {
                                this@CreateTicketActivity.emailET.isFocusableInTouchMode = true
                                this@CreateTicketActivity.emailET.isFocusable = true
                            } else {
                                this@CreateTicketActivity.emailET.isFocusableInTouchMode = false
                                this@CreateTicketActivity.emailET.isFocusable = false
//                                    checkAndCreateCustomer(userDetailsResponse.data[0].fullName, userDetailsResponse.data[0].email, true);
                            }

                            if (!userDetailsResponse.data[0].fullName.isEmpty() && !userDetailsResponse.data[0].fullName.equals(
                                    "visitor",
                                    true
                                )
                            ) {
                                this@CreateTicketActivity.nameET.setText(userDetailsResponse.data[0].fullName)
                                this@CreateTicketActivity.nameET.isFocusableInTouchMode = true
                                this@CreateTicketActivity.nameET.isFocusable = true
//                                    checkAndCreateCustomer(userDetailsResponse.data[0].fullName, userDetailsResponse.data[0].email, true);

                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                            Logger.apiFailed("api/users/getUserDetails", e.localizedMessage)
                        }

                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("api/users/getUserDetails", error.message)
                        Log.e("error", "error")
                    }
                })
        } else {
            Toast.makeText(
                this,
                getString(R.string.fugu_unable_to_connect_internet),
                Toast.LENGTH_SHORT
            ).show()
        }
    }

    private fun checkAndCreateCustomer(name: String?, email: String?, fromUserData: Boolean) {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add("lang", "en")
                .add("customer_name", name)
                .add("customer_email", email)
                .build()
            Logger.apiRequest("api/erpnext/checkAndCreateCustomer", Gson().toJson(commonParams.map))

            RestClient.getApiInterface().checkAndCreateCustomer(commonParams.map)
                .enqueue(object : ResponseResolver<CreateCustomerResponse>(this, true, true) {
                    override fun success(createCustomerResponse: CreateCustomerResponse) {
                        Logger.apiResponse("api/erpnext/checkAndCreateCustomer", "")
                        try {
                            if (fromUserData) {
                                this@CreateTicketActivity.nameET.setText(createCustomerResponse.data.customerName)
                                if (!createCustomerResponse.data.customerName.isEmpty() && !createCustomerResponse.data.customerName.equals(
                                        "visitor",
                                        true
                                    )
                                ) {
                                    checkAndCreated = true
                                    this@CreateTicketActivity.nameET.isFocusableInTouchMode = false
                                    this@CreateTicketActivity.nameET.isFocusable = false
                                }
                            } else {
                                createTicket()
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                            Logger.apiFailed(
                                "api/erpnext/checkAndCreateCustomer",
                                e.localizedMessage
                            )
                        }

                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("api/erpnext/checkAndCreateCustomer", error.message)
                        Log.e("error", "error")
                    }
                })
        } else {
            Toast.makeText(
                this,
                getString(R.string.fugu_unable_to_connect_internet),
                Toast.LENGTH_SHORT
            ).show()
        }
    }

    override fun onPermissionsDenied(p0: Int, perms: MutableList<String>) {
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            AppSettingsDialog.Builder(this).build().show()
        } else {
            Toast.makeText(this, "Please grant permission", Toast.LENGTH_SHORT).show()
            //finish();
        }
    }

    override fun onPermissionsGranted(p0: Int, p1: MutableList<String>) {
        if (isCameraPermission) {
            if (imageUtils == null) imageUtils = ImageUtils(this)
            imageUtils!!.startCamera()
            isCameraPermission = false
        }
    }

    fun compressImage(actualFile: ImageFile) {
        try {
            var screenWidth = resources.displayMetrics.widthPixels
            if (screenWidth > 1024) screenWidth = 1024
            Compressor()
                .setMaxWidth(screenWidth.toFloat())
                .setMaxHeight(screenWidth.toFloat())
                .setQuality(75)
                .setCompressFormat(Bitmap.CompressFormat.JPEG)
                .setListener { file, path, imageFile, integers ->
                    showImageDialog(
                        this,
                        file,
                        path,
                        imageFile,
                        integers
                    )
                }
                .compressToFile(this, File(actualFile.path), actualFile)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    private fun showImageDialog(
        activity: Context,
        imgUrl: File,
        image: String,
        imageFile: ImageFile,
        integers: ArrayList<Int>
    ) {
        try {
            val dialog = Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar)
            //setting custom layout to dialog
            dialog.setContentView(R.layout.image_dialog)
            val dialogWindow = dialog.window
            val layoutParams = dialogWindow!!.attributes
            layoutParams.dimAmount = 1.0f
            dialogWindow.attributes.windowAnimations = R.style.CustomDialog
            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
            dialog.setCancelable(true)
            dialog.setCanceledOnTouchOutside(false)
            val ivImage: ZoomageView = dialog.findViewById(R.id.ivImage)
            val options = RequestOptions()
                .centerCrop()
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .placeholder(R.drawable.hippo_placeholder)
                .error(R.drawable.hippo_placeholder)
                .fitCenter()
                .priority(Priority.HIGH)
                .transforms(CenterCrop(), RoundedCorners(3))
            Glide.with(activity).asBitmap()
                .apply(options)
                .load(imgUrl)
                .into(ivImage)
            val tvCross = dialog.findViewById<TextView>(R.id.tvCross)
            val ivSend = dialog.findViewById<ImageView>(R.id.ivSend1)
            ivSend.visibility = View.VISIBLE
            ivSend.setOnClickListener {
                var muid = Utils.getMuid(imageFile.name)
                if (!TextUtils.isEmpty(imageFile.muid)) {
                    muid = imageFile.muid
                }
                val fileuploadModel =
                    FileuploadModel(imageFile.name, imageFile.size.toString(), imageFile.path, muid)
                fileuploadModel.fileSizeReadable =
                    Utils.humanReadableByteCount(imageFile.size, true)
                fileuploadModel.documentType = FuguAppConstant.DocumentType.IMAGE.toString()
                fileuploadModel.dimns = integers
                fileuploadModel.muid = imageFile.muid
                fileuploadModel.setIsChat(false)

                uploadFile(fileuploadModel)
                dialog.dismiss()
            }
            tvCross.setOnClickListener { dialog.dismiss() }
            dialog.show()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    private fun uploadFile(fileuploadModel: FileuploadModel) {
        fileuploadModel.setIsChat(false)

        var fileuploadModels = Gson().fromJson<ArrayList<FileuploadModel?>>(
            Prefs.with(this).getString(FuguAppConstant.KEY, ""), fileuploadType
        )

        if (fileuploadModels == null) fileuploadModels = ArrayList()
        fileuploadModels.add(fileuploadModel)
        val data = Gson().toJson(fileuploadModels, fileuploadType)
        //Log.e(TAG, "data = " + data);
        Prefs.with(this).save(FuguAppConstant.KEY, data)
        if (!isMyServiceRunning(UploadingService::class.java)) {
            val intent = Intent(this, UploadingService::class.java)
            intent.action = "start"
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                startForegroundService(intent)
            } else {
                startService(intent)
            }
        } else {
            //ToastUtil.getInstance(this).showToast("Already running");
        }
    }

    private fun copingFileToLocal(fileuploadModel: FileuploadModel, folderType: String) {
        copingFileToLocal(fileuploadModel, folderType, null);
    }

    private fun copingFileToLocal(
        fileuploadModel: FileuploadModel,
        folderType: String,
        fileUri: Uri?
    ) {
        LoadingBox.showOn(this)
        fileuploadModel.setIsChat(false)

        try {
            FileManager.getInstance().copyFile(
                this,
                fileuploadModel.filePath,
                FuguAppConstant.FOLDER_TYPE[folderType],
                fileuploadModel,
                fileUri,
                object : FileManager.FileCopyListener {
                    override fun onCopingFile(flag: Boolean, fileuploadModel: FileuploadModel) {
                        uploadFile(fileuploadModel)
                        LoadingBox.hide()
                    }

                    override fun largeFileSize() {
                        showErrorMessage(
                            getString(
                                R.string.hippo_large_file,
                                Utils.humanReadableSize(
                                    HippoApplication.getInstance().userData.maxFileSize,
                                    true
                                )
                            ), "OK"
                        )
                        LoadingBox.hide()
                    }

                    override fun onError() {
                        showErrorMessage(getString(R.string.hippo_something_wrong), "OK")
                        LoadingBox.hide()
                    }
                })
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
            LoadingBox.hide()
        }
    }

}
