package com.hippoagent.utils;

import android.app.DatePickerDialog;
import android.app.DatePickerDialog.OnDateSetListener;
import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.fragment.app.DialogFragment;

import com.hippoagent.R;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

/**
 * Created by gurmail on 12/14/16.
 */

public class DatePickerFragment extends DialogFragment {
    OnDateSetListener ondateSet;
    TimePickerDialog.OnTimeSetListener onTimeSetListener;
    public static final int TYPE_DATE_PICKER = 1;
    public static final int TYPE_TIME_PICKER = 2;

    public DatePickerFragment() {
    }

    public void setCallBack(OnDateSetListener ondate) {
        ondateSet = ondate;
    }

    public void setTimecallBack(TimePickerDialog.OnTimeSetListener onTimeSetListener) {
        this.onTimeSetListener = onTimeSetListener;
    }

    private int year, month, day;
    private int hourOfDay, minute;
    private int viewType;
    private int minDate = 60;

    private boolean isPastDate = false;

    @Override
    public void setArguments(Bundle args) {
        super.setArguments(args);
        year = args.getInt("year");
        month = args.getInt("month");
        day = args.getInt("day");
        hourOfDay = args.getInt("hourOfDay");
        minute = args.getInt("minute");
        viewType = args.getInt("type");
        if (args.containsKey("isPastDate"))
            isPastDate = args.getBoolean("isPastDate");
        if (args.containsKey("minDate")) {
            minDate = args.getInt("minDate");
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (viewType == 1) {
            // DatePickerDialog THEME_DEVICE_DEFAULT_DARK
            DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(),
                    R.style.HippoDialogTheme, ondateSet, year, month, day);

            //datePickerDialog.updateDate(year, month, day);

            try {
                datePickerDialog.setButton(DatePickerDialog.BUTTON_POSITIVE, "OK", datePickerDialog);
                datePickerDialog.setButton(DatePickerDialog.BUTTON_NEGATIVE, "CANCEL", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            } catch (Exception e) {

            }




//            if (!isPastDate) {
//                datePickerDialog.getDatePicker().setMinDate(System.currentTimeMillis() - 1000);
//            }
            if (minDate != -1) {
                long mintime = DateTime.now(DateTimeZone.getDefault()).minusDays(minDate).toDate().getTime();
                datePickerDialog.getDatePicker().setMinDate(mintime);
            }

            datePickerDialog.updateDate(year, month, day);

            datePickerDialog.getDatePicker().setMaxDate(System.currentTimeMillis());

            return datePickerDialog;
        } else {
            TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), R.style.TimePickerDialog, onTimeSetListener,
                    hourOfDay, minute, false);
            timePickerDialog.updateTime(hourOfDay, minute);

            return timePickerDialog;
        }
    }

}
