package com.hippoagent.utils;

import android.content.Context;

import androidx.core.content.ContextCompat;

import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hippoagent.R;

import java.io.File;

/**
 * Created by gurmail on 29/01/19.
 *
 * @author gurmail
 */
public class LoadImageFile {

    private static LoadImageFile instance;
    private LoadImageFile() {

    }

    public static LoadImageFile getInstance() {
        if(instance == null) {
            synchronized (LoadImageFile.class) {
                if(instance == null) {
                    instance = new LoadImageFile();
                }
            }
        }
        return instance;
    }
    public void loadImage(Context context, String url, ImageView ivImage) {
        loadImage(context, url, R.drawable.placeholder, ivImage);
    }
    public void loadImage(Context context, String url, int placeHolder, ImageView ivImage) {
        loadImage(context, url, placeHolder, ivImage, 0);
    }
    public void loadImage(Context context, int url, int placeHolder, ImageView ivImage, int position) {
        RequestOptions myOptions = RequestOptions
                .circleCropTransform()
                .placeholder(placeHolder)
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(placeHolder);

        Glide.with(context).load(url)
                .apply(myOptions)
                .into(ivImage);

    }
    public void loadImage(Context context, String url, int placeHolder, ImageView ivImage, int position) {
        RequestOptions myOptions;
        switch (position) {
            case 1:
                myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                        .placeholder(ContextCompat.getDrawable(context, placeHolder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(context, placeHolder));
                break;
            case 2:
                myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                        .placeholder(ContextCompat.getDrawable(context, placeHolder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(context, placeHolder));

                Glide.with(context).load(new File(url))
                        .apply(myOptions)
                        .into(ivImage);
                break;
            case 3:
                myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                        .placeholder(ContextCompat.getDrawable(context, placeHolder))
                        .dontAnimate()
                        .centerCrop()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(context, placeHolder));
                break;
            case 4:
                myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                        .placeholder(ContextCompat.getDrawable(context, placeHolder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(context, placeHolder));
                break;
            default:
                myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                        .placeholder(ContextCompat.getDrawable(context, placeHolder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(context, placeHolder));
                break;
        }



        if(position != 2) {
            Glide.with(context).load(url)
                    .apply(myOptions)
                    .into(ivImage);
        }

    }
}
