package com.hippoagent.utils;

import android.app.IntentService;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.CampaignActivity;
import com.hippoagent.activities.ChannelInfoActivity;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoChatActivity;
import com.hippoagent.customer.HippoConversation;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.UserCommonData;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.fcm.SendReplyMessage;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Conversation;
import com.google.gson.Gson;

import org.json.JSONObject;

import static com.hippoagent.activities.FuguChatActivity.pushChannelId;
import static com.hippoagent.datastructure.FuguAppConstant.NOTIFICATION_TAPPED;

/**
 * Created by Bhavya Rattan on 26/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class PushIntentService extends IntentService {

    private static final String TAG = "PushIntentService";

    public PushIntentService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        String message = (String) PushHandler.Reply.INSTANCE.getReplyMessage(intent);
        if (!TextUtils.isEmpty(message)) {
            Log.d(TAG, "Message := " + message);

            try {
                String payload = intent.getStringExtra("json");
                JSONObject data = new JSONObject(payload);
                new SendReplyMessage(this).sendMessage(data, message);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Intent notificationIntent = null;
        try {
            String payload = intent.getStringExtra("json");
            JSONObject data = new JSONObject(payload);
            boolean isPromotional = intent.getBooleanExtra("is_announcement_push", false);
            if (isPromotional) {
                handleAnnouncementPush(data);
                return;
            }
            String transactionId = data.optString("chat_transaction_id", "");
            int channedId = data.optInt("channel_id", -1);
            long labelId = intent.getLongExtra("labelId", -1l);
            int userId = data.optInt("user_id", -1);
            int disableReply = data.optInt("disable_reply", 0);
            Integer chat_type = null;
            if (data.has("chat_type"))
                chat_type = data.getInt("chat_type");
            String label = data.optString("label", "User");
            boolean isRecreated = data.optBoolean("is_recreated", false);
            boolean isPromotionalPush = data.optBoolean("is_promotional", false);
            boolean isO2o = false;
            if (data.has("chat_type") && data.getInt("chat_type") == 2 && data.getInt("channel_type") == 9)
                isO2o = true;

            Conversation conversation = new Conversation();
            conversation.setChannelId(channedId);
            if (chat_type != null)
                conversation.setChatType(chat_type);
            conversation.setLabel(label);
            if (isRecreated) {
                String messageData = data.optString("push_message");
                Log.e(TAG, "messageData = " + messageData);
                conversation.setPushMessage(messageData);
            }

            conversation.setUserId(userId);
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(disableReply);

            // TODO: 17/12/20 below if condition for the customer push.
            if (!TextUtils.isEmpty(transactionId) && false) {
                Long channedid = data.optLong("channel_id", -1);
                HippoConversation conversation1 = new HippoConversation();
                conversation1.setChannelId(channedid);
                conversation1.setEnUserId(UserCommonData.getUserDetails().getData().getEn_user_id());
                conversation1.setUserId(UserCommonData.getUserDetails().getData().getUserId());
                conversation1.setLabel(label);
                if (chat_type != null)
                    conversation1.setChatType(chat_type);
                conversation1.setDisableReply(disableReply);


                notificationIntent = new Intent(this, HippoChatActivity.class);
                notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation1, HippoConversation.class));
                notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
            } else {
                if (HippoConfig.getInstance() != null && HippoApplication.getInstance().getUserData() != null
                        && HippoConfig.getInstance().isHippoInit()) {
                    notificationIntent = new Intent(this, FuguChatActivity.class);
                    if (chat_type != null && chat_type == MessageType.P2P_CHAT.getOrdinal()) {
                        notificationIntent.putExtra("is_p2p_chat", true);
                    } else {
                        notificationIntent.putExtra("is_p2p_chat", false);
                    }
                    if (channedId < 0 && labelId < 0) {
                        notificationIntent = new Intent(this, ChannelInfoActivity.class);
                        String title = label;
                        if (TextUtils.isEmpty(title))
                            title = Restring.getString(this, R.string.fugu_support);
                        notificationIntent.putExtra("title", title);
                        notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                        startActivity(notificationIntent);
                    }
                    if (pushChannelId > 0) {
                        Intent mIntent = new Intent(NOTIFICATION_TAPPED);
                        notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                        LocalBroadcastManager.getInstance(this).sendBroadcast(mIntent);
                        return;
                    } else if (channedId > 0) {
                        notificationIntent = new Intent(this, FuguChatActivity.class);
                        notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                        notificationIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    } else {
                        PackageManager pm = this.getPackageManager();
                        notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                        notificationIntent.putExtra("startChatActivity", true);
                        notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                    }
                } else {
                    PackageManager pm = this.getPackageManager();
                    notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                    notificationIntent.putExtra("startChatActivity", true);
                    notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        startActivity(notificationIntent);
    }


    private void handleAnnouncementPush(JSONObject data) {


        //
        Intent notificationIntent;
        if (HippoConfig.getInstance() != null) {
            Intent broadcastIntent = new Intent(this, CampaignActivity.class);
            broadcastIntent.putExtra("is_promotional_push", true);
            broadcastIntent.putExtra("is_announcement_push", true);
            broadcastIntent.putExtra("dataMessage", data.toString());
            broadcastIntent.putExtra("isFromPush", true);
            broadcastIntent.putExtra("message", data.toString());
            broadcastIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(broadcastIntent);
        } else {
            PackageManager pm = this.getPackageManager();
            notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
            notificationIntent.putExtra("is_announcement_push", true);
            startActivity(notificationIntent);
        }
    }

    private void clearNotification(int channelId) {
        try {
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
            NotificationUtils.clearNotifications(this, channelId);
            CommonData.removeNotificationChannel(channelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
