package com.hippoagent.utils.filePicker.activity;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.OpenableColumns;
import android.util.Log;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


import com.hippoagent.BuildConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filePicker.Constant;
import com.hippoagent.utils.filePicker.DividerListItemDecoration;
import com.hippoagent.utils.filePicker.FileManager;
import com.hippoagent.utils.filePicker.FileUtils;
import com.hippoagent.utils.filePicker.Util;
import com.hippoagent.utils.filePicker.adapter.NormalFilePickAdapter;
import com.hippoagent.utils.filePicker.adapter.OnSelectStateListener;
import com.hippoagent.utils.filePicker.filter.FileFilter;
import com.hippoagent.utils.filePicker.filter.callback.FilterResultCallback;
import com.hippoagent.utils.filePicker.filter.entity.Directory;
import com.hippoagent.utils.filePicker.filter.entity.NormalFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;


/**
 * Created by Vincent Woo
 * Date: 2016/10/26
 * Time: 10:14
 */

public class NormalFilePickActivity extends BaseActivity {

    public static String id1 = "test_channel_01";
    private static final String TAG = NormalFilePickActivity.class.getSimpleName();
    public static final int DEFAULT_MAX_NUMBER = 9;
    private static final int REQUEST_CODE = 6384;
    public static final String SUFFIX = "Suffix";
    private int mMaxNumber;
    private RecyclerView mRecyclerView;
    private NormalFilePickAdapter mAdapter;
    private ArrayList<NormalFile> mSelectedList = new ArrayList<>();
    private ProgressBar mProgressBar;
    private String[] mSuffix;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            openFileManager();
            return;
        }
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                loadData();
            }
        }, 2000);

    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.vw_activity_image_pick);

        mMaxNumber = getIntent().getIntExtra(Constant.MAX_NUMBER, DEFAULT_MAX_NUMBER);
        mSuffix = getIntent().getStringArrayExtra(SUFFIX);
        initView();
    }

    private void initView() {

        myToolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);
        String title = Restring.getString(NormalFilePickActivity.this, R.string.hippo_doc_picker);
        setToolbar(myToolbar, title);
        mProgressBar = findViewById(R.id.pb_file_pick);
        mProgressBar.setVisibility(View.VISIBLE);

        mRecyclerView = findViewById(R.id.rv_image_pick);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(layoutManager);
        mRecyclerView.addItemDecoration(new DividerListItemDecoration(this,
                LinearLayoutManager.VERTICAL, R.drawable.vw_divider_rv_file));
        mAdapter = new NormalFilePickAdapter(this, mMaxNumber);
        mRecyclerView.setAdapter(mAdapter);

        mAdapter.setOnSelectStateListener(new OnSelectStateListener<NormalFile>() {
            @Override
            public void OnSelectStateChanged(boolean state, NormalFile file) {
                if (file == null) {
                    openFileManager();
                } else {
                    mSelectedList.add(file);
                    Intent intent = new Intent();
                    intent.putParcelableArrayListExtra(Constant.RESULT_PICK_FILE, mSelectedList);
                    setResult(RESULT_OK, intent);
                    finish();
                }
            }
        });


    }

    private void loadData() {

        FileFilter.getFiles(this, new FilterResultCallback<NormalFile>() {
            @Override
            public void onResult(List<Directory<NormalFile>> directories) {
                // Refresh folder list
                if (isNeedFolderList) {
                    ArrayList<Directory> list = new ArrayList<>();
                    Directory all = new Directory();
                    all.setName(getResources().getString(R.string.vw_all));
                    list.add(all);
                    list.addAll(directories);
                    mFolderHelper.fillData(list);
                }
                refreshData(directories);
            }
        }, mSuffix);
    }

    private void refreshData(List<Directory<NormalFile>> directories) {
        mProgressBar.setVisibility(View.GONE);
        List<NormalFile> list = new ArrayList<>();
        for (Directory<NormalFile> directory : directories) {
            list.addAll(directory.getFiles());
        }

        for (NormalFile file : mSelectedList) {
            int index = list.indexOf(file);
            if (index != -1) {
                list.get(index).setSelected(true);
            }
        }

        mAdapter.refresh(list);
    }


    private void openFileManager() {
//        // Use the GET_CONTENT intent from the utility class
//        Intent target = FileUtils.createGetContentIntent();
//        // Create the chooser Intent
//        Intent intent = Intent.createChooser(
//                target, "");
//        try {
//            startActivityForResult(intent, REQUEST_CODE);
//        } catch (ActivityNotFoundException e) {
//            // The reason for the existence of aFileChooser
//        }

        final Intent intent = new Intent();
        intent.setType("*/*");


        intent.setAction(Intent.ACTION_GET_CONTENT);
//        intent.addCategory(Intent.CATEGORY_OPENABLE);

        intent.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        try {
            startActivityForResult(intent, REQUEST_CODE);
            return;
        } catch (ActivityNotFoundException anfe) {
            Log.w(TAG, "couldn't complete ACTION_OPEN_DOCUMENT, no activity found. falling back.");
        }

        intent.setAction(Intent.ACTION_GET_CONTENT);

        try {
            startActivityForResult(intent, REQUEST_CODE);
        } catch (ActivityNotFoundException anfe) {
            Log.w(TAG, "couldn't complete ACTION_GET_CONTENT intent, no activity found. falling back.");
            Toast.makeText(this, "AttachmentManager_cant_open_media_selection", Toast.LENGTH_LONG).show();
        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUEST_CODE && resultCode == RESULT_OK && data != null && data.getData() != null) {
            try {
                Uri uri = data.getData();
                String path = FileUtils.getPath(this, uri);

                if (path == null) {
                    path = getFilePath(this, uri);
                }


                NormalFile file = new NormalFile();
                String fileName = Utils.extractFileNameWithoutSuffix(path);
                file.setPath(path);
                file.setUri(uri.toString());
                file.setName(fileName);
                file.setSize(new File(path).length());

                mSelectedList.add(file);
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra(Constant.RESULT_PICK_FILE, mSelectedList);
                setResult(RESULT_OK, intent);
                finish();
            } catch (Exception e) {
                if (BuildConfig.DEBUG)
                    e.printStackTrace();

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
                    finish();

            }
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
                finish();
        }
    }

    /**
     * for API 26+ create notification channels
     */
    private void createchannel() {
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            NotificationManager nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

            NotificationChannel mChannel = new NotificationChannel(id1,
                    ("Testing"),  //name of the channel
                    NotificationManager.IMPORTANCE_LOW);   //importance level
            //important level: default is is high on the phone.  high is urgent on the phone.  low is medium, so none is low?
            // Configure the notification channel.
            mChannel.setDescription("Testing description");
            mChannel.enableLights(true);
            // Sets the notification light color for notifications posted to this channel, if the device supports this feature.
            mChannel.setShowBadge(true);
            nm.createNotificationChannel(mChannel);
        }
    }


    public static String createCopyAndReturnRealPath(
            @NonNull Context context, @NonNull Uri uri) {
        final ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null)
            return null;

        // Create file path inside app's data dir
        String filePath = context.getApplicationInfo().dataDir + File.separator
                + System.currentTimeMillis();

        File file = new File(filePath);
        try {
            InputStream inputStream = contentResolver.openInputStream(uri);
            if (inputStream == null)
                return null;

            OutputStream outputStream = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len;
            while ((len = inputStream.read(buf)) > 0)
                outputStream.write(buf, 0, len);

            outputStream.close();
            inputStream.close();
        } catch (IOException ignore) {
            return null;
        }

        return file.getAbsolutePath();
    }


    private static String getFilePath(Context context, Uri fileUri) {
        try {
            String fileName = "temp." + getFileExtension(context, fileUri);
            File file = new File(Utils.getDirectoryPath(context, FOLDER_TYPE.get("file")), fileName);

            if (!file.getParentFile().exists())
                file.getParentFile().mkdirs();

            if (!file.exists()) {
                file.createNewFile();
            }

            InputStream streem = context.getContentResolver().openInputStream(fileUri);
            OutputStream outStreem = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = streem.read(buffer)) != -1) {
                outStreem.write(buffer, 0, bytesRead);
            }

            outStreem.close();
            streem.close();

            return file.getPath();
        } catch (
                Exception e) {
            e.printStackTrace();
        }


        return null;
    }


    private static String getFileExtension(Context activity, Uri uri) {
        String extension = "";
        Cursor cursor = activity.getContentResolver().query(uri, null, null, null, null);
        try {
            if (cursor != null && cursor.moveToFirst()) {
                String extensions[] = cursor.getString(cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME)).split("\\.");
                extension = extensions[extensions.length - 1].toLowerCase();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            cursor.close();
        }
        return extension;
    }

}
