package com.hippoagent.utils.loadingBox;

import android.app.Activity;
import android.app.Dialog;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.langs.Restring;
import com.hippoagent.utils.Log;


/**
 * Class that holds ready to use dialogs
 */
public class LoadingBox {

    private static Dialog progressDialog;
    private static TextView tvProgress;
    private static TextView innerProgress;

    /**
     * Shows the progress dialog
     *
     * @param activity
     * @return the {@link TextView} on which progress has to be set
     */
    public static void showOn(Activity activity) {
        Log.e("activity loderbox", activity + "");
        if(activity!=null)
        showOn(activity, Restring.getString(activity,R.string.fugu_loading));
    }

    /**
     * Method to show the progress dialog with a message
     *
     * @param activity
     * @param message
     * @return
     */
    public static void showOn(final Activity activity, final String message) {

        try {
            /* Check if the last instance is alive */
            if (progressDialog != null)
                if (progressDialog.isShowing()) {
                    tvProgress.setText(message);
                    return;
                }

            /*  Ends Here   */

            progressDialog = new Dialog(activity,
                    R.style.Theme_AppCompat_Translucent_Hippo);

            progressDialog.setContentView(R.layout.fugu_dialog_progress);

            tvProgress = (TextView) progressDialog
                    .findViewById(R.id.tvProgress);
            innerProgress = (TextView) progressDialog
                    .findViewById(R.id.progress);
//            tvProgress.setTypeface(Font.getRegular(context));
            tvProgress.setText(message);
            innerProgress.setText("");

            ((FuguAgentProgressWheel) progressDialog.findViewById(R.id.progress_wheel))
                    .spin();

            Window dialogWindow = progressDialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow
                    .getAttributes();
            layoutParams.dimAmount = 0.0f;
            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            progressDialog.setCancelable(false);
            progressDialog.setCanceledOnTouchOutside(false);

            progressDialog.show();

        } catch (Exception e) {
            e.printStackTrace();
            Log.e("PROGRESS DIALOG", "EXCEPTION: " + e.getMessage());
        }
    }

    public static void updateProgress(int percentage) {
        innerProgress.setText(Integer.toString(percentage) + "%");
    }

    /**
     * Dismisses the Progress Dialog
     */
    public static boolean hide() {
        return hide(null);
    }

    public static boolean hide(Canceled canceled) {

        Log.e("PROGRESS DIALOG", "DISMISSED");

        if (progressDialog != null)
            if (progressDialog.isShowing()) {

                try {
                    progressDialog.dismiss();
                } catch (Exception ex) {
                    Log.e("Dismiss Loading Dialog", ex.toString());
                }
                progressDialog = null;
                tvProgress = null;
                innerProgress = null;

                if(canceled != null)
                    canceled.onClosed();

                return true;
            }

        if(canceled != null)
            canceled.onClosed();

        return false;
    }

    public interface Canceled {
        void onClosed();
    }
}
