package faye;

import android.os.Handler;
import android.os.Message;

import com.hippoagent.utils.Log;

import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;

import java.net.URI;

/**
 * Created by Bhavya Rattan on 01/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */


public class FuguAgentWebSocket extends WebSocketClient {

    private static final String LOG_TAG = FuguAgentWebSocket.class.getSimpleName();

    public static final int ON_OPEN = 1;
    public static final int ON_CLOSE = 2;
    public static final int ON_MESSAGE = 3;
    public static final int ON_ERROR = 4;
    public static final int ON_PONG = 5;
    public static final int ON_NOT_CONNECTED = 6;

    private Handler messageHandler;

    //private Handler callingHandler;


    public FuguAgentWebSocket(URI serverUri, Handler handler) {
        super(serverUri);
        messageHandler = handler;
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        messageHandler.sendMessage(Message.obtain(messageHandler, ON_OPEN));
    }

    @Override
    public void onMessage(String s) {
        Log.v("Faye message", "Sending in faye ^%$^%$^%$^%$^$:   "+s);
        messageHandler.sendMessage(Message.obtain(messageHandler, ON_MESSAGE, s));
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        Log.i(LOG_TAG, "code: " + code + ", reason: "
                + reason + ", remote: " + remote);
        messageHandler.sendMessage(Message.obtain(messageHandler, ON_CLOSE));
    }

    @Override
    public void onError(Exception e) {
        e.printStackTrace();
        Log.e(LOG_TAG, "On FuguAgentWebSocket Error:" + e);
        messageHandler.sendMessage(
                Message.obtain(messageHandler, ON_NOT_CONNECTED));
    }

    @Override
    public void onClosing(int code, String reason, boolean remote) {
        super.onClosing(code, reason, remote);
        Log.i(LOG_TAG, "#code: " + code + " #reason: " + reason + " #remote: " + remote);
    }

    @Override
    public void setConnectionLostTimeout(int connectionLostTimeout) {
        super.setConnectionLostTimeout(connectionLostTimeout);
        Log.i(LOG_TAG, "connectionLostTimeout: " + connectionLostTimeout);
    }

    @Override
    protected void startConnectionLostTimer() {
        super.startConnectionLostTimer();
        Log.e(LOG_TAG, "On startConnectionLostTimer");
    }


    /*@Override
    public void reconnect() {
        super.reconnect();
        Log.e(LOG_TAG, "On reconnect");
    }*/

    @Override
    public boolean reconnectBlocking() throws InterruptedException {
        return super.reconnectBlocking();

    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        messageHandler.sendMessage(Message.obtain(messageHandler, ON_PONG, f));
        Log.e(LOG_TAG, "On onWebsocketPong");
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
        super.onWebsocketHandshakeReceivedAsClient(conn, request, response);
        Log.e(LOG_TAG, "On onWebsocketHandshakeReceivedAsClient");
    }

    //    @Override
//    public boolean reconnectBlocking() throws InterruptedException {
//        Log.e(LOG_TAG, "On reconnectBlocking");
//        return super.reconnectBlocking();
//    }
}
