/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.datapool.core;

import io.holunda.polyflow.datapool.core.DataPoolProperties;
import io.holunda.polyflow.datapool.core.business.CreateOrUpdateCommandHandler;
import io.holunda.polyflow.datapool.core.business.DataEntryAggregate;
import io.holunda.polyflow.datapool.core.business.upcaster.DataEntryCreatedEventUpcaster;
import io.holunda.polyflow.datapool.core.repository.FirstEventOnlyEventSourcingRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.WeakReferenceCache;
import org.axonframework.eventsourcing.EventCountSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataEntryAggregate.class, CreateOrUpdateCommandHandler.class, DataEntryCreatedEventUpcaster.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017\u00a8\u0006\u0014"}, d2={"Lio/holunda/polyflow/datapool/core/DataPoolCoreAxonConfiguration;", "", "()V", "dataEntryAggregateRepository", "Lorg/axonframework/eventsourcing/EventSourcingRepository;", "Lio/holunda/polyflow/datapool/core/business/DataEntryAggregate;", "eventStore", "Lorg/axonframework/eventsourcing/eventstore/EventStore;", "factory", "Lorg/axonframework/messaging/annotation/ParameterResolverFactory;", "dataEntryCache", "Lorg/axonframework/common/caching/Cache;", "dataEntryAggregateSnapshotterTriggerDefinition", "Lorg/axonframework/eventsourcing/SnapshotTriggerDefinition;", "snapshotter", "Lorg/axonframework/eventsourcing/Snapshotter;", "dataPoolProperties", "Lio/holunda/polyflow/datapool/core/DataPoolProperties;", "firstEventDataEntryAggregateRepository", "Companion", "polyflow-datapool-core"})
public class DataPoolCoreAxonConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DATA_ENTRY_REPOSITORY = "dataEntryEventSourcingRepository";
    @NotNull
    public static final String DATA_ENTRY_SNAPSHOTTER = "dataEntrySnapshotter";
    @NotNull
    public static final String DATA_ENTRY_CACHE = "dataEntryCache";

    @ConditionalOnProperty(name={"polyflow.core.data-entry.event-sourcing-repository-type"}, havingValue="io.holunda.polyflow.datapool.core.repository.FirstEventOnlyEventSourcingRepository")
    @Bean(value={"dataEntryEventSourcingRepository"})
    @NotNull
    public EventSourcingRepository<DataEntryAggregate> firstEventDataEntryAggregateRepository(@NotNull EventStore eventStore, @NotNull ParameterResolverFactory factory, @Qualifier(value="dataEntryCache") @NotNull Cache dataEntryCache, @Qualifier(value="dataEntrySnapshotter") @NotNull SnapshotTriggerDefinition dataEntryAggregateSnapshotterTriggerDefinition) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)dataEntryCache, (String)DATA_ENTRY_CACHE);
        Intrinsics.checkNotNullParameter((Object)dataEntryAggregateSnapshotterTriggerDefinition, (String)"dataEntryAggregateSnapshotterTriggerDefinition");
        EventSourcingRepository eventSourcingRepository = FirstEventOnlyEventSourcingRepository.Companion.builder(DataEntryAggregate.class).parameterResolverFactory(factory).cache(dataEntryCache).snapshotTriggerDefinition(dataEntryAggregateSnapshotterTriggerDefinition).eventStore(eventStore).build();
        Intrinsics.checkNotNullExpressionValue((Object)eventSourcingRepository, (String)"FirstEventOnlyEventSourc\u2026ventStore)\n      .build()");
        return eventSourcingRepository;
    }

    @ConditionalOnProperty(name={"polyflow.core.data-entry.event-sourcing-repository-type"}, havingValue="org.axonframework.eventsourcing.EventSourcingRepository", matchIfMissing=true)
    @Bean(value={"dataEntryEventSourcingRepository"})
    @NotNull
    public EventSourcingRepository<DataEntryAggregate> dataEntryAggregateRepository(@NotNull EventStore eventStore, @NotNull ParameterResolverFactory factory, @Qualifier(value="dataEntryCache") @NotNull Cache dataEntryCache, @Qualifier(value="dataEntrySnapshotter") @NotNull SnapshotTriggerDefinition dataEntryAggregateSnapshotterTriggerDefinition) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)dataEntryCache, (String)DATA_ENTRY_CACHE);
        Intrinsics.checkNotNullParameter((Object)dataEntryAggregateSnapshotterTriggerDefinition, (String)"dataEntryAggregateSnapshotterTriggerDefinition");
        EventSourcingRepository eventSourcingRepository = EventSourcingRepository.builder(DataEntryAggregate.class).parameterResolverFactory(factory).cache(dataEntryCache).snapshotTriggerDefinition(dataEntryAggregateSnapshotterTriggerDefinition).eventStore(eventStore).build();
        Intrinsics.checkNotNullExpressionValue((Object)eventSourcingRepository, (String)"builder(DataEntryAggrega\u2026ventStore)\n      .build()");
        return eventSourcingRepository;
    }

    @Bean(value={"dataEntrySnapshotter"})
    @NotNull
    public SnapshotTriggerDefinition dataEntryAggregateSnapshotterTriggerDefinition(@NotNull Snapshotter snapshotter, @NotNull DataPoolProperties dataPoolProperties) {
        Intrinsics.checkNotNullParameter((Object)snapshotter, (String)"snapshotter");
        Intrinsics.checkNotNullParameter((Object)dataPoolProperties, (String)"dataPoolProperties");
        return (SnapshotTriggerDefinition)new EventCountSnapshotTriggerDefinition(snapshotter, dataPoolProperties.getSnapshotThreshold());
    }

    @Bean(value={"dataEntryCache"})
    @NotNull
    public Cache dataEntryCache() {
        return (Cache)new WeakReferenceCache();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/holunda/polyflow/datapool/core/DataPoolCoreAxonConfiguration$Companion;", "Lmu/KLogging;", "()V", "DATA_ENTRY_CACHE", "", "DATA_ENTRY_REPOSITORY", "DATA_ENTRY_SNAPSHOTTER", "polyflow-datapool-core"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

