/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.datapool.core.business;

import io.holunda.camunda.taskpool.api.business.CreateDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.CreateOrUpdateDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.UpdateDataEntryCommand;
import io.holunda.polyflow.datapool.HelpersKt;
import io.holunda.polyflow.datapool.core.DeletionStrategy;
import io.holunda.polyflow.datapool.core.business.CreateOrUpdateCommandHandler;
import io.holunda.polyflow.datapool.core.business.DataEntryAggregate;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.messaging.MetaData;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/holunda/polyflow/datapool/core/business/CreateOrUpdateCommandHandler;", "", "eventSourcingRepository", "Lorg/axonframework/eventsourcing/EventSourcingRepository;", "Lio/holunda/polyflow/datapool/core/business/DataEntryAggregate;", "deletionStrategy", "Lio/holunda/polyflow/datapool/core/DeletionStrategy;", "(Lorg/axonframework/eventsourcing/EventSourcingRepository;Lio/holunda/polyflow/datapool/core/DeletionStrategy;)V", "createOrUpdate", "", "command", "Lio/holunda/camunda/taskpool/api/business/CreateOrUpdateDataEntryCommand;", "metaData", "Lorg/axonframework/messaging/MetaData;", "loadAggregate", "Ljava/util/Optional;", "Lorg/axonframework/modelling/command/Aggregate;", "id", "", "Companion", "polyflow-datapool-core"})
public class CreateOrUpdateCommandHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventSourcingRepository<DataEntryAggregate> eventSourcingRepository;
    @NotNull
    private final DeletionStrategy deletionStrategy;

    public CreateOrUpdateCommandHandler(@NotNull EventSourcingRepository<DataEntryAggregate> eventSourcingRepository, @NotNull DeletionStrategy deletionStrategy) {
        Intrinsics.checkNotNullParameter(eventSourcingRepository, (String)"eventSourcingRepository");
        Intrinsics.checkNotNullParameter((Object)deletionStrategy, (String)"deletionStrategy");
        this.eventSourcingRepository = eventSourcingRepository;
        this.deletionStrategy = deletionStrategy;
    }

    @CommandHandler
    public void createOrUpdate(@NotNull CreateOrUpdateDataEntryCommand command, @NotNull MetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Companion.getLogger().trace((Function0)new Function0<Object>(command){
            final /* synthetic */ CreateOrUpdateDataEntryCommand $command;
            {
                this.$command = $command;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Processing createOrUpdate command for " + this.$command.getDataIdentity();
            }
        });
        HelpersKt.ifPresentOrElse(this.loadAggregate(command.getDataIdentity()), (Function1)new Function1<Aggregate<DataEntryAggregate>, Unit>(command, this){
            final /* synthetic */ CreateOrUpdateDataEntryCommand $command;
            final /* synthetic */ CreateOrUpdateCommandHandler this$0;
            {
                this.$command = $command;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Aggregate<DataEntryAggregate> aggregate) {
                Intrinsics.checkNotNullParameter(aggregate, (String)"aggregate");
                UpdateDataEntryCommand updateCommand = new UpdateDataEntryCommand(this.$command.getDataEntryChange(), null, 2, null);
                CreateOrUpdateCommandHandler.Companion.getLogger().trace((Function0)new Function0<Object>(updateCommand){
                    final /* synthetic */ UpdateDataEntryCommand $updateCommand;
                    {
                        this.$updateCommand = $updateCommand;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Aggregate found. Updating it passing command " + this.$updateCommand;
                    }
                });
                aggregate.invoke(arg_0 -> createOrUpdate.2.invoke$lambda$0(updateCommand, this.this$0, arg_0));
            }

            private static final Unit invoke$lambda$0(UpdateDataEntryCommand $updateCommand, CreateOrUpdateCommandHandler this$0, DataEntryAggregate it) {
                Intrinsics.checkNotNullParameter((Object)$updateCommand, (String)"$updateCommand");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                it.handle($updateCommand, CreateOrUpdateCommandHandler.access$getDeletionStrategy$p(this$0));
                return Unit.INSTANCE;
            }
        }, (Function0<Unit>)((Function0)new Function0<Unit>(command, this){
            final /* synthetic */ CreateOrUpdateDataEntryCommand $command;
            final /* synthetic */ CreateOrUpdateCommandHandler this$0;
            {
                this.$command = $command;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CreateDataEntryCommand createCommand = new CreateDataEntryCommand(this.$command.getDataEntryChange(), null, 2, null);
                CreateOrUpdateCommandHandler.Companion.getLogger().trace((Function0)new Function0<Object>(this.$command){
                    final /* synthetic */ CreateOrUpdateDataEntryCommand $command;
                    {
                        this.$command = $command;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "No aggregate found. Creating a new data entry aggregate and passing command " + this.$command;
                    }
                });
                CreateOrUpdateCommandHandler.access$getEventSourcingRepository$p(this.this$0).newInstance(() -> createOrUpdate.3.invoke$lambda$0(createCommand));
            }

            private static final DataEntryAggregate invoke$lambda$0(CreateDataEntryCommand $createCommand) {
                Intrinsics.checkNotNullParameter((Object)$createCommand, (String)"$createCommand");
                return new DataEntryAggregate($createCommand);
            }
        }));
    }

    private Optional<Aggregate<DataEntryAggregate>> loadAggregate(String id) {
        Optional<Aggregate<DataEntryAggregate>> optional;
        try {
            Optional<Aggregate> optional2 = Optional.of(this.eventSourcingRepository.load(id));
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n      Optional.of(even\u2026epository.load(id))\n    }");
            optional = optional2;
        }
        catch (AggregateNotFoundException e) {
            Optional<Aggregate<DataEntryAggregate>> optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n      Optional.empty()\n    }");
            optional = optional3;
        }
        return optional;
    }

    public static final /* synthetic */ DeletionStrategy access$getDeletionStrategy$p(CreateOrUpdateCommandHandler $this) {
        return $this.deletionStrategy;
    }

    public static final /* synthetic */ EventSourcingRepository access$getEventSourcingRepository$p(CreateOrUpdateCommandHandler $this) {
        return $this.eventSourcingRepository;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/holunda/polyflow/datapool/core/business/CreateOrUpdateCommandHandler$Companion;", "Lmu/KLogging;", "()V", "polyflow-datapool-core"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

