/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.datapool.core.business;

import io.holunda.camunda.taskpool.api.business.CreateDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.DataEntryCreatedEvent;
import io.holunda.camunda.taskpool.api.business.DataEntryDeletedEvent;
import io.holunda.camunda.taskpool.api.business.DataEntryUpdatedEvent;
import io.holunda.camunda.taskpool.api.business.DataIdentityKt;
import io.holunda.camunda.taskpool.api.business.DeleteDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.MappersKt;
import io.holunda.camunda.taskpool.api.business.UpdateDataEntryCommand;
import io.holunda.polyflow.datapool.core.DeletionStrategy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.spring.stereotype.Aggregate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Aggregate(repository="dataEntryEventSourcingRepository", snapshotTriggerDefinition="dataEntrySnapshotter", cache="dataEntryCache")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0013H\u0017J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0014H\u0017R\u0012\u0010\u0006\u001a\u00020\u00078\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/holunda/polyflow/datapool/core/business/DataEntryAggregate;", "", "command", "Lio/holunda/camunda/taskpool/api/business/CreateDataEntryCommand;", "(Lio/holunda/camunda/taskpool/api/business/CreateDataEntryCommand;)V", "()V", "dataIdentity", "", "deleted", "", "handle", "", "Lio/holunda/camunda/taskpool/api/business/DeleteDataEntryCommand;", "deletionStrategy", "Lio/holunda/polyflow/datapool/core/DeletionStrategy;", "Lio/holunda/camunda/taskpool/api/business/UpdateDataEntryCommand;", "on", "event", "Lio/holunda/camunda/taskpool/api/business/DataEntryCreatedEvent;", "Lio/holunda/camunda/taskpool/api/business/DataEntryDeletedEvent;", "Lio/holunda/camunda/taskpool/api/business/DataEntryUpdatedEvent;", "Companion", "polyflow-datapool-core"})
public class DataEntryAggregate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @AggregateIdentifier
    private String dataIdentity;
    private boolean deleted;

    public DataEntryAggregate() {
    }

    @CommandHandler
    public DataEntryAggregate(@NotNull CreateDataEntryCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this();
        AggregateLifecycle.apply((Object)MappersKt.createdEvent((CreateDataEntryCommand)command));
    }

    @CommandHandler
    public void handle(@NotNull UpdateDataEntryCommand command, @Autowired @NotNull DeletionStrategy deletionStrategy) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)deletionStrategy, (String)"deletionStrategy");
        if (deletionStrategy.strictMode() && this.deleted) {
            String string = this.dataIdentity;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                string = null;
            }
            throw new AggregateDeletedException(string, "The data entry has already been deleted");
        }
        AggregateLifecycle.apply((Object)MappersKt.updatedEvent((UpdateDataEntryCommand)command));
    }

    @CommandHandler
    public void handle(@NotNull DeleteDataEntryCommand command, @Autowired @NotNull DeletionStrategy deletionStrategy) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)deletionStrategy, (String)"deletionStrategy");
        if (deletionStrategy.strictMode() && this.deleted) {
            String string = this.dataIdentity;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                string = null;
            }
            throw new AggregateDeletedException(string, "The data entry has already been deleted");
        }
        AggregateLifecycle.apply((Object)MappersKt.deletedEvent((DeleteDataEntryCommand)command));
    }

    @EventSourcingHandler
    public void on(@NotNull DataEntryCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.dataIdentity = DataIdentityKt.dataIdentityString((String)event.getEntryType(), (String)event.getEntryId());
        if (this.deleted) {
            this.deleted = false;
        }
        if (Companion.getLogger().isDebugEnabled()) {
            Companion.getLogger().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ DataEntryAggregate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Created " + string + ".";
                }
            });
        }
        if (Companion.getLogger().isTraceEnabled()) {
            Companion.getLogger().trace((Function0)new Function0<Object>(this, event){
                final /* synthetic */ DataEntryAggregate this$0;
                final /* synthetic */ DataEntryCreatedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Created " + string + " with: " + this.$event;
                }
            });
        }
    }

    @EventSourcingHandler
    public void on(@NotNull DataEntryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.deleted) {
            this.deleted = false;
        }
        if (Companion.getLogger().isDebugEnabled()) {
            Companion.getLogger().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ DataEntryAggregate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Updated " + string + ".";
                }
            });
        }
        if (Companion.getLogger().isTraceEnabled()) {
            Companion.getLogger().trace((Function0)new Function0<Object>(this, event){
                final /* synthetic */ DataEntryAggregate this$0;
                final /* synthetic */ DataEntryUpdatedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Updated " + string + " with: " + this.$event;
                }
            });
        }
    }

    @EventSourcingHandler
    public void on(@NotNull DataEntryDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Companion.getLogger().isDebugEnabled()) {
            Companion.getLogger().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ DataEntryAggregate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Deleted " + string + ".";
                }
            });
        }
        if (Companion.getLogger().isTraceEnabled()) {
            Companion.getLogger().trace((Function0)new Function0<Object>(this, event){
                final /* synthetic */ DataEntryAggregate this$0;
                final /* synthetic */ DataEntryDeletedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    String string = DataEntryAggregate.access$getDataIdentity$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataIdentity");
                        string = null;
                    }
                    return "Deleted " + string + " with: " + this.$event;
                }
            });
        }
        this.deleted = true;
    }

    public static final /* synthetic */ String access$getDataIdentity$p(DataEntryAggregate $this) {
        return $this.dataIdentity;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/holunda/polyflow/datapool/core/business/DataEntryAggregate$Companion;", "Lmu/KLogging;", "()V", "polyflow-datapool-core"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

