/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.urlresolver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.holunda.polyflow.urlresolver.FormUrlResolverProperties;
import io.holunda.polyflow.view.DataEntry;
import io.holunda.polyflow.view.FormUrlResolver;
import io.holunda.polyflow.view.ProcessDefinition;
import io.holunda.polyflow.view.Task;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/holunda/polyflow/urlresolver/PropertyBasedFormUrlResolver;", "Lio/holunda/polyflow/view/FormUrlResolver;", "props", "Lio/holunda/polyflow/urlresolver/FormUrlResolverProperties;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lio/holunda/polyflow/urlresolver/FormUrlResolverProperties;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "resolveUrl", "", "dataEntry", "Lio/holunda/polyflow/view/DataEntry;", "processDefinition", "Lio/holunda/polyflow/view/ProcessDefinition;", "task", "Lio/holunda/polyflow/view/Task;", "Companion", "polyflow-form-url-resolver"})
public final class PropertyBasedFormUrlResolver
implements FormUrlResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FormUrlResolverProperties props;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    public static final String APPLICATION_NAME_ATTRIBUTE = "applicationName";

    public PropertyBasedFormUrlResolver(@NotNull FormUrlResolverProperties props, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.props = props;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public String resolveUrl(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String applicationName = task.getSourceReference().getApplicationName();
        Map appMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)APPLICATION_NAME_ATTRIBUTE, (Object)applicationName));
        String appTemplate = this.props.getApplicationTemplate(applicationName);
        String taskTemplate = this.props.getTaskUrlTemplate(applicationName, task.getTaskDefinitionKey());
        Object object = this.objectMapper.convertValue((Object)task, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026e<Map<String, Any>>() {})");
        Map taskMap2 = (Map)object;
        return new StringSubstitutor(appMap).replace(appTemplate) + "/" + new StringSubstitutor(taskMap2).replace(taskTemplate);
    }

    @NotNull
    public String resolveUrl(@NotNull ProcessDefinition processDefinition) {
        Intrinsics.checkNotNullParameter((Object)processDefinition, (String)"processDefinition");
        String applicationName = processDefinition.getApplicationName();
        Map appMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)APPLICATION_NAME_ATTRIBUTE, (Object)applicationName));
        String appTemplate = this.props.getApplicationTemplate(applicationName);
        String processDefinitionTemplate = this.props.getProcessUrlTemplate(applicationName, processDefinition.getProcessDefinitionKey());
        Object object = this.objectMapper.convertValue((Object)processDefinition, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026e<Map<String, Any>>() {})");
        Map processDefinitionMap2 = (Map)object;
        return new StringSubstitutor(appMap).replace(appTemplate) + "/" + new StringSubstitutor(processDefinitionMap2).replace(processDefinitionTemplate);
    }

    @NotNull
    public String resolveUrl(@NotNull DataEntry dataEntry) {
        Intrinsics.checkNotNullParameter((Object)dataEntry, (String)"dataEntry");
        String applicationName = dataEntry.getApplicationName();
        Map appMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)APPLICATION_NAME_ATTRIBUTE, (Object)applicationName));
        String appTemplate = this.props.getApplicationTemplate(applicationName);
        String boTemplate = this.props.getDataEntryTemplate(applicationName, dataEntry.getEntryType());
        Object object = this.objectMapper.convertValue((Object)dataEntry, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026e<Map<String, Any>>() {})");
        Map boMap2 = (Map)object;
        return new StringSubstitutor(appMap).replace(appTemplate) + "/" + new StringSubstitutor(boMap2).replace(boTemplate);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/holunda/polyflow/urlresolver/PropertyBasedFormUrlResolver$Companion;", "", "()V", "APPLICATION_NAME_ATTRIBUTE", "", "polyflow-form-url-resolver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

