/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.urlresolver;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="polyflow.integration.form-url-resolver")
@ConstructorBinding
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001'BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003JG\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u001a\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\n\u0010\u001e\u001a\u00060\u0003j\u0002`\u001fJ\u0016\u0010 \u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010\"\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006("}, d2={"Lio/holunda/polyflow/urlresolver/FormUrlResolverProperties;", "", "defaultTaskTemplate", "", "defaultApplicationTemplate", "defaultProcessTemplate", "defaultDataEntryTemplate", "applications", "", "Lio/holunda/polyflow/urlresolver/FormUrlResolverProperties$Application;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplications", "()Ljava/util/Map;", "getDefaultApplicationTemplate", "()Ljava/lang/String;", "getDefaultDataEntryTemplate", "getDefaultProcessTemplate", "getDefaultTaskTemplate", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "getApplicationTemplate", "applicationName", "getDataEntryTemplate", "entryType", "Lio/holunda/camunda/taskpool/api/business/EntryType;", "getProcessUrlTemplate", "processDefinitionKey", "getTaskUrlTemplate", "taskDefinitionKey", "hashCode", "", "toString", "Application", "polyflow-form-url-resolver"})
public final class FormUrlResolverProperties {
    @NotNull
    private final String defaultTaskTemplate;
    @NotNull
    private final String defaultApplicationTemplate;
    @NotNull
    private final String defaultProcessTemplate;
    @NotNull
    private final String defaultDataEntryTemplate;
    @NestedConfigurationProperty
    @NotNull
    private final Map<String, Application> applications;

    public FormUrlResolverProperties(@NotNull String defaultTaskTemplate, @NotNull String defaultApplicationTemplate, @NotNull String defaultProcessTemplate, @NotNull String defaultDataEntryTemplate, @NotNull Map<String, Application> applications) {
        Intrinsics.checkNotNullParameter((Object)defaultTaskTemplate, (String)"defaultTaskTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultApplicationTemplate, (String)"defaultApplicationTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultProcessTemplate, (String)"defaultProcessTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultDataEntryTemplate, (String)"defaultDataEntryTemplate");
        Intrinsics.checkNotNullParameter(applications, (String)"applications");
        this.defaultTaskTemplate = defaultTaskTemplate;
        this.defaultApplicationTemplate = defaultApplicationTemplate;
        this.defaultProcessTemplate = defaultProcessTemplate;
        this.defaultDataEntryTemplate = defaultDataEntryTemplate;
        this.applications = applications;
    }

    public /* synthetic */ FormUrlResolverProperties(String string, String string2, String string3, String string4, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        if ((n & 0x10) != 0) {
            map = new LinkedHashMap();
        }
        this(string, string2, string3, string4, map);
    }

    @NotNull
    public final String getDefaultTaskTemplate() {
        return this.defaultTaskTemplate;
    }

    @NotNull
    public final String getDefaultApplicationTemplate() {
        return this.defaultApplicationTemplate;
    }

    @NotNull
    public final String getDefaultProcessTemplate() {
        return this.defaultProcessTemplate;
    }

    @NotNull
    public final String getDefaultDataEntryTemplate() {
        return this.defaultDataEntryTemplate;
    }

    @NotNull
    public final Map<String, Application> getApplications() {
        return this.applications;
    }

    @NotNull
    public final String getTaskUrlTemplate(@NotNull String applicationName, @NotNull String taskDefinitionKey) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)taskDefinitionKey, (String)"taskDefinitionKey");
        Application application = this.applications.get(applicationName);
        if (application == null) {
            return this.defaultTaskTemplate;
        }
        Application application2 = application;
        return application2.getTasks().getOrDefault(taskDefinitionKey, this.defaultTaskTemplate);
    }

    @NotNull
    public final String getProcessUrlTemplate(@NotNull String applicationName, @NotNull String processDefinitionKey) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)processDefinitionKey, (String)"processDefinitionKey");
        Application application = this.applications.get(applicationName);
        if (application == null) {
            return this.defaultProcessTemplate;
        }
        Application application2 = application;
        return application2.getProcesses().getOrDefault(processDefinitionKey, this.defaultProcessTemplate);
    }

    @NotNull
    public final String getDataEntryTemplate(@NotNull String applicationName, @NotNull String entryType) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)entryType, (String)"entryType");
        Application application = this.applications.get(applicationName);
        if (application == null) {
            return this.defaultDataEntryTemplate;
        }
        Application application2 = application;
        return application2.getDataEntries().getOrDefault(entryType, this.defaultDataEntryTemplate);
    }

    @NotNull
    public final String getApplicationTemplate(@NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Application application = this.applications.get(applicationName);
        if (application == null) {
            return this.defaultApplicationTemplate;
        }
        Application application2 = application;
        String string = application2.getUrl();
        if (string == null) {
            string = this.defaultApplicationTemplate;
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.defaultTaskTemplate;
    }

    @NotNull
    public final String component2() {
        return this.defaultApplicationTemplate;
    }

    @NotNull
    public final String component3() {
        return this.defaultProcessTemplate;
    }

    @NotNull
    public final String component4() {
        return this.defaultDataEntryTemplate;
    }

    @NotNull
    public final Map<String, Application> component5() {
        return this.applications;
    }

    @NotNull
    public final FormUrlResolverProperties copy(@NotNull String defaultTaskTemplate, @NotNull String defaultApplicationTemplate, @NotNull String defaultProcessTemplate, @NotNull String defaultDataEntryTemplate, @NotNull Map<String, Application> applications) {
        Intrinsics.checkNotNullParameter((Object)defaultTaskTemplate, (String)"defaultTaskTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultApplicationTemplate, (String)"defaultApplicationTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultProcessTemplate, (String)"defaultProcessTemplate");
        Intrinsics.checkNotNullParameter((Object)defaultDataEntryTemplate, (String)"defaultDataEntryTemplate");
        Intrinsics.checkNotNullParameter(applications, (String)"applications");
        return new FormUrlResolverProperties(defaultTaskTemplate, defaultApplicationTemplate, defaultProcessTemplate, defaultDataEntryTemplate, applications);
    }

    public static /* synthetic */ FormUrlResolverProperties copy$default(FormUrlResolverProperties formUrlResolverProperties, String string, String string2, String string3, String string4, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = formUrlResolverProperties.defaultTaskTemplate;
        }
        if ((n & 2) != 0) {
            string2 = formUrlResolverProperties.defaultApplicationTemplate;
        }
        if ((n & 4) != 0) {
            string3 = formUrlResolverProperties.defaultProcessTemplate;
        }
        if ((n & 8) != 0) {
            string4 = formUrlResolverProperties.defaultDataEntryTemplate;
        }
        if ((n & 0x10) != 0) {
            map = formUrlResolverProperties.applications;
        }
        return formUrlResolverProperties.copy(string, string2, string3, string4, map);
    }

    @NotNull
    public String toString() {
        return "FormUrlResolverProperties(defaultTaskTemplate=" + this.defaultTaskTemplate + ", defaultApplicationTemplate=" + this.defaultApplicationTemplate + ", defaultProcessTemplate=" + this.defaultProcessTemplate + ", defaultDataEntryTemplate=" + this.defaultDataEntryTemplate + ", applications=" + this.applications + ")";
    }

    public int hashCode() {
        int result = this.defaultTaskTemplate.hashCode();
        result = result * 31 + this.defaultApplicationTemplate.hashCode();
        result = result * 31 + this.defaultProcessTemplate.hashCode();
        result = result * 31 + this.defaultDataEntryTemplate.hashCode();
        result = result * 31 + ((Object)this.applications).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FormUrlResolverProperties)) {
            return false;
        }
        FormUrlResolverProperties formUrlResolverProperties = (FormUrlResolverProperties)other;
        if (!Intrinsics.areEqual((Object)this.defaultTaskTemplate, (Object)formUrlResolverProperties.defaultTaskTemplate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultApplicationTemplate, (Object)formUrlResolverProperties.defaultApplicationTemplate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultProcessTemplate, (Object)formUrlResolverProperties.defaultProcessTemplate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultDataEntryTemplate, (Object)formUrlResolverProperties.defaultDataEntryTemplate)) {
            return false;
        }
        return Intrinsics.areEqual(this.applications, formUrlResolverProperties.applications);
    }

    public FormUrlResolverProperties() {
        this(null, null, null, null, null, 31, null);
    }

    @ConstructorBinding
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BS\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003JW\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/holunda/polyflow/urlresolver/FormUrlResolverProperties$Application;", "", "url", "", "tasks", "", "processes", "dataEntries", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getDataEntries", "()Ljava/util/Map;", "getProcesses", "getTasks", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "polyflow-form-url-resolver"})
    public static final class Application {
        @Nullable
        private final String url;
        @NotNull
        private final Map<String, String> tasks;
        @NotNull
        private final Map<String, String> processes;
        @NotNull
        private final Map<String, String> dataEntries;

        public Application(@Nullable String url, @NotNull Map<String, String> tasks, @NotNull Map<String, String> processes, @NotNull Map<String, String> dataEntries) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            Intrinsics.checkNotNullParameter(processes, (String)"processes");
            Intrinsics.checkNotNullParameter(dataEntries, (String)"dataEntries");
            this.url = url;
            this.tasks = tasks;
            this.processes = processes;
            this.dataEntries = dataEntries;
        }

        public /* synthetic */ Application(String string, Map map, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 4) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n & 8) != 0) {
                map3 = new LinkedHashMap();
            }
            this(string, map, map2, map3);
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Map<String, String> getTasks() {
            return this.tasks;
        }

        @NotNull
        public final Map<String, String> getProcesses() {
            return this.processes;
        }

        @NotNull
        public final Map<String, String> getDataEntries() {
            return this.dataEntries;
        }

        @Nullable
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.tasks;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.processes;
        }

        @NotNull
        public final Map<String, String> component4() {
            return this.dataEntries;
        }

        @NotNull
        public final Application copy(@Nullable String url, @NotNull Map<String, String> tasks, @NotNull Map<String, String> processes, @NotNull Map<String, String> dataEntries) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            Intrinsics.checkNotNullParameter(processes, (String)"processes");
            Intrinsics.checkNotNullParameter(dataEntries, (String)"dataEntries");
            return new Application(url, tasks, processes, dataEntries);
        }

        public static /* synthetic */ Application copy$default(Application application, String string, Map map, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                string = application.url;
            }
            if ((n & 2) != 0) {
                map = application.tasks;
            }
            if ((n & 4) != 0) {
                map2 = application.processes;
            }
            if ((n & 8) != 0) {
                map3 = application.dataEntries;
            }
            return application.copy(string, map, map2, map3);
        }

        @NotNull
        public String toString() {
            return "Application(url=" + this.url + ", tasks=" + this.tasks + ", processes=" + this.processes + ", dataEntries=" + this.dataEntries + ")";
        }

        public int hashCode() {
            int result = this.url == null ? 0 : this.url.hashCode();
            result = result * 31 + ((Object)this.tasks).hashCode();
            result = result * 31 + ((Object)this.processes).hashCode();
            result = result * 31 + ((Object)this.dataEntries).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Application)) {
                return false;
            }
            Application application = (Application)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)application.url)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tasks, application.tasks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.processes, application.processes)) {
                return false;
            }
            return Intrinsics.areEqual(this.dataEntries, application.dataEntries);
        }

        public Application() {
            this(null, null, null, null, 15, null);
        }
    }
}

