/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.view.query;

import io.holunda.polyflow.view.query.PageableSortableQuery;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0002B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lio/holunda/polyflow/view/query/QueryResult;", "T", "", "S", "elements", "", "(Ljava/util/List;)V", "totalElementCount", "", "(ILjava/util/List;)V", "getElements", "()Ljava/util/List;", "getTotalElementCount", "()I", "slice", "query", "Lio/holunda/polyflow/view/query/PageableSortableQuery;", "polyflow-view-api"})
public class QueryResult<T, S extends QueryResult<T, S>> {
    private final int totalElementCount;
    @NotNull
    private final List<T> elements;

    public QueryResult(int totalElementCount, @NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.totalElementCount = totalElementCount;
        this.elements = elements;
    }

    public final int getTotalElementCount() {
        return this.totalElementCount;
    }

    @NotNull
    public List<T> getElements() {
        return this.elements;
    }

    public QueryResult(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this(elements.size(), elements);
    }

    @NotNull
    public QueryResult<T, S> slice(@NotNull PageableSortableQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        int totalCount = this.getElements().size();
        int offset = query.getPage() * query.getSize();
        return totalCount > offset ? new QueryResult<T, S>(totalCount, CollectionsKt.slice(this.getElements(), (IntRange)RangesKt.until((int)offset, (int)Math.min(offset + query.getSize(), totalCount)))) : new QueryResult<T, S>(totalCount, this.getElements());
    }
}

