/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.compat;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import androidx.annotation.LayoutRes;
import androidx.appcompat.app.AppCompatActivity;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculus.android.core.ActivityEventOwner;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.navigation.Navigation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class EventAppCompatActivity
extends AppCompatActivity
implements ActivityEventOwner {
    private ActivityEventDispatcher<EventAppCompatActivity> mEventDispatcher;
    private boolean mEverCreated;
    private View mContentView;

    public void finishApplication() {
        System.runFinalization();
        try {
            Process.killProcess((int)Process.myPid());
        }
        finally {
            System.exit(0);
        }
    }

    public Scope getScope() {
        return null;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
        this.mEventDispatcher.getEventDispatcher().onActivityCreate(this, savedInstanceState);
    }

    @Override
    public void setContentView(View view) {
        super.setContentView(view);
        this.mContentView = view;
    }

    @Override
    public void setContentView(@LayoutRes int layoutResID) {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View view = inflater.inflate(layoutResID, null, false);
        this.setContentView(view);
    }

    @Nullable
    public View getContentView() {
        return this.mContentView;
    }

    private void init() {
        this.mEventDispatcher = new ActivityEventDispatcher<EventAppCompatActivity>(this.getScope(), this);
        this.mEverCreated = true;
    }

    public ActivityEventDispatcher<EventAppCompatActivity> getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @Override
    protected void onPause() {
        this.mEventDispatcher.getEventDispatcher().onActivityPause(this);
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mEventDispatcher.getEventDispatcher().onActivityResume(this);
    }

    @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mEventDispatcher.getEventDispatcher().onActivityPostCreate(this, savedInstanceState);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mEventDispatcher.getEventDispatcher().onActivitySaveInstanceState(this, outState);
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
        this.mEventDispatcher.getEventDispatcher().onActivityPostResume(this);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.mEventDispatcher.getEventDispatcher().onActivityResult(this, requestCode, resultCode, data)) {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.mEventDispatcher.getEventDispatcher().onActivityStart(this);
    }

    @Override
    protected void onStop() {
        this.mEventDispatcher.getEventDispatcher().onActivityStop(this);
        super.onStop();
    }

    protected void onChildTitleChanged(Activity childActivity, CharSequence title) {
        super.onChildTitleChanged(childActivity, title);
        this.mEventDispatcher.getEventDispatcher().onActivityChildTitleChanged(this, childActivity, title);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.mEventDispatcher.getEventDispatcher().onActivityNewIntent(this, intent);
    }

    protected void onRestart() {
        super.onRestart();
        this.mEventDispatcher.getEventDispatcher().onActivityRestart(this);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mEventDispatcher.getEventDispatcher().onActivityRestoreInstanceState(this, savedInstanceState);
    }

    @Override
    protected void onTitleChanged(CharSequence title, int color2) {
        super.onTitleChanged(title, color2);
        this.mEventDispatcher.getEventDispatcher().onActivityTitleChanged(this, title, color2);
    }

    protected void onUserLeaveHint() {
        super.onUserLeaveHint();
        this.mEventDispatcher.getEventDispatcher().onActivityUserLeaveHint(this);
    }

    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        ActionMode mode = this.mEventDispatcher.getEventDispatcher().onActivityWindowStartingActionMode(this, callback);
        if (mode == null) {
            return super.onWindowStartingActionMode(callback);
        }
        return mode;
    }

    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        ActionMode mode = this.mEventDispatcher.getEventDispatcher().onActivityWindowStartingActionMode(this, callback, type);
        if (mode == null) {
            return super.onWindowStartingActionMode(callback, type);
        }
        return mode;
    }

    public void onActionModeStarted(ActionMode mode) {
        super.onActionModeStarted(mode);
        this.mEventDispatcher.getEventDispatcher().onActionModeStarted(mode);
    }

    public void onActionModeFinished(ActionMode mode) {
        super.onActionModeFinished(mode);
        this.mEventDispatcher.getEventDispatcher().onActionModeFinished(mode);
    }

    public boolean onContextItemSelected(MenuItem item) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityContextItemSelected(this, item)) {
            return true;
        }
        return super.onContextItemSelected(item);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityCreateOptionsMenu(this, menu2)) {
            return true;
        }
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onCreatePanelMenu(int featureId, Menu menu2) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityCreatePanelMenu(this, featureId, menu2)) {
            return true;
        }
        return super.onCreatePanelMenu(featureId, menu2);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityGenericMotionEvent(this, event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityKeyDown(this, keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityKeyLongPress(this, keyCode, event)) {
            return true;
        }
        return super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityKeyMultiple(this, keyCode, repeatCount, event)) {
            return true;
        }
        return super.onKeyMultiple(keyCode, repeatCount, event);
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityKeyShortcut(this, keyCode, event)) {
            return true;
        }
        return super.onKeyShortcut(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityKeyUp(this, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onMenuOpened(int featureId, Menu menu2) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityMenuOpened(this, featureId, menu2)) {
            return true;
        }
        return super.onMenuOpened(featureId, menu2);
    }

    public boolean onNavigateUp() {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onNavigateUp()) {
            return true;
        }
        return super.onNavigateUp();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityOptionsItemSelected(this, item)) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityPrepareOptionsMenu(this, menu2)) {
            return true;
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    @Override
    public boolean onPreparePanel(int featureId, View view, Menu menu2) {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivityPreparePanel(this, featureId, view, menu2)) {
            return true;
        }
        return super.onPreparePanel(featureId, view, menu2);
    }

    public boolean onSearchRequested() {
        if (this.invalidLifeState()) {
            return false;
        }
        if (this.mEventDispatcher.getEventDispatcher().onActivitySearchRequested(this)) {
            return true;
        }
        return super.onSearchRequested();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityTouchEvent(this, event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean onSearchRequested(SearchEvent searchEvent) {
        if (this.mEventDispatcher.getEventDispatcher().onActivitySearchRequested(this, searchEvent)) {
            return true;
        }
        return super.onSearchRequested(searchEvent);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityTrackballEvent(this, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    @Nullable
    public CharSequence onCreateDescription() {
        CharSequence res = this.mEventDispatcher.getEventDispatcher().onActivityCreateDescription(this);
        if (res == null) {
            return super.onCreateDescription();
        }
        return res;
    }

    public Uri onProvideReferrer() {
        Uri res = this.mEventDispatcher.getEventDispatcher().onActivityProvideReferrer(this);
        if (res == null) {
            return super.onProvideReferrer();
        }
        return res;
    }

    @Nullable
    public View onCreatePanelView(int featureId) {
        View res = this.mEventDispatcher.getEventDispatcher().onActivityCreatePanelView(this, featureId);
        if (res == null) {
            return super.onCreatePanelView(featureId);
        }
        return res;
    }

    protected boolean onDispatchNavigationBackPressed() {
        Navigation navigation = (Navigation)this.getScope().resolve(Navigation.class);
        if (navigation != null) {
            return navigation.backward();
        }
        LoggerFactory.getLogger(this.getClass()).error("no navigation available");
        return false;
    }

    @Override
    public void onBackPressed() {
        if (!this.mEventDispatcher.getEventDispatcher().onActivityBackPressed(this)) {
            super.onBackPressed();
        }
    }

    @Override
    public void onLowMemory() {
        this.mEventDispatcher.getEventDispatcher().onLowMemory(this);
        super.onLowMemory();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.mEventDispatcher.getEventDispatcher().onActivityConfigurationChanged(this, newConfig);
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mEventDispatcher.getEventDispatcher().onActivityDispatchKeyEvent(this, event)) {
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    @Override
    public void onPanelClosed(int featureId, Menu menu2) {
        if (this.invalidLifeState()) {
            return;
        }
        if (!this.mEventDispatcher.getEventDispatcher().onActivityPanelClosed(this, featureId, menu2)) {
            super.onPanelClosed(featureId, menu2);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.mEventDispatcher.getEventDispatcher().onActivityRequestPermissionsResult(this, requestCode, permissions, grantResults);
    }

    @Override
    protected void onDestroy() {
        this.mEventDispatcher.destroy();
        super.onDestroy();
        this.mEventDispatcher = null;
        Scope scope = this.getScope();
        if (scope != null) {
            scope.onDestroy();
        }
    }

    private boolean invalidLifeState() {
        if (this.mEventDispatcher == null) {
            String msg = this.mEverCreated ? "after destroy" : "before onCreate";
            LoggerFactory.getLogger(this.getClass()).error("the activity {} is used in an invalid state: {}", (Object)this, (Object)msg);
            return true;
        }
        return false;
    }
}

