/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import org.homunculus.android.component.BitmapPool;
import org.homunculusframework.lang.Panic;
import org.slf4j.LoggerFactory;

public class BitmapPoolFactory {
    private static final NoPool sNoPool = new NoPool();
    private static final BitmapPool sPool;
    private static boolean sPoolingEnabled;
    private static ByteBuffer sTmp;

    public static synchronized BitmapPool getDefaultPool() {
        if (!sPoolingEnabled) {
            return sNoPool;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return sPool;
        }
        return sNoPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Bitmap readPixel(DataInput in) throws IOException {
        boolean available = in.readBoolean();
        if (!available) {
            return null;
        }
        int width = in.readInt();
        int height = in.readInt();
        int type = in.readUnsignedByte();
        if (type != Bitmap.Config.ARGB_8888.ordinal()) {
            throw new Panic("format not implemented " + type);
        }
        int bytes = width * height * 4;
        Bitmap bmp = BitmapPoolFactory.getDefaultPool().borrowBitmap(width, height, Bitmap.Config.ARGB_8888);
        Class<BitmapPoolFactory> clazz = BitmapPoolFactory.class;
        synchronized (BitmapPoolFactory.class) {
            if (sTmp.capacity() < bytes) {
                sTmp = ByteBuffer.allocate(bytes);
            }
            sTmp.clear();
            in.readFully(sTmp.array(), 0, bytes);
            sTmp.limit(bytes);
            bmp.copyPixelsFromBuffer((Buffer)sTmp);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return bmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePixel(@Nullable Bitmap src, DataOutput dst) throws IOException {
        if (src != null && src.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new Panic("only bitmaps of the type ARGB_8888 are supported");
        }
        dst.writeBoolean(src != null);
        if (src == null) {
            return;
        }
        dst.writeInt(src.getWidth());
        dst.writeInt(src.getHeight());
        int bytes = src.getWidth() * src.getHeight() * 4;
        dst.writeByte(src.getConfig().ordinal());
        Class<BitmapPoolFactory> clazz = BitmapPoolFactory.class;
        synchronized (BitmapPoolFactory.class) {
            if (sTmp.capacity() < bytes) {
                sTmp = ByteBuffer.allocate(bytes);
            }
            sTmp.clear();
            sTmp.limit(bytes);
            src.copyPixelsToBuffer((Buffer)sTmp);
            dst.write(sTmp.array(), 0, bytes);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static boolean isPoolingEnabled() {
        return sPoolingEnabled;
    }

    public static synchronized void disablePooling() {
        sPoolingEnabled = false;
        sPool.clear();
    }

    public static void enablePooling() {
        sPoolingEnabled = true;
    }

    public static BitmapPool getNoPool() {
        return sNoPool;
    }

    static {
        sPoolingEnabled = true;
        sTmp = ByteBuffer.allocate(0x100000);
        sPool = Build.VERSION.SDK_INT >= 19 ? new KitKat19AndroidPool() : new SimpleAndroidPool();
    }

    @TargetApi(value=19)
    public static class KitKat19AndroidPool
    extends AbsAndroidPool {
        private int mCapacity = 0x1000000;
        private LinkedList<Bitmap> mCache = new LinkedList();
        private boolean mDebug;
        private float mAcceptableMaxTrash = 1000.0f;

        @Override
        public void setDebug(boolean b) {
            this.mDebug = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap borrowBitmap(int width, int height, Bitmap.Config config) {
            float trashPercent;
            if (config != Bitmap.Config.ARGB_8888) {
                throw new Panic("only argb8888 images are supported");
            }
            int expectedBytes = width * height * 32 / 8;
            Bitmap bestMatch = null;
            int capacityDelta = Integer.MAX_VALUE;
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                Iterator it = this.mCache.iterator();
                while (it.hasNext()) {
                    Bitmap bmp = (Bitmap)it.next();
                    if (bmp.isRecycled()) {
                        it.remove();
                        if (!this.mDebug) continue;
                        LoggerFactory.getLogger(this.getClass()).debug("found already recycled bitmap {}", (Object)bmp);
                        continue;
                    }
                    int bytes = bmp.getAllocationByteCount();
                    if (bytes < expectedBytes || bestMatch != null && bytes - expectedBytes >= capacityDelta) continue;
                    bestMatch = bmp;
                    capacityDelta = bytes - expectedBytes;
                }
                trashPercent = (float)capacityDelta / (float)expectedBytes * 100.0f;
                if (trashPercent < this.mAcceptableMaxTrash) {
                    this.mCache.remove(bestMatch);
                } else {
                    if (this.mDebug) {
                        LoggerFactory.getLogger(this.getClass()).debug("Best bitmap is to inefficient: {}x{}@{}, having {} entries. Trash: {}%", new Object[]{width, height, config, this.mCache.size(), Float.valueOf(trashPercent)});
                    }
                    bestMatch = null;
                }
            }
            if (bestMatch != null) {
                if (this.mDebug) {
                    LoggerFactory.getLogger(this.getClass()).debug("found bitmap to reconfigure {}x{}@{}, having {} entries. Trash: {}%", new Object[]{width, height, config, this.mCache.size(), Float.valueOf(trashPercent)});
                }
                bestMatch.reconfigure(width, height, config);
                bestMatch.setHasAlpha(true);
                if (Build.VERSION.SDK_INT >= 12 && !bestMatch.hasAlpha()) {
                    bestMatch.setHasAlpha(true);
                }
                bestMatch.eraseColor(0);
                return bestMatch;
            }
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bmp.setHasAlpha(true);
            if (this.mDebug) {
                LoggerFactory.getLogger(this.getClass()).debug("cache miss {}x{}@{}, having {} entries", new Object[]{width, height, config, this.mCache.size()});
                LoggerFactory.getLogger(this.getClass()).debug("created {}", (Object)bmp);
            }
            return bmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                for (Bitmap b : this.mCache) {
                    b.recycle();
                }
                this.mCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int countBitmaps(int width, int height, Bitmap.Config config) {
            int c = 0;
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                Iterator it = this.mCache.iterator();
                while (it.hasNext()) {
                    Bitmap bmp = (Bitmap)it.next();
                    if (bmp.isRecycled()) {
                        it.remove();
                        continue;
                    }
                    if (bmp.getWidth() != width || bmp.getHeight() != height || bmp.getConfig() != config) continue;
                    ++c;
                }
            }
            return c;
        }

        @Override
        public void returnBitmap(Bitmap bmp) {
            if (bmp == null || bmp.isRecycled()) {
                return;
            }
            Handler h = new Handler(Looper.getMainLooper());
            h.post(() -> h.post(() -> {
                if (!bmp.isMutable()) {
                    LoggerFactory.getLogger(this.getClass()).warn("do not return immutable bitmaps!");
                    bmp.recycle();
                    return;
                }
                LinkedList<Bitmap> linkedList = this.mCache;
                synchronized (linkedList) {
                    if (this.mDebug) {
                        this.checkIfAlreayIn(bmp);
                    }
                    int currentSize = this.getCurrentSize();
                    int additionalSize = bmp.getAllocationByteCount();
                    if ((float)additionalSize > 0.7f * (float)this.mCapacity) {
                        if (this.mDebug) {
                            LoggerFactory.getLogger(this.getClass()).debug("bitmap is larger than pool capacity {}", (Object)bmp);
                        }
                        bmp.recycle();
                        return;
                    }
                    while (additionalSize + currentSize > this.mCapacity && this.mCache.size() > 0) {
                        Bitmap toDel = this.mCache.remove();
                        additionalSize -= toDel.getWidth() * toDel.getHeight() * 4;
                        toDel.recycle();
                        if (!this.mDebug) continue;
                        LoggerFactory.getLogger(this.getClass()).debug("exceeding limit - free bitmap for {}x{}@{} {}", new Object[]{toDel.getWidth(), toDel.getHeight(), toDel.getConfig(), toDel});
                    }
                    if (this.mDebug) {
                        LoggerFactory.getLogger(this.getClass()).debug("added to cache {}bytes {}", (Object)bmp.getAllocationByteCount(), (Object)bmp);
                    }
                    this.mCache.add(bmp);
                }
            }));
        }

        private void checkIfAlreayIn(Bitmap bmp) {
            for (Bitmap b : this.mCache) {
                if (b != bmp) continue;
                throw new IllegalArgumentException("you cannot return bitmaps multiple times " + bmp);
            }
        }

        private int getCurrentSize() {
            int size = 0;
            for (Bitmap bmp : this.mCache) {
                size += bmp.getWidth() * bmp.getHeight() * 4;
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                for (Bitmap bmp : this.mCache) {
                    if (bmp.isRecycled()) continue;
                    bmp.recycle();
                }
                this.mCache.clear();
            }
        }
    }

    public static class SimpleAndroidPool
    extends AbsAndroidPool {
        private int mCapacity = 0x1000000;
        private LinkedList<Bitmap> mCache = new LinkedList();
        private boolean mDebug;

        @Override
        public void setDebug(boolean b) {
            this.mDebug = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap borrowBitmap(int width, int height, Bitmap.Config config) {
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                Iterator it = this.mCache.iterator();
                while (it.hasNext()) {
                    Bitmap bmp = (Bitmap)it.next();
                    if (bmp.isRecycled()) {
                        it.remove();
                        if (!this.mDebug) continue;
                        LoggerFactory.getLogger(this.getClass()).debug("found already recycled bitmap {}", (Object)bmp);
                        continue;
                    }
                    if (bmp.getWidth() != width || bmp.getHeight() != height || bmp.getConfig() != config) continue;
                    it.remove();
                    if (this.mDebug) {
                        LoggerFactory.getLogger(this.getClass()).debug("found bitmap {}x{}@{}, having {} entries", new Object[]{width, height, config, this.mCache.size()});
                    }
                    if (Build.VERSION.SDK_INT >= 12 && !bmp.hasAlpha()) {
                        bmp.setHasAlpha(true);
                    }
                    bmp.eraseColor(0);
                    return bmp;
                }
            }
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            if (this.mDebug) {
                LoggerFactory.getLogger(this.getClass()).debug("cache miss {}x{}@{}, having {} entries", new Object[]{width, height, config, this.mCache.size()});
                LoggerFactory.getLogger(this.getClass()).debug("created {}", (Object)bmp);
            }
            return bmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                for (Bitmap b : this.mCache) {
                    b.recycle();
                }
                this.mCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int countBitmaps(int width, int height, Bitmap.Config config) {
            int c = 0;
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                Iterator it = this.mCache.iterator();
                while (it.hasNext()) {
                    Bitmap bmp = (Bitmap)it.next();
                    if (bmp.isRecycled()) {
                        it.remove();
                        continue;
                    }
                    if (bmp.getWidth() != width || bmp.getHeight() != height || bmp.getConfig() != config) continue;
                    ++c;
                }
            }
            return c;
        }

        @Override
        public void returnBitmap(Bitmap bmp) {
            if (bmp == null || bmp.isRecycled()) {
                return;
            }
            Handler h = new Handler(Looper.getMainLooper());
            h.post(() -> h.post(() -> {
                if (!bmp.isMutable()) {
                    LoggerFactory.getLogger(this.getClass()).warn("do not return immutable bitmaps!");
                    bmp.recycle();
                    return;
                }
                LinkedList<Bitmap> linkedList = this.mCache;
                synchronized (linkedList) {
                    if (this.mDebug) {
                        this.checkIfAlreayIn(bmp);
                    }
                    int currentSize = this.getCurrentSize();
                    int additionalSize = bmp.getWidth() * bmp.getHeight() * 4;
                    if ((float)additionalSize > 0.7f * (float)this.mCapacity) {
                        if (this.mDebug) {
                            LoggerFactory.getLogger(this.getClass()).debug("bitmap is larger than pool capacity {}", (Object)bmp);
                        }
                        bmp.recycle();
                        return;
                    }
                    while (additionalSize + currentSize > this.mCapacity && this.mCache.size() > 0) {
                        Bitmap toDel = this.mCache.remove();
                        additionalSize -= toDel.getWidth() * toDel.getHeight() * 4;
                        toDel.recycle();
                        if (!this.mDebug) continue;
                        LoggerFactory.getLogger(this.getClass()).debug("exceeding limit - free bitmap for {}x{}@{} {}", new Object[]{toDel.getWidth(), toDel.getHeight(), toDel.getConfig(), toDel});
                    }
                    if (this.mDebug) {
                        LoggerFactory.getLogger(this.getClass()).debug("added to cache {}x{}@{} {}", new Object[]{bmp.getWidth(), bmp.getHeight(), bmp.getConfig(), bmp});
                    }
                    this.mCache.add(bmp);
                }
            }));
        }

        private void checkIfAlreayIn(Bitmap bmp) {
            for (Bitmap b : this.mCache) {
                if (b != bmp) continue;
                throw new IllegalArgumentException("you cannot return bitmaps multiple times " + bmp);
            }
        }

        private int getCurrentSize() {
            int size = 0;
            for (Bitmap bmp : this.mCache) {
                size += bmp.getWidth() * bmp.getHeight() * 4;
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            LinkedList<Bitmap> linkedList = this.mCache;
            synchronized (linkedList) {
                for (Bitmap bmp : this.mCache) {
                    if (bmp.isRecycled()) continue;
                    bmp.recycle();
                }
                this.mCache.clear();
            }
        }
    }

    public static class NoPool
    extends AbsAndroidPool {
        @Override
        public Bitmap borrowBitmap(int width, int height, Bitmap.Config config) {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }

        @Override
        public void returnBitmap(Bitmap bmp) {
            if (bmp != null && !bmp.isRecycled()) {
                Handler h = new Handler(Looper.getMainLooper());
                h.post(() -> h.post(() -> bmp.recycle()));
            }
        }

        @Override
        public void destroy() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void setDebug(boolean b) {
        }

        @Override
        public int countBitmaps(int width, int height, Bitmap.Config config) {
            return 0;
        }
    }

    public static abstract class AbsAndroidPool
    implements BitmapPool {
        public abstract void setDebug(boolean var1);
    }
}

