/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.homunculus.android.compat.EventAppCompatActivity;
import org.homunculus.android.component.Display;
import org.homunculus.android.component.module.uncaughtexception.UncaughtException;
import org.homunculusframework.factory.container.Binding;
import org.homunculusframework.factory.container.Handler;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.navigation.BackActionConsumer;
import org.homunculusframework.navigation.DefaultNavigation;
import org.homunculusframework.navigation.Navigation;

public class DefaultAndroidNavigation
extends DefaultNavigation
implements Navigation {
    @Nullable
    private NavigationBlockingDialog blockingIndicatorDialog;

    public DefaultAndroidNavigation(Scope scope, Handler methodBindingHandler, Handler objectBindingHandler) {
        super(scope, methodBindingHandler, objectBindingHandler);
    }

    public void forward(Binding<?, ?> request) {
        super.forward(request);
    }

    public boolean backward() {
        EventAppCompatActivity activity = (EventAppCompatActivity)this.getScope().resolve(EventAppCompatActivity.class);
        if (activity != null && activity.getContentView() instanceof BackActionConsumer && ((BackActionConsumer)activity.getContentView()).backward()) {
            return true;
        }
        return super.backward();
    }

    public void backward(Binding<?, ?> request) {
        super.backward(request);
    }

    protected void onBeforeApply(@Nullable Binding<?, ?> currentRequest, Binding<?, ?> nextRequest) {
        super.onBeforeApply(currentRequest, nextRequest);
        NavigationBlockingDialog dlg = this.blockingIndicatorDialog;
        if (dlg != null) {
            dlg.cancel();
            this.blockingIndicatorDialog = null;
        }
        dlg = new NavigationBlockingDialog((Context)this.getScope().resolve(Context.class));
        dlg.show();
        this.blockingIndicatorDialog = dlg;
    }

    protected void onAfterApply(@Nullable Binding<?, ?> currentRequest, Binding<?, ?> nextRequest, @Nullable Throwable details) {
        super.onAfterApply(currentRequest, nextRequest, details);
        NavigationBlockingDialog dlg = this.blockingIndicatorDialog;
        if (dlg != null) {
            dlg.cancel();
            this.blockingIndicatorDialog = null;
        }
        if (details != null) {
            this.redirect(this.onError(details, currentRequest, nextRequest));
        }
    }

    protected Binding<?, ?> onError(Throwable details, @Nullable Binding<?, ?> currentRequest, Binding<?, ?> nextRequest) {
        details.printStackTrace();
        return new UncaughtException.BindUncaughtException(details, null);
    }

    public static class NavigationBlockingDialog
    extends Dialog {
        public NavigationBlockingDialog(@NonNull Context context) {
            super(context);
            this.onCreate();
        }

        protected void onCreate() {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setCancelable(false);
            FrameLayout layout2 = new FrameLayout(this.getContext());
            layout2.setBackgroundColor(0);
            ProgressBar pg = new ProgressBar(this.getContext());
            pg.setIndeterminate(true);
            Display dsp = Display.from(this.getContext());
            layout2.addView((View)pg, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(dsp.dipToPix(64), dsp.dipToPix(64), 17));
            this.setContentView((View)layout2);
        }
    }

    static enum Stack {
        FORWARD,
        BACKWARD,
        REDIRECT;

    }
}

