/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.homunculus.android.component.Intents;
import org.homunculus.android.component.Permissions;
import org.homunculus.android.component.R;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculusframework.concurrent.Async;
import org.homunculusframework.concurrent.Task;
import org.homunculusframework.factory.scope.LifecycleOwner;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Destroyable;
import org.homunculusframework.lang.Function;
import org.homunculusframework.lang.Procedure;
import org.homunculusframework.lang.Result;
import org.homunculusframework.scope.SettableTask;
import org.slf4j.LoggerFactory;

public class IntentImages
implements Destroyable {
    private int requestCodeCamera = 32123;
    private int requestCodeImage = 32124;
    private final Intents intentManager;
    private final Permissions permissions;
    private final List<Procedure<List<Uri>>> listeners;
    private final ActivityEventDispatcher<?> events;
    private final ActivityEventDispatcher.ActivityEventCallback callback;
    private List<Uri> lastParsedUris;
    private final Scope scope;

    public IntentImages(Scope scope, ActivityEventDispatcher<?> events) {
        this.intentManager = new Intents((LifecycleOwner)scope, events);
        this.permissions = new Permissions(scope, events);
        this.listeners = new ArrayList<Procedure<List<Uri>>>();
        this.events = events;
        this.scope = scope;
        this.lastParsedUris = IntentImages.parseUris(this.permissions.getActivity().getIntent());
        this.callback = new ActivityEventDispatcher.AbsActivityEventCallback(){

            @Override
            public void onActivityNewIntent(Activity activity, Intent intent) {
                IntentImages.this.lastParsedUris = IntentImages.parseUris(intent);
                IntentImages.this.notifyUrisChanged();
            }
        };
        if (this.events != null) {
            events.register(this.callback);
        }
    }

    public void setRequestCodeCamera(int requestCodeCamera) {
        this.requestCodeCamera = requestCodeCamera;
    }

    public void setRequestCodeImage(int requestCodeImage) {
        this.requestCodeImage = requestCodeImage;
    }

    private void notifyUrisChanged() {
        for (Procedure<List<Uri>> cb : this.listeners) {
            cb.apply(this.lastParsedUris);
        }
    }

    public Intents.ResultIntent<Result<Uri>> imageIntent() {
        return new PickImage();
    }

    public Intents.ResultIntent<Result<Uri>> cameraIntent() {
        return new PickCamera();
    }

    private void fixPermissionsForLegacy(Intent intent, Uri uri) {
        if (Build.VERSION.SDK_INT < 26) {
            List resolvedIntentActivities = this.intentManager.getContext().getPackageManager().queryIntentActivities(intent, 65536);
            for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                String packageName = resolvedIntentInfo.activityInfo.packageName;
                this.intentManager.getContext().grantUriPermission(packageName, uri, 3);
            }
        }
    }

    private File getCameraTmpFile() {
        File dir = new File(this.permissions.getActivity().getFilesDir(), "hcf_files");
        return new File(dir, "lastCameraImage.jpg");
    }

    public static Task<Result<List<Uri>>> asyncParseUris(Scope context, Intent intent) {
        return Async.createTask((Scope)context, ctx -> Result.create(IntentImages.parseUris(intent)));
    }

    public static List<Uri> parseUris(Intent intent) {
        ClipData clipData;
        TreeSet<Uri> myUris = new TreeSet<Uri>();
        if (intent == null) {
            return new ArrayList<Uri>();
        }
        Bundle extras = intent.getExtras();
        if (intent.getData() != null) {
            myUris.add(intent.getData());
        }
        if (extras != null) {
            CharSequence seq;
            ArrayList list;
            Uri uri;
            if (extras.getParcelable("android.intent.extra.STREAM") instanceof Uri && (uri = (Uri)extras.getParcelable("android.intent.extra.STREAM")) != null) {
                myUris.add(uri);
            }
            if (extras.getParcelable("android.intent.extra.STREAM") instanceof ArrayList && (list = intent.getParcelableArrayListExtra("android.intent.extra.STREAM")) != null) {
                for (Parcelable p : list) {
                    if (!(p instanceof Uri)) continue;
                    Uri uri2 = (Uri)p;
                    myUris.add(uri2);
                }
            }
            if ((seq = intent.getCharSequenceExtra("android.intent.extra.TEXT")) != null) {
                Uri strings;
                String[] src = seq.toString();
                for (Uri string2 : strings = src.split(Pattern.quote("\n"))) {
                    try {
                        URI uri3 = new URI((String)string2);
                        myUris.add(Uri.parse((String)uri3.toString()));
                    }
                    catch (URISyntaxException e) {
                        LoggerFactory.getLogger(IntentImages.class).debug("cannot parse as uri: {}", (Object)string2);
                    }
                }
            }
            if (intent.getCharSequenceArrayExtra("android.intent.extra.TEXT") != null) {
                String[] text;
                for (String txt : text = (String[])intent.getCharSequenceArrayExtra("android.intent.extra.TEXT")) {
                    String[] strings;
                    for (String string3 : strings = txt.split(Pattern.quote("\n"))) {
                        try {
                            URI uri4 = new URI(string3);
                            myUris.add(Uri.parse((String)uri4.toString()));
                        }
                        catch (URISyntaxException e) {
                            LoggerFactory.getLogger(IntentImages.class).debug("cannot parse as uri: {}", (Object)string3);
                        }
                    }
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 16 && (clipData = intent.getClipData()) != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                Uri uri = clipData.getItemAt(i).getUri();
                if (uri == null) {
                    try {
                        myUris.add(Uri.parse((String)clipData.getItemAt(i).getText().toString()));
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(IntentImages.class).debug("cannot parse as uri: {}", (Object)clipData.getItemAt(i).getText().toString());
                    }
                    continue;
                }
                myUris.add(uri);
            }
        }
        return new ArrayList<Uri>(myUris);
    }

    public void registerImagesReceivedCallback(Procedure<List<Uri>> func) {
        func.apply(this.lastParsedUris);
        this.listeners.add(func);
    }

    public void unregisterImagesReceivedCallback(Procedure<List<Uri>> func) {
        this.listeners.remove(func);
    }

    public void destroy() {
        if (this.events != null) {
            this.events.unregister(this.callback);
        }
    }

    private class PickCamera
    implements Intents.ResultIntent<Result<Uri>> {
        private PickCamera() {
        }

        @Override
        public Task<Result<Boolean>> invoke() {
            SettableTask resFile = SettableTask.create((String)"IntentImages.pickCameraPhoto");
            IntentImages.this.permissions.handlePermission("android.permission.CAMERA").whenDone(r -> {
                if (r.isGranted()) {
                    Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                    if (takePictureIntent.resolveActivity(IntentImages.this.permissions.getActivity().getPackageManager()) != null) {
                        try {
                            File dir = new File(IntentImages.this.permissions.getActivity().getFilesDir(), "hcf_files");
                            if (!dir.mkdirs() && !dir.isDirectory()) {
                                throw new IOException("not a directory or permission denied: " + dir);
                            }
                            File file = new File(dir, "lastCameraImage.jpg");
                            if (!file.delete() && file.exists()) {
                                throw new IOException("cannot delete file: " + file);
                            }
                            if (!file.createNewFile() && !file.isFile()) {
                                throw new IOException("cannot create empty file: " + file);
                            }
                            Uri photoURI = FileProvider.getUriForFile((Context)IntentImages.this.permissions.getActivity(), this.getAuthority(), file);
                            takePictureIntent.putExtra("output", (Parcelable)photoURI);
                            takePictureIntent.addFlags(3);
                            IntentImages.this.fixPermissionsForLegacy(takePictureIntent, photoURI);
                            IntentImages.this.intentManager.startActivityForResult(takePictureIntent, IntentImages.this.requestCodeCamera);
                            resFile.set((Object)Result.create((Object)true));
                        }
                        catch (IOException e) {
                            Result res = Result.create().setThrowable((Throwable)e);
                            resFile.set((Object)res);
                        }
                    } else {
                        resFile.set((Object)Result.create().put("intent.camera.missing"));
                    }
                } else {
                    resFile.set((Object)Result.nullValue(r.asResult()));
                }
            });
            return resFile;
        }

        private String getAuthority() {
            return IntentImages.this.permissions.getActivity().getApplicationContext().getPackageName() + ".hcf.provider";
        }

        @Override
        public void whenReceived(Procedure<Result<Uri>> callback) {
            IntentImages.this.intentManager.registerOnActivityResult(IntentImages.this.requestCodeCamera, (Function<ActivityEventDispatcher.ActivityResult, Boolean>)((Function)activityResult -> {
                if (activityResult.getResultCode() != -1) {
                    callback.apply((Object)Result.create().put("code", (Object)activityResult.getRequestCode()).setThrowable((Throwable)new RuntimeException("unsupported result code: " + activityResult.getRequestCode())));
                } else if (IntentImages.this.getCameraTmpFile().length() > 0L) {
                    Uri photoURI = FileProvider.getUriForFile((Context)IntentImages.this.permissions.getActivity(), this.getAuthority(), IntentImages.this.getCameraTmpFile());
                    callback.apply((Object)Result.create((Object)photoURI));
                } else {
                    IntentImages.asyncParseUris(IntentImages.this.scope, activityResult.getData()).whenDone(resList -> {
                        if (resList.exists() && ((List)resList.get()).size() > 0) {
                            callback.apply((Object)Result.create((Object)((Uri)((List)resList.get()).get(0))));
                        } else {
                            callback.apply((Object)Result.nullValue((Result)resList));
                        }
                    });
                }
                return true;
            }));
        }
    }

    private class PickImage
    implements Intents.ResultIntent<Result<Uri>> {
        private PickImage() {
        }

        @Override
        public Task<Result<Boolean>> invoke() {
            SettableTask resFile = SettableTask.create((String)"IntentImages.pickImage");
            IntentImages.this.permissions.handlePermission("android.permission.READ_EXTERNAL_STORAGE").whenDone(r -> {
                if (r.isGranted()) {
                    try {
                        Intent intent = new Intent();
                        intent.setType("image/*");
                        intent.setAction("android.intent.action.GET_CONTENT");
                        String title = IntentImages.this.intentManager.getContext().getString(R.string.hcf_intent_choose_image);
                        IntentImages.this.intentManager.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)title), IntentImages.this.requestCodeImage);
                    }
                    catch (Exception e) {
                        resFile.set((Object)Result.auto((Throwable)e));
                    }
                } else {
                    resFile.set((Object)Result.nullValue(r.asResult()));
                }
            });
            return resFile;
        }

        @Override
        public void whenReceived(Procedure<Result<Uri>> callback) {
            IntentImages.this.intentManager.registerOnActivityResult(IntentImages.this.requestCodeImage, (Function<ActivityEventDispatcher.ActivityResult, Boolean>)((Function)activityResult -> {
                if (activityResult.getResultCode() != -1) {
                    callback.apply((Object)Result.create().put("code", (Object)activityResult.getRequestCode()).setThrowable((Throwable)new RuntimeException("unsupported result code: " + activityResult.getRequestCode())));
                } else {
                    IntentImages.asyncParseUris(IntentImages.this.scope, activityResult.getData()).whenDone(resList -> {
                        if (resList.exists() && ((List)resList.get()).size() > 0) {
                            callback.apply((Object)Result.create((Object)((Uri)((List)resList.get()).get(0))));
                        } else {
                            callback.apply((Object)Result.nullValue((Result)resList));
                        }
                    });
                }
                return true;
            }));
        }
    }
}

