/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import org.homunculus.android.component.MaterialFont;
import org.homunculus.android.component.R;

public class MaterialFontView
extends View {
    private int mColor;
    private MaterialFont.Icon mIcon;
    private Paint mPaint;
    private float mTextSize;
    private float mTWidth;
    private float mTHeight;

    public MaterialFontView(Context context) {
        super(context);
        this.init();
    }

    public MaterialFontView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MaterialFontView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mColor = ContextCompat.getColor(this.getContext(), R.color.hcf_material_font_view);
        this.mIcon = MaterialFont.Icon.I_HELP_OUTLINE;
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mColor);
        this.mPaint.setTypeface(MaterialFont.getTypeface());
        this.mPaint.setSubpixelText(true);
        this.mPaint.setAntiAlias(true);
        this.mTextSize = 12.0f;
        this.mPaint.setTextSize(this.mTextSize);
    }

    public MaterialFontView setIcon(@Nullable MaterialFont.Icon icon) {
        this.mIcon = icon;
        this.requestLayout();
        return this;
    }

    public void setColor(@ColorInt int colorRes) {
        this.mColor = colorRes;
        this.mPaint.setColor(this.mColor);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIcon == null) {
            return;
        }
        float currentTextWidth = this.mPaint.measureText(this.mIcon.asText());
        float viewWidth = this.getMeasuredWidth();
        float textScale = viewWidth / currentTextWidth;
        this.mPaint.setTextSize(this.mTextSize * textScale);
        this.mTWidth = this.mPaint.measureText(this.mIcon.asText());
        this.mTHeight = this.mTextSize * textScale;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIcon != null) {
            canvas.drawText(this.mIcon.asText(), (float)(this.getWidth() / 2) - this.mTWidth / 2.0f, (float)(this.getHeight() / 2) + this.mTHeight / 2.0f, this.mPaint);
        }
    }
}

