/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionInflater;
import androidx.transition.TransitionManager;
import org.homunculusframework.navigation.Navigation;

public class ViewTransitionAnimator {
    private Navigation mNavigation;
    private Activity mActivity;
    private Transition mForwardTransition = new AutoTransition();
    private Transition mBackwardTransition = new AutoTransition();

    private ViewTransitionAnimator() {
    }

    public ViewTransitionAnimator(Navigation navigation, Activity activity) {
        this.mNavigation = navigation;
        this.mActivity = activity;
    }

    public void setActivityContentView(View view) {
        TransitionManager.beginDelayedTransition((ViewGroup)this.mActivity.getWindow().getDecorView(), this.getTransitionToBeUsed());
        this.mActivity.setContentView(view);
    }

    private Transition getTransitionToBeUsed() {
        Transition transitionToBeUsed = this.mNavigation.wasGoingForward() ? this.mForwardTransition : this.mBackwardTransition;
        return transitionToBeUsed;
    }

    public void addViewToViewGroup(ViewGroup viewGroupToBeAddedTo, View viewToBeAdded, ViewGroup.LayoutParams layoutParams) {
        TransitionManager.beginDelayedTransition(viewGroupToBeAddedTo, this.getTransitionToBeUsed());
        viewGroupToBeAddedTo.addView(viewToBeAdded, layoutParams);
    }

    public void setForwardTransition(int transitionId) {
        this.mForwardTransition = TransitionInflater.from((Context)this.mActivity).inflateTransition(transitionId);
    }

    public void setBackwardTransition(int transitionId) {
        this.mBackwardTransition = TransitionInflater.from((Context)this.mActivity).inflateTransition(transitionId);
    }

    public void setForwardTransition(Transition transition) {
        this.mForwardTransition = transition;
    }

    public void setBackwardTransition(Transition transition) {
        this.mBackwardTransition = transition;
    }
}

