/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;

public class Widget {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger();

    private Widget() {
    }

    public static int generateViewId() {
        int newValue;
        int result;
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    @Nullable
    public static <V extends View> V getChild(ViewGroup parent, Class<V> type) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View v = parent.getChildAt(i);
            if (v == null || !type.isAssignableFrom(v.getClass())) continue;
            return (V)v;
        }
        return null;
    }

    public static void closeKeyboardWhenRequired(Activity activity, MotionEvent event) {
        View v;
        if (event.getAction() == 0 && (v = activity.getCurrentFocus()) instanceof EditText) {
            Rect outRect = new Rect();
            v.getGlobalVisibleRect(outRect);
            if (!outRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                v.clearFocus();
                InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
                if (imm != null) {
                    imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                }
            }
        }
    }
}

