/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator;

import android.view.View;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;

class FieldViewTransferUtil<M> {
    FieldViewTransferUtil() {
    }

    void transferFieldToView(Field field, View view, M model, ConversionAdapter conversionAdapter) {
        conversionAdapter.setFieldValueToView(this.getFieldValue(field, model), view);
    }

    void transferViewToField(View view, Field field, M model, ConversionAdapter conversionAdapter) {
        this.setField(conversionAdapter.getFieldValueFromView(view), field, model);
    }

    boolean isFieldTypeSupported(Field field, M model, ConversionAdapter conversionAdapter) {
        Object value = this.getFieldValue(field, model);
        Class<?> valueClass = value == null ? field.getType() : value.getClass();
        String className = this.getClassNameForGenericType(1, conversionAdapter);
        try {
            return valueClass != null && Class.forName(className).isAssignableFrom(valueClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    boolean isViewTypeSupported(View view, ConversionAdapter conversionAdapter) {
        try {
            String className = this.getClassNameForGenericType(0, conversionAdapter);
            return Class.forName(className).isAssignableFrom(view.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String getClassNameForGenericType(int nrOfArgumentInSignature, ConversionAdapter conversionAdapter) {
        ParameterizedType parameterizedType = (ParameterizedType)conversionAdapter.getClass().getGenericInterfaces()[0];
        if (parameterizedType.getActualTypeArguments().length != 2) {
            throw new RuntimeException("Number of arguments in generic interface does not match ConversionAdapter(2)!");
        }
        if (!(parameterizedType.getActualTypeArguments()[nrOfArgumentInSignature] instanceof Class)) {
            throw new RuntimeException("Argument " + nrOfArgumentInSignature + " is not of type Class!");
        }
        return ((Class)parameterizedType.getActualTypeArguments()[nrOfArgumentInSignature]).getName();
    }

    private Object getFieldValue(Field field, M src) {
        try {
            return field.get(src);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setField(Object value, Field field, M dst) {
        try {
            field.set(dst, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

