/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator;

import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.homunculus.android.component.module.validator.BindingResult;
import org.homunculus.android.component.module.validator.FieldSpecificValidationError;
import org.homunculus.android.component.module.validator.FieldViewTransferUtil;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;
import org.homunculus.android.flavor.Resource;
import org.homunculusframework.annotations.Unfinished;
import org.homunculusframework.lang.Reflection;
import org.slf4j.LoggerFactory;

@Unfinished
public class ModelViewPopulator<T> {
    private List<ConversionAdapter> conversionAdapters = new ArrayList<ConversionAdapter>();
    private FieldViewTransferUtil<T> fieldViewTransferUtil = new FieldViewTransferUtil();

    public void addConversionAdapter(ConversionAdapter conversionAdapter) {
        this.conversionAdapters.add(conversionAdapter);
    }

    public void populateBean(View src, T dst) {
        for (Field field : Reflection.getFields(dst.getClass())) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            field.setAccessible(true);
            this.findObjectViewMatchRecursively(src, field, resource, dst, (view, field1, object) -> this.setViewValueToField(view, field1, object, this.getConversionAdapter(field1, object, view)));
        }
    }

    public void populateView(T src, View dst) {
        for (Field field : Reflection.getFields(src.getClass())) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            field.setAccessible(true);
            this.findObjectViewMatchRecursively(dst, field, resource, src, (view, field1, object) -> this.setFieldValueToSpecificView(view, field1, object, this.getConversionAdapter(field1, object, view)));
        }
    }

    private void findObjectViewMatchRecursively(View dst, Field field, Resource resource, T src, OnMatchFound<T> onMatchFound) {
        if (dst instanceof ViewGroup) {
            View found = dst.findViewById(resource.value());
            if (found != null) {
                onMatchFound.onMatchFound(found, field, src);
            }
        } else if (dst.getId() == resource.value()) {
            onMatchFound.onMatchFound(dst, field, src);
        }
    }

    private void setFieldValueToSpecificView(View dst, Field field, T src, ConversionAdapter conversionAdapter) {
        if (conversionAdapter != null) {
            this.fieldViewTransferUtil.transferFieldToView(field, dst, src, conversionAdapter);
        }
    }

    private void setViewValueToField(View src, Field field, T dst, ConversionAdapter conversionAdapter) {
        if (conversionAdapter != null) {
            this.fieldViewTransferUtil.transferViewToField(src, field, dst, conversionAdapter);
        }
    }

    private boolean setErrorToView(View dst, String error, ConversionAdapter conversionAdapter) {
        if (conversionAdapter != null) {
            conversionAdapter.getErrorHandler().setErrorToView(dst, error);
            return true;
        }
        return false;
    }

    public BindingResult<T> insertErrorState(View dst, BindingResult<T> errors) {
        HashSet errorsWithNoMatchingView = new HashSet();
        errorsWithNoMatchingView.addAll(errors.getFieldSpecificValidationErrors());
        for (FieldSpecificValidationError<T> error : errors.getFieldSpecificValidationErrors()) {
            T model = error.getFieldParent();
            if (model == null || error.getField() == null) continue;
            for (Field field : Reflection.getFields(model.getClass())) {
                Resource resource;
                if (!field.getName().equals(error.getField()) || (resource = field.getAnnotation(Resource.class)) == null) continue;
                field.setAccessible(true);
                this.findObjectViewMatchRecursively(dst, field, resource, model, (view, field1, object) -> {
                    if (this.setErrorToView(view, error.getDefaultMessage(), this.getConversionAdapter(field1, object, view))) {
                        errorsWithNoMatchingView.remove(error);
                    }
                });
            }
        }
        return new BindingResult(errorsWithNoMatchingView, errors.getUnspecificValidationErrors());
    }

    private ConversionAdapter getConversionAdapter(Field field, T object, View view) {
        for (ConversionAdapter conversionAdapter : this.conversionAdapters) {
            if (!this.fieldViewTransferUtil.isFieldTypeSupported(field, object, conversionAdapter) || !this.fieldViewTransferUtil.isViewTypeSupported(view, conversionAdapter)) continue;
            return conversionAdapter;
        }
        LoggerFactory.getLogger(this.getClass()).warn("Could not find ConversionAdapter for view-field combination: " + view.getClass().getSimpleName() + "-" + field.getType().getName());
        return null;
    }

    private static interface OnMatchFound<T> {
        public void onMatchFound(View var1, Field var2, T var3);
    }
}

