/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator.conversionAdapters;

import android.widget.EditText;
import java.text.MessageFormat;
import org.homunculus.android.component.module.validator.ViewErrorHandler;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;
import org.homunculus.android.component.module.validator.viewErrorHandlers.EditTextViewErrorHandler;

public class FloatToEditTextAdapter
implements ConversionAdapter<EditText, Float> {
    @Override
    public void setFieldValueToView(Float value, EditText view) {
        view.setText((CharSequence)MessageFormat.format("{0}", value));
    }

    @Override
    public Float getFieldValueFromView(EditText view) {
        if (view.getText() == null) {
            return null;
        }
        try {
            return Float.valueOf(view.getText().toString());
        }
        catch (NumberFormatException e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public ViewErrorHandler<EditText> getErrorHandler() {
        return new EditTextViewErrorHandler();
    }
}

