/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.core;

import android.content.Context;
import android.content.ContextWrapper;
import androidx.annotation.Nullable;
import org.homunculus.android.compat.CompatApplication;
import org.homunculus.android.compat.EventAppCompatActivity;
import org.homunculusframework.factory.scope.Scope;

public class AndroidScopeContext
extends ContextWrapper {
    private final Scope mScope;

    public AndroidScopeContext(Scope scope, Context base) {
        super(base);
        this.mScope = scope;
    }

    public Scope getScope() {
        return this.mScope;
    }

    @Nullable
    public static Scope getScope(@Nullable Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof EventAppCompatActivity) {
                return ((EventAppCompatActivity)context).getScope();
            }
            if (context instanceof CompatApplication) {
                ((CompatApplication)context).getScope();
            }
            if (context instanceof AndroidScopeContext) {
                return ((AndroidScopeContext)context).getScope();
            }
            if (context instanceof CompatApplication) {
                return ((CompatApplication)context).getScope();
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    @Nullable
    public static <T> T resolve(@Nullable Context context, Class<T> type) {
        Scope scope = AndroidScopeContext.getScope(context);
        if (scope != null) {
            return (T)scope.resolve(type);
        }
        return null;
    }
}

