/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.flavor;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.InflateException;
import org.slf4j.LoggerFactory;

public class AndroidInflaterHandler
implements org.homunculusframework.factory.container.Handler {
    private final Handler mMainHandlerFallback = new Handler(Looper.getMainLooper());
    private final LooperThread[] mLoopers = new LooperThread[8];
    private int mLooperIndex = 0;

    public AndroidInflaterHandler(int threads, int priority) {
        for (int i = 0; i < this.mLoopers.length; ++i) {
            this.mLoopers[i] = new LooperThread("AndroidInflaterHandler " + i, priority);
            this.mLoopers[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable r) {
        LooperThread[] looperThreadArray = this.mLoopers;
        synchronized (this.mLoopers) {
            int idx = this.mLooperIndex;
            do {
                this.mLooperIndex = (this.mLooperIndex + 1) % this.mLoopers.length;
            } while (this.mLoopers[this.mLooperIndex].getLooper() == Looper.myLooper());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.mLoopers[idx].getHandler().post(() -> {
                block3: {
                    try {
                        r.run();
                    }
                    catch (InflateException x) {
                        LoggerFactory.getLogger(AndroidInflaterHandler.class).error("Could not inflate, trying fallback through main...", (Throwable)x);
                        this.mMainHandlerFallback.post(r);
                    }
                    catch (RuntimeException x) {
                        LoggerFactory.getLogger(AndroidInflaterHandler.class).error("Got exception while asyncViewInit", (Throwable)x);
                        String msg = x.getMessage();
                        if (msg == null || !msg.contains("thread")) break block3;
                        LoggerFactory.getLogger(AndroidInflaterHandler.class).error("...detected thread issue, trying fallback through main...", (Throwable)x);
                        this.mMainHandlerFallback.post(r);
                    }
                }
            });
            return;
        }
    }

    private static class LooperThread
    extends HandlerThread {
        private Handler mHandler;
        private Object mHandlerLock = new Object();

        public LooperThread(String name, int priority) {
            super(name, priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Handler getHandler() {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    this.mHandler = new Handler(this.getLooper());
                }
                return this.mHandler;
            }
        }
    }
}

