/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFile {
    private final File file;
    private final Document doc;

    public XMLFile(File file, Document doc) {
        this.file = file;
        this.doc = doc;
    }

    public File getFile() {
        return this.file;
    }

    public Document getDoc() {
        return this.doc;
    }

    public List<Element> collect(Function<Element, Boolean> acceptor) {
        ArrayList<Element> dst = new ArrayList<Element>();
        this.collect(dst, this.doc.getDocumentElement(), acceptor);
        return dst;
    }

    private void collect(List<Element> list, Element root, Function<Element, Boolean> acceptor) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            if (acceptor.apply((Element)node).booleanValue()) {
                list.add((Element)node);
            }
            this.collect(list, (Element)node, acceptor);
        }
    }
}

